/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorCollection;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorConfiguration;
import com.ibm.ws.jsp.translator.visitor.configuration.VisitorConfigParser;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspTranslatorFactory {
    private static Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.JspTranslatorFactory";
    protected static JspTranslatorFactory factory;
    protected JspVisitorConfiguration visitorConfiguration;
    static final long serialVersionUID = -3800384885679305556L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void initialize(String configFilePath) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "initialize", new Object[]{configFilePath});
        }
        factory = new JspTranslatorFactory(configFilePath, JspTranslatorFactory.class.getClassLoader());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "initialize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void initialize(InputStream is) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "initialize", new Object[]{is});
        }
        factory = new JspTranslatorFactory(is, JspTranslatorFactory.class.getClassLoader());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "initialize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JspTranslatorFactory getFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getFactory", new Object[0]);
        }
        JspTranslatorFactory jspTranslatorFactory = factory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspTranslatorFactory = jspTranslatorFactory;
            logger.exiting(CLASS_NAME, "getFactory", jspTranslatorFactory);
        }
        return jspTranslatorFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JspTranslatorFactory createFactory(InputStream is, ClassLoader cl) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createFactory", new Object[]{is, cl});
        }
        JspTranslatorFactory jspTranslatorFactory = new JspTranslatorFactory(is, cl);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspTranslatorFactory = jspTranslatorFactory;
            logger.exiting(CLASS_NAME, "createFactory", jspTranslatorFactory);
        }
        return jspTranslatorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    JspTranslatorFactory(String configFilePath, ClassLoader cl) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{configFilePath, cl});
        }
        this.visitorConfiguration = null;
        InputStream is = null;
        try {
            VisitorConfigParser configParser = new VisitorConfigParser(cl);
            is = this.getClass().getResourceAsStream(configFilePath);
            if (is == null) {
                is = this.getClass().getResourceAsStream("/" + configFilePath);
            }
            if (is != null) {
                this.visitorConfiguration = configParser.parse(is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    JspTranslatorFactory(InputStream is, ClassLoader cl) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{is, cl});
        }
        this.visitorConfiguration = null;
        try {
            VisitorConfigParser configParser = new VisitorConfigParser(cl);
            this.visitorConfiguration = configParser.parse(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspTranslator createTranslator(String visitorCollectionId, JspInputSource inputSource, JspCoreContext context, JspConfiguration jspConfiguration, JspOptions jspOptions) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createTranslator", new Object[]{visitorCollectionId, inputSource, context, jspConfiguration, jspOptions});
        }
        JspTranslator jspTranslator = this.createTranslator(visitorCollectionId, inputSource, context, jspConfiguration, jspOptions, new HashMap());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspTranslator = jspTranslator;
            logger.exiting(CLASS_NAME, "createTranslator", jspTranslator);
        }
        return jspTranslator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspTranslator createTranslator(String visitorCollectionId, JspInputSource inputSource, JspCoreContext context, JspConfiguration jspConfiguration, JspOptions jspOptions, Map implicitTagLibMap) throws JspCoreException {
        JspTranslator translator;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createTranslator", new Object[]{visitorCollectionId, inputSource, context, jspConfiguration, jspOptions, implicitTagLibMap});
        }
        JspVisitorCollection visitorCollection = this.visitorConfiguration.getJspVisitorCollection(visitorCollectionId);
        JspTranslator jspTranslator = translator = new JspTranslator(inputSource, context, jspConfiguration, jspOptions, visitorCollection, implicitTagLibMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspTranslator = jspTranslator;
            logger.exiting(CLASS_NAME, "createTranslator", jspTranslator);
        }
        return jspTranslator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        block2: {
            logger = Logger.getLogger("com.ibm.ws.jsp");
            factory = null;
            try {
                factory = new JspTranslatorFactory("com/ibm/ws/jsp/translator/visitor/configuration/JspVisitorConfiguration.xml", JspTranslatorFactory.class.getClassLoader());
            }
            catch (JspCoreException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.SEVERE)) break block2;
                logger.logp(Level.SEVERE, CLASS_NAME, "static", "Failed to create JspTranslatorFactory", e);
            }
        }
    }
}

