/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.webcontainer.util.DocumentRootUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class JspURLConnection
extends URLConnection {
    private String relativeUrl = null;
    private DocumentRootUtils dru = null;
    private boolean searchOnClasspath = false;
    private ClassLoader classloader = null;
    private String docRoot;
    private ServletContext servletContext;
    static final long serialVersionUID = -3013288851922301832L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JspURLConnection(String docRoot, URL url, String relativeUrl, DocumentRootUtils dru, boolean searchOnClasspath, ClassLoader classloader, ServletContext servletContext) {
        super(url);
        this.docRoot = docRoot;
        this.relativeUrl = relativeUrl;
        this.dru = dru;
        this.searchOnClasspath = searchOnClasspath;
        this.classloader = classloader;
        this.servletContext = servletContext;
        if (this.dru == null) {
            if (servletContext != null) {
                this.dru = new DocumentRootUtils(servletContext, (String)null, (String)null);
            } else if (docRoot != null) {
                this.dru = new DocumentRootUtils(docRoot, (String)null, (String)null);
            }
        }
    }

    @Override
    public void connect() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={IOException.class})
    public InputStream getInputStream() throws IOException {
        InputStream is;
        block9: {
            is = null;
            try {
                URL newURL = new URL(this.url.toExternalForm());
                URLConnection conn = newURL.openConnection();
                conn.setUseCaches(false);
                is = conn.getInputStream();
            }
            catch (IOException e) {
                if (!this.relativeUrl.endsWith(".tag") && !this.relativeUrl.endsWith(".tld") && !this.relativeUrl.endsWith(".jar") && !this.searchOnClasspath) break block9;
                String s = this.relativeUrl;
                if (s.charAt(0) == '/') {
                    s = s.substring(1);
                }
                is = this.classloader.getResourceAsStream(s);
            }
        }
        if (is == null) {
            if (this.dru != null) {
                DocumentRootUtils documentRootUtils = this.dru;
                synchronized (documentRootUtils) {
                    this.dru.handleDocumentRoots(this.relativeUrl);
                    is = this.dru.getInputStream();
                }
            } else {
                throw new IOException(JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{this.url}));
            }
        }
        return is;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.inputsource.JspURLConnection", JspURLConnection.class, null, null);
    }
}

