/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import org.apache.myfaces.cdi.util.BeanProvider;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.view.ViewScopeBeanHolder;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorage;
import org.apache.myfaces.cdi.view._ContextualKey;
import org.apache.myfaces.config.ManagedBeanDestroyer;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.view.ViewScopeProxyMap;

@Typed
public class ViewScopeContextImpl
implements Context {
    private BeanManager beanManager;

    public ViewScopeContextImpl(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected ViewScopeBeanHolder getViewScopeBeanHolder() {
        return this.getViewScopeBeanHolder(FacesContext.getCurrentInstance());
    }

    protected ViewScopeBeanHolder getViewScopeBeanHolder(FacesContext facesContext) {
        ViewScopeBeanHolder viewScopeBeanHolder = (ViewScopeBeanHolder)facesContext.getExternalContext().getApplicationMap().get("oam.view.ViewScopeBeanHolder");
        if (viewScopeBeanHolder == null) {
            viewScopeBeanHolder = BeanProvider.getContextualReference(this.beanManager, ViewScopeBeanHolder.class, false, new Annotation[0]);
            facesContext.getExternalContext().getApplicationMap().put("oam.view.ViewScopeBeanHolder", viewScopeBeanHolder);
        }
        return viewScopeBeanHolder;
    }

    public String getCurrentViewScopeId(boolean create) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewScopeProxyMap map = (ViewScopeProxyMap)facesContext.getViewRoot().getViewMap(create);
        if (map != null) {
            String id = map.getViewScopeId();
            if (id == null && create) {
                map.forceCreateWrappedMap(facesContext);
                id = map.getViewScopeId();
            }
            return id;
        }
        return null;
    }

    protected ViewScopeContextualStorage getContextualStorage(boolean createIfNotExist) {
        String viewScopeId = this.getCurrentViewScopeId(createIfNotExist);
        if (createIfNotExist && viewScopeId == null) {
            throw new ContextNotActiveException("ViewScopeContextImpl: no viewScopeId set for the current view yet!");
        }
        if (viewScopeId != null) {
            return this.getViewScopeBeanHolder().getContextualStorage(this.beanManager, viewScopeId);
        }
        return null;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getViewRoot() != null;
    }

    public <T> T get(Contextual<T> bean) {
        this.checkActive();
        ViewScopeContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return null;
        }
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return null;
        }
        return (T)contextualInstanceInfo.getContextualInstance();
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        this.checkActive();
        if (!(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        ViewScopeContextualStorage storage = this.getContextualStorage(true);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        ViewScopeContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    public void destroyAllActive() {
        ViewScopeContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return;
        }
        ViewScopeContextImpl.destroyAllActive(storage);
    }

    public static void destroyAllActive(ViewScopeContextualStorage storage) {
        ViewScopeContextImpl.destroyAllActive(storage, FacesContext.getCurrentInstance());
    }

    public static void destroyAllActive(ViewScopeContextualStorage storage, FacesContext facesContext) {
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ManagedBeanDestroyer mbDestroyer = ViewScopeContextImpl.getManagedBeanDestroyer(facesContext.getExternalContext());
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
            if (!(entry.getKey() instanceof _ContextualKey)) {
                Contextual<?> bean = storage.getBean(entry.getKey());
                ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
                bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
                continue;
            }
            _ContextualKey key = (_ContextualKey)entry.getKey();
            mbDestroyer.destroy(key.getName(), entry.getValue().getContextualInstance());
        }
        contextMap.clear();
        storage.deactivate();
    }

    protected void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    protected static ManagedBeanDestroyer getManagedBeanDestroyer(ExternalContext externalContext) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        LifecycleProvider lifecycleProvider = LifecycleProviderFactory.getLifecycleProviderFactory(externalContext).getLifecycleProvider(externalContext);
        return new ManagedBeanDestroyer(lifecycleProvider, runtimeConfig);
    }
}

