/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JtiNonceCache {
    private static final TraceComponent tc = Tr.register(JtiNonceCache.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private final Map<String, Object> primaryTable;
    private int entryLimit = 100000;
    private long timeoutInMilliSeconds = 600000L;
    private Timer timer;
    static final long serialVersionUID = 6445475133035364208L;

    public JtiNonceCache() {
        this(0, 0L);
    }

    public JtiNonceCache(int entryLimit, long timeoutInMilliSeconds) {
        if (entryLimit > 0) {
            this.entryLimit = entryLimit;
        }
        this.primaryTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        if (timeoutInMilliSeconds > 0L) {
            this.timeoutInMilliSeconds = timeoutInMilliSeconds;
        }
        this.scheduleEvictionTask(this.timeoutInMilliSeconds);
    }

    public int size() {
        return this.entryLimit;
    }

    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        long period;
        EvictionTask evictionTask = new EvictionTask();
        this.timer = new Timer(true);
        long delay = period = timeoutInMilliSeconds;
        this.timer.schedule((TimerTask)evictionTask, delay, period);
    }

    public void remove(Object key) {
        this.primaryTable.remove(key);
    }

    public Object get(String key) {
        Object curEntry = this.primaryTable.get(key);
        return curEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contain(OidcTokenImplBase token) {
        String key = token.getJwtId();
        if (key == null) {
            return false;
        }
        key = this.getCacheKey(token);
        long currentTimeMilliseconds = new Date().getTime();
        Map<String, Object> map = this.primaryTable;
        synchronized (map) {
            long tokenExp;
            Long exp = (Long)this.primaryTable.get(key);
            if (exp != null) {
                if (exp > currentTimeMilliseconds) {
                    return true;
                }
                this.primaryTable.remove(key);
            }
            if ((tokenExp = token.getExpirationTimeSeconds() * 1000L) == 0L) {
                tokenExp = currentTimeMilliseconds + 3600000L;
            }
            this.primaryTable.put(key, tokenExp);
        }
        return false;
    }

    public void cache(OidcTokenImplBase token) {
        String jti = token.getJwtId();
        if (jti == null) {
            return;
        }
        String key = this.getCacheKey(token);
        long tokenExp = token.getExpirationTimeSeconds() * 1000L;
        if (tokenExp == 0L) {
            tokenExp = new Date().getTime() + 3600000L;
        }
        this.primaryTable.put(key, tokenExp);
    }

    protected String getCacheKey(OidcTokenImplBase token) {
        String key = token.getJwtId();
        if (key == null) {
            return null;
        }
        key = token.getIssuer() + ":" + key;
        return key;
    }

    protected synchronized void evictStaleEntries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int size = this.primaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size), (Object[])new Object[0]);
        }
        HashMap<String, Object> secondaryTable = new HashMap<String, Object>();
        secondaryTable.putAll(this.primaryTable);
        Set<String> keysToRemove = this.findExpiredTokens(secondaryTable);
        this.removeExpiredTokens(keysToRemove);
        secondaryTable.clear();
    }

    protected Set<String> findExpiredTokens(Map<String, Object> allTokens) {
        Set<String> keys = allTokens.keySet();
        HashSet<String> keysToRemove = new HashSet<String>();
        long lCurrentTimeMilliseconds = new Date().getTime();
        for (String key : keys) {
            Long exp = (Long)allTokens.get(key);
            if (exp >= lCurrentTimeMilliseconds) continue;
            keysToRemove.add(key);
        }
        return keysToRemove;
    }

    protected void removeExpiredTokens(Set<String> keysToRemove) {
        for (String key : keysToRemove) {
            this.primaryTable.remove(key);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    extends TimerTask {
        static final long serialVersionUID = 9078292509768243209L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            JtiNonceCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.clients.common.JtiNonceCache$EvictionTask", EvictionTask.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
        }
    }
}

