/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.extension;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.config.internal.common.ConfigIntrospectionProvider;
import io.openliberty.microprofile.config.internal.extension.ConfigWrapper;
import io.openliberty.microprofile.config.internal.extension.OLSmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ConfigProviderResolver.class, ApplicationStateListener.class, ConfigIntrospectionProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, immediate=true)
public class OLSmallRyeConfigProviderResolver
extends SmallRyeConfigProviderResolver
implements ApplicationStateListener,
ConfigIntrospectionProvider {
    public static final String GLOBAL_CONFIG_APPLICATION_NAME = "!GLOBAL_CONFIG_APPLICATION_NAME!";
    private final Map<Config, ConfigWrapper> configCache = new HashMap<Config, ConfigWrapper>();
    static final long serialVersionUID = -6467437592588013923L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void activate(ComponentContext cc) {
        ConfigProviderResolver.setInstance((ConfigProviderResolver)this);
    }

    public void deactivate(ComponentContext cc) throws IOException {
        ConfigProviderResolver.setInstance(null);
    }

    @Override
    public SmallRyeConfigBuilder getBuilder() {
        return new OLSmallRyeConfigBuilder().addDefaultInterceptors();
    }

    @Override
    public void registerConfig(Config config, ClassLoader classLoader) {
        super.registerConfig(config, classLoader);
        this.registerConfig(config, classLoader, OLSmallRyeConfigProviderResolver.getApplicationName());
    }

    @Override
    public Config getConfig(ClassLoader classLoader) {
        Config config = super.getConfig(classLoader);
        this.registerConfig(config, classLoader, OLSmallRyeConfigProviderResolver.getApplicationName());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConfig(Config config, ClassLoader classLoader, String applicationName) {
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            ConfigWrapper wrapper = this.configCache.computeIfAbsent(config, cfg -> new ConfigWrapper((Config)cfg));
            wrapper.addApplication(applicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConfig(Config config) {
        super.releaseConfig(config);
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            this.configCache.remove(config);
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStopping(ApplicationInfo appInfo) {
        ExtendedApplicationInfo extendedAppInfo = (ExtendedApplicationInfo)appInfo;
        String applicationName = extendedAppInfo.getMetaData().getJ2EEName().getApplication();
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            HashSet<Config> configsToRelease = new HashSet<Config>();
            for (ConfigWrapper wrapper : this.configCache.values()) {
                boolean release = wrapper.removeApplication(applicationName);
                if (!release) continue;
                configsToRelease.add(wrapper.getConfig());
            }
            for (Config config : configsToRelease) {
                this.releaseConfig(config);
            }
        }
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        this.applicationStopping(appInfo);
    }

    private static String getApplicationName() {
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        ComponentMetaData cmd = cmdai.getComponentMetaData();
        String applicationName = null;
        if (cmd != null) {
            J2EEName applicationJEEName = cmd.getModuleMetaData().getApplicationMetaData().getJ2EEName();
            applicationName = applicationJEEName.getApplication();
        }
        if (applicationName == null) {
            applicationName = GLOBAL_CONFIG_APPLICATION_NAME;
        }
        return applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<Config>> getConfigsByApplication() {
        HashMap<String, Set<Config>> appInfos = new HashMap<String, Set<Config>>();
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            for (ConfigWrapper wrapper : this.configCache.values()) {
                for (String appName : wrapper.listApplications()) {
                    appInfos.computeIfAbsent(appName, x -> new HashSet()).add(wrapper.getConfig());
                }
            }
        }
        return appInfos;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.extension.OLSmallRyeConfigProviderResolver", OLSmallRyeConfigProviderResolver.class, (String)"APPCONFIG", null);
    }
}

