/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ChainDataImpl;
import com.ibm.ws.channelfw.internal.ChildChannelDataImpl;
import com.ibm.wsspi.channelfw.ChannelFramework;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChannelDataImpl
implements ChannelData {
    private static final long serialVersionUID = -280440118973381476L;
    private static final TraceComponent tc = Tr.register(ChannelDataImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    public static final String CHILD_STRING = "_CFINTERNAL_CHILD_";
    private String name = null;
    private transient Map<Object, Object> properties = null;
    private Class<?> factoryType = null;
    private int discWeight = 0;
    private transient ChannelFramework framework = null;
    private int childId = 0;
    private List<ChildChannelDataImpl> children = null;
    private Class<?> deviceInterface;
    private boolean isInbound = true;

    public ChannelDataImpl(String channelName, Class<?> factoryType, Map<Object, Object> propertyBag, int discriminatorWeight, ChannelFramework inputCF) {
        this.name = channelName;
        this.factoryType = factoryType;
        this.properties = propertyBag;
        this.discWeight = discriminatorWeight;
        this.isInbound = this.discWeight != 10;
        this.deviceInterface = null;
        this.framework = inputCF;
        this.childId = 0;
        this.children = new ArrayList<ChildChannelDataImpl>(0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getFactoryType() {
        return this.factoryType;
    }

    @Override
    public Map<Object, Object> getPropertyBag() {
        return this.properties;
    }

    public void setPropertyBag(Map<Object, Object> inputProperties) {
        this.properties = inputProperties;
    }

    public void setProperty(Object propertyKey, Object propertyValue) {
        this.properties.put(propertyKey, propertyValue);
    }

    @Override
    public int getDiscriminatorWeight() {
        return this.discWeight;
    }

    public void setDiscriminatorWeight(int inputWeight) {
        this.discWeight = inputWeight;
    }

    public Class<?> getDeviceInterface() {
        return this.deviceInterface;
    }

    public void setDeviceInterface(Class<?> inputDeviceInterface) {
        this.deviceInterface = inputDeviceInterface;
    }

    @Override
    public boolean isInbound() {
        return this.isInbound;
    }

    @Override
    public boolean isOutbound() {
        return !this.isInbound;
    }

    public void setIsInbound(boolean inputIsInbound) {
        this.isInbound = inputIsInbound;
    }

    public ChannelFramework getChannelFramework() {
        return this.framework;
    }

    @Override
    public String getExternalName() {
        return this.getName();
    }

    private int nextChildId() {
        return this.childId++;
    }

    public ChildChannelDataImpl createChild() {
        String childName = this.name + CHILD_STRING + this.nextChildId();
        ChildChannelDataImpl child = new ChildChannelDataImpl(childName, this);
        this.children.add(child);
        return child;
    }

    public ChildChannelDataImpl getInboundChild() {
        for (ChildChannelDataImpl child : this.children) {
            if (!child.isInbound()) continue;
            return child;
        }
        return null;
    }

    public ChildChannelDataImpl getOutboundChild() {
        for (ChildChannelDataImpl child : this.children) {
            if (!child.isOutbound()) continue;
            return child;
        }
        return null;
    }

    public void removeChild(ChildChannelDataImpl child) {
        this.children.remove(child);
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public Iterator<ChildChannelDataImpl> children() {
        return this.children.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("ChannelData:");
        sb.append("\r\n\tname = ").append(this.name);
        sb.append("\r\n\tdiscweight = ").append(this.discWeight);
        sb.append("\r\n\tfactoryType = ").append(this.factoryType);
        sb.append("\r\n\tdeviceInterface = ").append(this.deviceInterface);
        sb.append("\r\n");
        if (null != this.properties) {
            sb.append("\tproperties: ").append(this.properties.size()).append("\r\n");
            Object[] keys = this.properties.keySet().toArray();
            Object[] values = this.properties.values().toArray();
            for (int i = 0; i < keys.length; ++i) {
                sb.append("\t\tkey = ").append(keys[i]).append(", value = ");
                if (values[i] instanceof ChainDataImpl) {
                    sb.append(((ChainDataImpl)values[i]).getName());
                } else {
                    sb.append(values[i]);
                }
                sb.append("\r\n");
            }
        }
        sb.append("\tchildId = ").append(this.childId).append("\r\n");
        sb.append("\tchildren: ").append(this.children.size()).append("\r\n");
        for (ChildChannelDataImpl child : this.children) {
            sb.append("\t\tchild = ").append(child.getName()).append("\r\n");
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        HashMap<Object, Object> tempProperties = new HashMap<Object, Object>();
        for (Object key : this.properties.keySet()) {
            Object value = this.properties.get(key);
            if (value instanceof Serializable || value instanceof Externalizable) {
                tempProperties.put(key, value);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("value for key \"" + key + "\" is not serializable"), (Object[])new Object[0]);
        }
        stream.writeObject(tempProperties);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.properties = (Map)stream.readObject();
    }
}

