/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import java.util.BitSet;

public class LookupTable<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    private static final int DEFAULT_INCREMENT = 1000;
    private E[] theElementArray;
    private int currentCapacity;
    private volatile int increment = 1000;
    private int elementCount;
    private BitSet occupiedSlots;

    public LookupTable(int initialCapacity) {
        this(initialCapacity, 1000);
    }

    public LookupTable(int initialCapacity, int initialIncrement) {
        int cap = initialCapacity;
        if (cap < 0) {
            throw new IllegalArgumentException("Capacity cannot be <0");
        }
        if (cap == 0) {
            cap = 1000;
        }
        this.theElementArray = new Object[cap];
        this.currentCapacity = cap;
        this.occupiedSlots = new BitSet(cap);
        this.elementCount = 0;
        this.increment = initialIncrement;
    }

    public synchronized E lookupElement(int theIndex) {
        if (theIndex < 0 || theIndex > this.currentCapacity - 1) {
            return null;
        }
        return this.theElementArray[theIndex];
    }

    public synchronized int addElement(E theElement) {
        int theIndex;
        if (theElement == null) {
            return -1;
        }
        if (this.elementCount == this.currentCapacity) {
            this.expandTable();
        }
        if ((theIndex = this.occupiedSlots.nextClearBit(0)) < 0 || theIndex > this.currentCapacity - 1) {
            throw new IllegalStateException("No space available for element");
        }
        this.theElementArray[theIndex] = theElement;
        ++this.elementCount;
        this.occupiedSlots.set(theIndex);
        return theIndex;
    }

    public synchronized Object removeElement(int theIndex) {
        if (theIndex < 0 || theIndex > this.currentCapacity - 1) {
            throw new IllegalArgumentException("Index is out of range.");
        }
        E theElement = this.theElementArray[theIndex];
        if (theElement != null) {
            this.theElementArray[theIndex] = null;
            --this.elementCount;
            this.occupiedSlots.clear(theIndex);
        }
        return theElement;
    }

    public int findElement(Object element) {
        for (int i = 0; i < this.currentCapacity; ++i) {
            if (element != this.theElementArray[i]) continue;
            return i;
        }
        return -1;
    }

    public void setIncrement(int theIncrement) {
        if (theIncrement <= 0) {
            throw new IllegalArgumentException("Increment must be >0");
        }
        this.increment = theIncrement;
    }

    private void expandTable() {
        int newCapacity = this.currentCapacity + this.increment;
        if (newCapacity < this.currentCapacity) {
            throw new IllegalStateException("Attempt to expand LookupTable beyond maximum capacity");
        }
        Object[] theNewArray = new Object[newCapacity];
        System.arraycopy(this.theElementArray, 0, theNewArray, 0, this.currentCapacity);
        this.theElementArray = theNewArray;
        this.currentCapacity = newCapacity;
    }
}

