/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.cli;

import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.featureUtility.cli.FeatureHelpAction;
import com.ibm.ws.install.featureUtility.cli.FindAction;
import com.ibm.ws.install.featureUtility.cli.InstallFeatureAction;
import com.ibm.ws.install.featureUtility.cli.InstallServerAction;
import com.ibm.ws.install.featureUtility.cli.ViewSettingsAction;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.kernel.boot.cmdline.ActionDefinition;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.feature.internal.cmdline.ArgumentsImpl;
import com.ibm.ws.kernel.feature.internal.cmdline.FeatureToolException;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public enum FeatureAction implements ActionDefinition
{
    installFeature(new InstallFeatureAction(), "if", -1, "--noCache", "--verbose", "--acceptLicense", "name..."),
    installServerFeatures(new InstallServerAction(), "isf", -1, "--noCache", "--verbose", "--acceptLicense", "name..."),
    viewSettings(new ViewSettingsAction(), "", 0, "--viewValidationMessages"),
    find(new FindAction(), "", -1, "[searchString]"),
    help(new FeatureHelpAction(), "", 0, new String[0]);

    private List<String> commandOptions;
    private ActionHandler action;
    private int positionalOptions;
    private String abbreviation;

    private FeatureAction(ActionHandler a, String abbreviationString, int count, String ... args) {
        this.commandOptions = Collections.unmodifiableList(Arrays.asList(args));
        this.action = a;
        this.positionalOptions = count;
        this.abbreviation = abbreviationString;
    }

    public List<String> getCommandOptions() {
        return this.commandOptions;
    }

    public int numPositionalArgs() {
        return this.positionalOptions;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static FeatureAction getEnum(String name) {
        for (FeatureAction action : FeatureAction.values()) {
            if (!action.toString().equals(name) && !action.getAbbreviation().equals(name)) continue;
            return action;
        }
        throw new IllegalArgumentException(name);
    }

    public ExitCode handleTask(Arguments args) {
        try {
            InstallKernel installKernel = InstallKernelFactory.getInstance();
            String verboseLevel = args.getOption("verbose");
            Level logLevel = Level.INFO;
            if (verboseLevel != null && verboseLevel.isEmpty()) {
                logLevel = Level.FINEST;
            } else if (verboseLevel != null && !verboseLevel.isEmpty()) {
                System.out.println(NLS.getMessage((String)"unknown.options", (Object[])new Object[]{args.getAction(), "--verbose=" + verboseLevel}));
                help.handleTask((Arguments)new ArgumentsImpl(new String[]{"help", FeatureAction.getEnum(args.getAction()).toString()}));
                return ReturnCode.BAD_ARGUMENT;
            }
            ((InstallKernelImpl)installKernel).enableConsoleLog(logLevel);
            return this.action.handleTask(System.out, System.err, args);
        }
        catch (FeatureToolException fte) {
            System.err.println(fte.getMessage());
            fte.printStackTrace();
            return fte.getReturnCode();
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return ReturnCode.RUNTIME_EXCEPTION;
        }
    }

    public boolean showOptions() {
        List<String> options = this.getCommandOptions();
        for (String option : options) {
            if (!option.startsWith("-")) continue;
            return true;
        }
        return false;
    }
}

