/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos.auth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper;
import com.ibm.ws.security.kerberos.auth.internal.Krb5CallbackHandler;
import com.ibm.ws.security.kerberos.auth.internal.LRUCache;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={KerberosService.class}, configurationPid={"com.ibm.ws.security.kerberos.auth.KerberosService"}, immediate=true, property={"service.vendor=IBM"})
public class KerberosService {
    private static final TraceComponent tc = Tr.register(KerberosService.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
    private static final String KRB5_CONFIG_PROPERTY = "java.security.krb5.conf";
    static SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private Path keytab;
    private Path configFile;
    private final LRUCache subjectCache = new LRUCache(2500);
    static final long serialVersionUID = 4490434668452409064L;

    @ManualTrace
    @Activate
    @FFDCIgnore(value={MalformedURLException.class, URISyntaxException.class, IllegalArgumentException.class})
    protected void activate(ComponentContext ctx) {
        String rawConfigFile;
        block22: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"activate", (Object[])new Object[]{ctx.getProperties()});
            }
            String rawKeytab = (String)ctx.getProperties().get("keytab");
            rawConfigFile = (String)ctx.getProperties().get("configFile");
            if (rawKeytab != null) {
                this.keytab = Paths.get(rawKeytab, new String[0]);
                if (this.keytab.toFile().exists()) {
                    if (tc.isInfoEnabled()) {
                        Tr.info((TraceComponent)tc, (String)"KRB5_FILE_FOUND_CWWKS4346I", (Object[])new Object[]{"keytab", this.keytab.toAbsolutePath()});
                    }
                } else {
                    try {
                        URL keytabUrl;
                        File keytabFile;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"rawKeytab is not a path to a file. Checking if it is a file URL.", (Object[])new Object[0]);
                        }
                        if ((keytabFile = new File((keytabUrl = new URL(rawKeytab)).toURI())).exists()) {
                            if (tc.isInfoEnabled()) {
                                Tr.info((TraceComponent)tc, (String)"KRB5_FILE_FOUND_CWWKS4346I", (Object[])new Object[]{"keytab", rawKeytab});
                            }
                            break block22;
                        }
                        Tr.error((TraceComponent)tc, (String)"KRB5_FILE_NOT_FOUND_CWWKS4345E", (Object[])new Object[]{"keytab", "<kerberos>", rawKeytab});
                    }
                    catch (MalformedURLException ex) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Could not find keytab as a Path or URL: ", (Object[])new Object[]{ex});
                        }
                        Tr.error((TraceComponent)tc, (String)"KRB5_FILE_NOT_FOUND_CWWKS4345E", (Object[])new Object[]{"keytab", "<kerberos>", rawKeytab});
                    }
                    catch (URISyntaxException ex) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Could not find keytab as a Path or URL: ", (Object[])new Object[]{ex});
                        }
                        Tr.error((TraceComponent)tc, (String)"KRB5_FILE_NOT_FOUND_CWWKS4345E", (Object[])new Object[]{"keytab", "<kerberos>", rawKeytab});
                    }
                    catch (IllegalArgumentException ex) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Could not find keytab as a Path or URL: ", (Object[])new Object[]{ex});
                        }
                        Tr.error((TraceComponent)tc, (String)"KRB5_FILE_NOT_FOUND_CWWKS4345E", (Object[])new Object[]{"keytab", "<kerberos>", rawKeytab});
                    }
                }
            } else {
                this.keytab = null;
            }
        }
        if (rawConfigFile != null) {
            this.configFile = Paths.get(rawConfigFile, new String[0]);
            String originalConfigFile = priv.getProperty(KRB5_CONFIG_PROPERTY);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting system property java.security.krb5.conf=" + this.configFile.toAbsolutePath().toString() + "  Previous value was: " + originalConfigFile), (Object[])new Object[0]);
            }
            priv.setProperty(KRB5_CONFIG_PROPERTY, this.configFile.toAbsolutePath().toString());
            if (this.configFile.toFile().exists()) {
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"KRB5_FILE_FOUND_CWWKS4346I", (Object[])new Object[]{"configFile", this.configFile.toAbsolutePath()});
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"KRB5_FILE_NOT_FOUND_CWWKS4345E", (Object[])new Object[]{"configFile", "<kerberos>", this.configFile.toAbsolutePath()});
            }
        } else {
            this.configFile = null;
        }
    }

    @Modified
    protected void modified(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Kerberos config modified. Re-running activate", (Object[])new Object[0]);
        }
        this.subjectCache.clear();
        this.activate(ctx);
    }

    public Path getConfigFile() {
        return this.configFile;
    }

    public Path getKeytab() {
        return this.keytab;
    }

    public Subject getOrCreateSubject(String principal) throws LoginException {
        return this.getOrCreateSubject(principal, null, null);
    }

    public Subject getOrCreateSubject(String principal, SerializableProtectedString pass, Path ccache) throws LoginException {
        KerberosPrincipal krb5Principal = new KerberosPrincipal(principal);
        Subject cachedSubject = this.subjectCache.get(krb5Principal);
        if (cachedSubject != null) {
            return cachedSubject;
        }
        Subject createdSubject = this.doKerberosLogin(principal, pass, ccache);
        this.subjectCache.put(krb5Principal, createdSubject);
        return createdSubject;
    }

    private Subject doKerberosLogin(String principal, SerializableProtectedString pass, Path ccache) throws LoginException {
        final Subject subject = new Subject();
        Krb5LoginModuleWrapper krb5 = new Krb5LoginModuleWrapper();
        HashMap<String, String> options = new HashMap<String, String>();
        HashMap sharedState = new HashMap();
        Krb5CallbackHandler callback = pass == null ? null : new Krb5CallbackHandler(pass);
        options.put("isInitiator", "true");
        options.put("refreshKrb5Config", "true");
        if (callback == null) {
            options.put("doNotPrompt", "true");
        }
        options.put("clearPass", "true");
        if (ccache != null) {
            options.put("useTicketCache", "true");
            options.put("ticketCache", ccache.toAbsolutePath().toString());
        }
        options.put("useKeyTab", "true");
        if (this.keytab != null) {
            options.put("keyTab", this.keytab.toAbsolutePath().toString());
        }
        options.put("principal", principal);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            options.put("debug", "true");
            Tr.debug((TraceComponent)tc, (String)("All kerberos config properties are: " + options), (Object[])new Object[0]);
        }
        krb5.initialize(subject, callback, sharedState, options);
        krb5.login();
        krb5.commit();
        Set<GSSCredential> gssCreds = subject.getPrivateCredentials(GSSCredential.class);
        if (gssCreds == null || gssCreds.size() == 0) {
            final GSSCredential gssCred = SubjectHelper.createGSSCredential((Subject)subject);
            if (System.getSecurityManager() == null) {
                subject.getPrivateCredentials().add(gssCred);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 2008816093498334290L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Void run() {
                        subject.getPrivateCredentials().add(gssCred);
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.kerberos.auth.KerberosService$1", 1.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
                    }
                });
            }
        }
        return subject;
    }
}

