/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.ejbcontainer;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_StubPluginImpl;
import java.util.Arrays;
import java.util.List;

public final class JITDeploy {
    private static final TraceComponent tc = Tr.register(JITDeploy.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");
    public static final String rmicCompatible = "com.ibm.websphere.ejbcontainer.rmicCompatible";
    public static final int RMICCompatible = JITDeploy.parseRMICCompatible(System.getProperty("com.ibm.websphere.ejbcontainer.rmicCompatible"));
    public static final String throwRemoteFromEjb3Stub = "com.ibm.websphere.ejbcontainer.ejb3StubThrowsRemote";
    public static final boolean ThrowRemoteFromEjb3Stub = Boolean.getBoolean("com.ibm.websphere.ejbcontainer.ejb3StubThrowsRemote");
    private static final int RMIC_COMPATIBLE_DEFAULT = 0;
    private static final int RMIC_COMPATIBLE_VALUES = 1;
    private static final int RMIC_COMPATIBLE_EXCEPTIONS = 2;

    private JITDeploy() {
        throw new IllegalStateException();
    }

    public static List<String> getRMICCompatibleOptions() {
        return Arrays.asList("none", "all", "values", "exceptions");
    }

    public static int parseRMICCompatible(String options) {
        int flags;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseRMICCompatible: " + options), (Object[])new Object[0]);
        }
        if (options == null) {
            flags = 0;
        } else if (options.equals("none")) {
            flags = 0;
        } else if (options.isEmpty() || options.equals("all")) {
            flags = -1;
        } else {
            flags = 0;
            for (String option : options.split(",")) {
                if (option.equals("values")) {
                    flags |= 1;
                    continue;
                }
                if (option.equals("exceptions")) {
                    flags |= 2;
                    continue;
                }
                throw new IllegalArgumentException("unknown RMIC compatibility option: " + option);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("parseRMICCompatible: " + Integer.toHexString(flags)));
        }
        return flags;
    }

    public static boolean isRMICCompatibleValues(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isRMICCompatibleExceptions(int flags) {
        return (flags & 2) != 0;
    }

    public static String getStubClassName(Class<?> remoteInterface) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getStubClassName : " + remoteInterface.getName()), (Object[])new Object[0]);
        }
        String result = JIT_Stub.getStubClassName(remoteInterface.getName());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getStubClassName : " + result));
        }
        return result;
    }

    public static byte[] generateStubBytes(Class<?> remoteInterface) throws EJBConfigurationException {
        return JITDeploy.generateStubBytes(remoteInterface, RMICCompatible);
    }

    public static byte[] generateStubBytes(Class<?> remoteInterface, int rmicCompatible) throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateStubBytes : " + remoteInterface.getName() + ", rmicCompatible=" + rmicCompatible), (Object[])new Object[0]);
        }
        byte[] stubBytes = JIT_Stub.generateStubBytes(remoteInterface, rmicCompatible);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateStubBytes : " + stubBytes.length + " bytes"));
        }
        return stubBytes;
    }

    public static void registerJIT_StubClassPlugin(ClassLoader classloader) {
        boolean isRegistered = JIT_StubPluginImpl.register(classloader);
        if (!isRegistered) {
            throw new IllegalArgumentException("Specified ClassLoader does not support JIT_StubClassPlugin : " + classloader);
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Property: RMICCompatible          = " + Integer.toHexString(RMICCompatible)), (Object[])new Object[0]);
        }
    }
}

