/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal.naming;

import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ejbcontainer.AmbiguousEJBReferenceException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
abstract class EJBNamingInstancer {
    protected volatile boolean homeRuntime;
    protected volatile boolean remoteRuntime;
    private static final TraceComponent tc = Tr.register(EJBNamingInstancer.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.osgi.internal.resources.EJBContainerMessages");
    static final long serialVersionUID = 3324356804805540886L;

    EJBNamingInstancer() {
    }

    @FFDCIgnore(value={ContainerEJBException.class})
    protected Object initializeEJB(EJBBinding binding, String jndiName) throws NamingException {
        Object instance = null;
        if (binding == null) {
            return null;
        }
        if (binding.isHome() && !this.homeRuntime) {
            this.throwCannotInstantiateUnsupported(binding, jndiName, "JNDI_CANNOT_INSTANTIATE_HOME_CNTR4008E");
        }
        if (!binding.isLocal && !this.remoteRuntime) {
            this.throwCannotInstantiateUnsupported(binding, jndiName, "JNDI_CANNOT_INSTANTIATE_REMOTE_CNTR4009E");
        }
        try {
            EJSHome home = binding.homeRecord.getHomeAndInitialize();
            if (binding.isHome()) {
                EJSWrapperCommon wc = home.getWrapper();
                instance = binding.isLocal ? wc.getLocalObject() : home.getContainer().getEJBRuntime().getRemoteReference(wc.getRemoteWrapper());
            } else {
                instance = binding.isLocal ? home.createLocalBusinessObject(binding.interfaceIndex, null) : home.createRemoteBusinessObject(binding.interfaceIndex, null);
            }
        }
        catch (Throwable t) {
            this.throwCannotInstantiateObjectException(binding, jndiName, t);
        }
        return instance;
    }

    private void throwCannotInstantiateUnsupported(EJBBinding binding, String jndiName, String messageId) throws NameNotFoundException {
        J2EEName j2eeName = this.getJ2EEName(binding);
        String msgTxt = Tr.formatMessage((TraceComponent)tc, (String)messageId, (Object[])new Object[]{binding.interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), jndiName});
        throw new NameNotFoundException(msgTxt);
    }

    private void throwCannotInstantiateObjectException(EJBBinding binding, String jndiName, Throwable cause) throws NamingException {
        J2EEName j2eeName = this.getJ2EEName(binding);
        String causeMsg = cause.getLocalizedMessage();
        if (causeMsg == null) {
            causeMsg = cause.toString();
        }
        String msgTxt = Tr.formatMessage((TraceComponent)tc, (String)"JNDI_CANNOT_INSTANTIATE_OBJECT_CNTR4007E", (Object[])new Object[]{binding.interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), jndiName, causeMsg});
        NamingException nex = new NamingException(msgTxt);
        nex.initCause(cause);
        throw nex;
    }

    protected void throwAmbiguousEJBReferenceException(EJBBinding binding, String jndiName) throws NamingException {
        String message = binding.j2eeNames.size() > 1 ? "The short-form default binding '" + jndiName + "' is ambiguous because multiple beans implement this interface : " + binding.j2eeNames + ". Provide an interface specific binding or use the long-form default binding on lookup." : "The simple-binding-name '" + jndiName + "' for bean " + binding.homeRecord.getJ2EEName() + " is ambiguous because the bean implements multiple interfaces.  Provide an interface specific binding or add #<interface> to the simple-binding-name on lookup.";
        AmbiguousEJBReferenceException amEx = new AmbiguousEJBReferenceException(message);
        this.throwCannotInstantiateObjectException(binding, jndiName, (Throwable)((Object)amEx));
    }

    protected J2EEName getJ2EEName(EJBBinding binding) {
        return binding.homeRecord.getJ2EEName();
    }
}

