/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BindingsHelper;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.csi.EJBApplicationMetaData;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.websphere.csi.HomeWrapperSet;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.naming.EJBLocalNamingHelper;
import com.ibm.ws.container.service.naming.LocalColonEJBNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.EJBRemoteRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.HomeRecordImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBJavaColonNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBRemoteReferenceBinding;
import com.ibm.ws.ejbcontainer.runtime.NameSpaceBinder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NameSpaceBinderImpl
implements NameSpaceBinder<EJBBinding> {
    private static TraceComponent tc = Tr.register(NameSpaceBinderImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String JNDI_SERVICENAME = "osgi.jndi.service.name";
    protected final EJBModuleMetaDataImpl moduleMetaData;
    private final EJBJavaColonNamingHelper ejbJavaColonHelper;
    private final EJBLocalNamingHelper<EJBBinding> ejbLocalNamingHelper;
    private final LocalColonEJBNamingHelper<EJBBinding> localColonNamingHelper;
    private final AtomicServiceReference<EJBRemoteRuntime> ejbRemoteRuntimeServiceRef;
    private static final List<ServiceRegistration<?>> registrations = Collections.synchronizedList(new ArrayList());
    private static final HashMap<String, EJBBinding> svRemoteBindings = new HashMap();
    private final ReentrantReadWriteLock remoteLock = new ReentrantReadWriteLock();
    static final long serialVersionUID = -5545306072883149514L;

    NameSpaceBinderImpl(EJBModuleMetaDataImpl mmd, EJBJavaColonNamingHelper jcnh, EJBLocalNamingHelper<EJBBinding> ejblocal, LocalColonEJBNamingHelper<EJBBinding> localColon, AtomicServiceReference<EJBRemoteRuntime> remoteRuntimeRef) {
        this.moduleMetaData = mmd;
        this.ejbJavaColonHelper = jcnh;
        this.ejbLocalNamingHelper = ejblocal;
        this.localColonNamingHelper = localColon;
        this.ejbRemoteRuntimeServiceRef = remoteRuntimeRef;
    }

    @Override
    public void beginBind() {
    }

    @Override
    public EJBBinding createBindingObject(HomeRecord hr, HomeWrapperSet homeSet, String interfaceName, int interfaceIndex, boolean local) {
        return new EJBBinding(hr, interfaceName, interfaceIndex, local);
    }

    @Override
    public EJBBinding createJavaBindingObject(HomeRecord hr, HomeWrapperSet homeSet, String interfaceName, int interfaceIndex, boolean local, EJBBinding bindingObject) {
        return bindingObject;
    }

    @Override
    public void bindJavaGlobal(String name, EJBBinding bindingObject) {
        String bindingName = this.buildJavaGlobalName(name);
        this.ejbJavaColonHelper.addGlobalBinding(bindingName, bindingObject);
    }

    @Override
    public void bindJavaApp(String name, EJBBinding bindingObject) {
        String bindingName = this.buildJavaAppName(name);
        this.ejbJavaColonHelper.addAppBinding(this.moduleMetaData, bindingName, bindingObject);
    }

    @Override
    public void bindJavaModule(String name, EJBBinding bindingObject) {
        this.ejbJavaColonHelper.addModuleBinding(this.moduleMetaData, name, bindingObject);
    }

    @Override
    public void bindDefaultEJBLocal(EJBBinding bindingObject, HomeRecord hr) throws NamingException {
        HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        if (hrImpl.bindToContextRoot()) {
            boolean priorToVersion3;
            BeanMetaData bmd = hr.getBeanMetaData();
            boolean bl = priorToVersion3 = bmd.ivModuleVersion < 30;
            if (priorToVersion3) {
                String bindingName = "ejb/" + hrImpl.getEJBName();
                this.localColonNamingHelper.bind((Object)bindingObject, bindingName, false, true);
                bh.ivLocalColonBindings.add(bindingName);
                this.sendBindingMessage(bindingObject.interfaceName, "local:" + bindingName, bmd);
                this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName, false, true);
                bh.ivEJBLocalBindings.add(bindingName);
                this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
            } else {
                J2EEName eeName = hrImpl.getJ2EEName();
                String bindingName = null;
                bindingName = bmd.ivComponent_Id != null ? bmd.ivComponent_Id + "#" + bindingObject.interfaceName : eeName.getApplication() + "/" + eeName.getModule() + "/" + eeName.getComponent() + "#" + bindingObject.interfaceName;
                this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName, false, true);
                bh.ivEJBLocalBindings.add(bindingName);
                this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
                if (BindingsHelper.shortDefaultBindingsEnabled(hrImpl.getAppName()).booleanValue() && this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName = bindingObject.interfaceName, false, true)) {
                    bh.ivEJBLocalBindings.add(bindingName);
                    this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
                }
            }
        }
    }

    @Override
    public void bindDefaultEJBRemote(EJBBinding bindingObject, HomeRecord hr) throws NamingException {
        HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
        if (hrImpl.bindToContextRoot()) {
            boolean priorToVersion3;
            BeanMetaData bmd = hr.getBeanMetaData();
            boolean bl = priorToVersion3 = bmd.ivModuleVersion < 30;
            if (priorToVersion3) {
                String bindingName = "ejb/" + hrImpl.getEJBName();
                this.bindLegacyRemoteBinding(bindingObject, hr, bindingName, false, true);
            } else {
                String bindingName = null;
                if (bmd.ivComponent_Id != null) {
                    bindingName = "ejb/" + bmd.ivComponent_Id + "#" + bindingObject.interfaceName;
                } else {
                    J2EEName eeName = hrImpl.getJ2EEName();
                    bindingName = "ejb/" + eeName.getApplication() + "/" + eeName.getModule() + "/" + eeName.getComponent() + "#" + bindingObject.interfaceName;
                }
                this.bindLegacyRemoteBinding(bindingObject, hr, bindingName, false, true);
                if (BindingsHelper.shortDefaultBindingsEnabled(hrImpl.getAppName()).booleanValue()) {
                    bindingName = bindingObject.interfaceName;
                    this.bindLegacyRemoteBinding(bindingObject, hr, bindingName, false, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindLegacyRemoteBinding(EJBBinding bindingObject, HomeRecord hr, String bindingName, boolean isSimpleName, boolean isDefaultBinding) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        EJBRemoteRuntime remoteRuntime = (EJBRemoteRuntime)this.ejbRemoteRuntimeServiceRef.getService();
        if (remoteRuntime != null) {
            BindingsHelper bh = BindingsHelper.getRemoteHelper(hr);
            BundleContext bc = this.ejbRemoteRuntimeServiceRef.getReference().getBundle().getBundleContext();
            BeanMetaData bmd = hr.getBeanMetaData();
            EJBBinding newBinding = new EJBBinding(bindingObject.homeRecord, bindingObject.interfaceName, bindingObject.interfaceIndex, bindingObject.isLocal);
            ReentrantReadWriteLock.ReadLock readLock = this.remoteLock.readLock();
            readLock.lock();
            EJBBinding previousBinding = null;
            try {
                previousBinding = svRemoteBindings.get(bindingName);
            }
            finally {
                readLock.unlock();
            }
            if (isSimpleName) {
                newBinding.setAmbiguousReference();
            }
            if (previousBinding != null) {
                if (isDefaultBinding) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"found ambiguous default binding", (Object[])new Object[0]);
                    }
                } else {
                    OnErrorUtil.OnError onError = ContainerProperties.customBindingsOnErr;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found ambiguous binding and customBindingsOnErr=" + onError.toString()), (Object[])new Object[0]);
                    }
                    BeanMetaData oldbmd = previousBinding.homeRecord.getBeanMetaData();
                    switch (onError) {
                        case WARN: {
                            Tr.warning((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_WARN_CNTR0338W", (Object[])new Object[]{newBinding.interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), bindingName, previousBinding.interfaceName, oldbmd.j2eeName.getComponent(), oldbmd.j2eeName.getModule(), oldbmd.j2eeName.getApplication()});
                            break;
                        }
                        case FAIL: {
                            Tr.error((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_WARN_CNTR0338W", (Object[])new Object[]{newBinding.interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), bindingName, previousBinding.interfaceName, oldbmd.j2eeName.getComponent(), oldbmd.j2eeName.getModule(), oldbmd.j2eeName.getApplication()});
                            throw new NamingException("The " + newBinding.interfaceName + " interface of the " + bmd.j2eeName.getComponent() + " bean in the " + bmd.j2eeName.getModule() + " module of the application cannot be bound to " + bindingName + ", a bean is already bound to that location.");
                        }
                        case IGNORE: {
                            if (isTraceOn && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"customBindingsOnErr is IGNORE, not binding", (Object[])new Object[0]);
                            }
                            return;
                        }
                    }
                }
                newBinding.setAmbiguousReference();
                newBinding.addJ2EENames(previousBinding.getJ2EENames());
                this.removePreviousRemoteBinding(bindingName);
            }
            Hashtable<String, String> properties = new Hashtable<String, String>(1);
            ((Dictionary)properties).put(JNDI_SERVICENAME, bindingName);
            ((Dictionary)properties).put("objectClass", Reference.class.getName());
            EJBRemoteReferenceBinding ref = new EJBRemoteReferenceBinding(newBinding, bindingName);
            ServiceRegistration registration = bc.registerService(Reference.class, (Object)ref, properties);
            List<ServiceRegistration<?>> list = registrations;
            synchronized (list) {
                registrations.add(registration);
            }
            ReentrantReadWriteLock.WriteLock writeLock = this.remoteLock.writeLock();
            writeLock.lock();
            try {
                svRemoteBindings.put(bindingName, newBinding);
            }
            finally {
                writeLock.unlock();
            }
            if (!newBinding.isAmbiguousReference) {
                bh.ivRemoteBindings.add(bindingName);
                this.sendBindingMessage(newBinding.interfaceName, bindingName, bmd);
            }
        } else if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Remote Runtime Service isn't enabled, not adding remote binding.", (Object[])new Object[0]);
        }
    }

    @Override
    public void bindSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, boolean local, boolean generateDisambiguatedSimpleBindingNames) throws NamingException {
        BeanMetaData bmd = hr.getBeanMetaData();
        if (local) {
            this.bindLocalSimpleBindingName(bindingObject, hr, bmd.simpleJndiBindingName, generateDisambiguatedSimpleBindingNames);
        } else {
            this.bindRemoteSimpleBindingName(bindingObject, hr, bmd.simpleJndiBindingName, generateDisambiguatedSimpleBindingNames);
        }
    }

    private void bindLocalSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, String bindingName, boolean generateDisambiguatedSimpleBindingNames) throws NamingException {
        boolean priorToVersion3;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        BeanMetaData bmd = hr.getBeanMetaData();
        boolean bl = priorToVersion3 = bmd.ivModuleVersion < 30;
        if (generateDisambiguatedSimpleBindingNames && isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"EJB with simple-binding-name has multiple interfaces, appending interface to simple-binding-name", (Object[])new Object[0]);
        }
        if (priorToVersion3) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"binding to local:", (Object[])new Object[0]);
            }
            String localColonBindingName = "ejb/" + bindingName;
            if (generateDisambiguatedSimpleBindingNames) {
                this.localColonNamingHelper.bind((Object)bindingObject, localColonBindingName, true, false);
                bh.ivLocalColonBindings.add(localColonBindingName);
                localColonBindingName = localColonBindingName + "#" + bindingObject.interfaceName;
            }
            this.localColonNamingHelper.bind((Object)bindingObject, localColonBindingName, false, false);
            bh.ivLocalColonBindings.add(localColonBindingName);
            this.sendBindingMessage(bindingObject.interfaceName, "local:" + localColonBindingName, bmd);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"binding to ejblocal:", (Object[])new Object[0]);
        }
        if (generateDisambiguatedSimpleBindingNames) {
            this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName, true, false);
            bh.ivEJBLocalBindings.add(bindingName);
            bindingName = bindingName + "#" + bindingObject.interfaceName;
        }
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName, false, false);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
    }

    private void bindRemoteSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, String bindingName, boolean generateDisambiguatedSimpleBindingNames) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (generateDisambiguatedSimpleBindingNames) {
            this.bindLegacyRemoteBinding(bindingObject, hr, bindingName, true, false);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"EJB with simple-binding-name has multiple interfaces, appending interface to simple-binding-name", (Object[])new Object[0]);
            }
            bindingName = bindingName + "#" + bindingObject.interfaceName;
        }
        this.bindLegacyRemoteBinding(bindingObject, hr, bindingName, false, false);
    }

    @Override
    public void bindLocalHomeBindingName(EJBBinding bindingObject, HomeRecord hr) throws NamingException {
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        BeanMetaData bmd = hr.getBeanMetaData();
        String bindingName = bmd.localHomeJndiBindingName;
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName, false, false);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, bindingName, bmd);
    }

    @Override
    public void bindLocalBusinessInterface(EJBBinding bindingObject, HomeRecord hr) throws NamingException {
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        BeanMetaData bmd = hr.getBeanMetaData();
        String interfaceName = bindingObject.interfaceName;
        String bindingName = bmd.businessInterfaceJndiBindingNames.get(interfaceName);
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName, false, false);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, bindingName, bmd);
    }

    private void sendBindingMessage(String interfaceName, String jndiName, BeanMetaData bmd) {
        Tr.info((TraceComponent)tc, (String)"JNDI_BINDING_LOCATION_INFO_CNTR0167I", (Object[])new Object[]{interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), jndiName});
    }

    @Override
    public void bindBindings(EJBBinding bindingObject, HomeRecord hr, int numInterfaces, boolean singleGlobalInterface, int interfaceIndex, String interfaceName, boolean local, boolean deferred) throws NamingException {
        EJBRemoteRuntime remoteRuntime = (EJBRemoteRuntime)this.ejbRemoteRuntimeServiceRef.getService();
        if (!local && remoteRuntime != null) {
            HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
            if (hrImpl.remoteBindingData == null) {
                BeanMetaData bmd = hr.getBeanMetaData();
                EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
                EJBApplicationMetaData amd = mmd.getEJBApplicationMetaData();
                String appLogicalName = amd.isStandaloneModule() ? null : amd.getLogicalName();
                hrImpl.remoteBindingData = remoteRuntime.createBindingData(bmd, appLogicalName, mmd.ivLogicalName);
            }
            remoteRuntime.bind(hrImpl.remoteBindingData, interfaceIndex, interfaceName);
        }
        if (ContainerProperties.BindToServerRoot) {
            BeanMetaData bmd = hr.getBeanMetaData();
            boolean hasCustomBindings = false;
            if (bmd.simpleJndiBindingName != null) {
                hasCustomBindings = true;
                this.bindSimpleBindingName(bindingObject, hr, local, numInterfaces > 1);
            }
            if (bmd.localHomeJndiBindingName != null && local && interfaceIndex == -1) {
                hasCustomBindings = true;
                this.bindLocalHomeBindingName(bindingObject, hr);
            }
            if (bmd.remoteHomeJndiBindingName != null && !local && interfaceIndex == -1) {
                hasCustomBindings = true;
                this.bindLegacyRemoteBinding(bindingObject, hr, bmd.remoteHomeJndiBindingName, false, false);
            }
            if (bmd.businessInterfaceJndiBindingNames != null && interfaceIndex >= 0 && bmd.businessInterfaceJndiBindingNames.containsKey(interfaceName)) {
                hasCustomBindings = true;
                if (local) {
                    this.bindLocalBusinessInterface(bindingObject, hr);
                } else {
                    this.bindLegacyRemoteBinding(bindingObject, hr, bmd.businessInterfaceJndiBindingNames.get(interfaceName), false, false);
                }
            }
            if (!hasCustomBindings) {
                if (local) {
                    this.bindDefaultEJBLocal(bindingObject, hr);
                } else {
                    this.bindDefaultEJBRemote(bindingObject, hr);
                }
            }
        }
    }

    @Override
    public void bindEJBFactory() {
    }

    @Override
    public void beginUnbind(boolean error) {
    }

    @Override
    public void unbindJavaGlobal(List<String> names) {
        ArrayList<String> fullNames = new ArrayList<String>(names.size());
        for (String name : names) {
            fullNames.add(this.buildJavaGlobalName(name));
        }
        this.ejbJavaColonHelper.removeGlobalBindings(fullNames);
    }

    @Override
    public void unbindJavaApp(List<String> names) {
        ArrayList<String> fullNames = new ArrayList<String>(names.size());
        for (String name : names) {
            fullNames.add(this.buildJavaAppName(name));
        }
        this.ejbJavaColonHelper.removeAppBindings(this.moduleMetaData, fullNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindBindings(HomeRecord hr) throws NamingException {
        EJBRemoteRuntime remoteRuntime = (EJBRemoteRuntime)this.ejbRemoteRuntimeServiceRef.getService();
        if (remoteRuntime != null) {
            BindingsHelper remoteBH = BindingsHelper.getRemoteHelper(hr);
            HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
            if (hrImpl.remoteBindingData != null) {
                remoteRuntime.unbindAll(hrImpl.remoteBindingData);
            }
            this.unbindRemote(remoteBH.ivRemoteBindings);
            ReentrantReadWriteLock.WriteLock writeLock = this.remoteLock.writeLock();
            writeLock.lock();
            try {
                for (String bindingName : remoteBH.ivRemoteBindings) {
                    svRemoteBindings.remove(bindingName);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        BindingsHelper localBH = BindingsHelper.getLocalHelper(hr);
        this.unbindEJBLocal(localBH.ivEJBLocalBindings);
        this.unbindLocalColonEJB(localBH.ivLocalColonBindings);
    }

    @Override
    public void unbindEJBFactory() {
    }

    @Override
    public void end() {
    }

    private String buildJavaGlobalName(String name) {
        StringBuffer bindingName = new StringBuffer();
        if (!this.moduleMetaData.getEJBApplicationMetaData().isStandaloneModule()) {
            bindingName.append(this.moduleMetaData.getEJBApplicationMetaData().getLogicalName());
            bindingName.append("/");
        }
        bindingName.append(this.moduleMetaData.ivLogicalName);
        bindingName.append("/");
        bindingName.append(name);
        return bindingName.toString();
    }

    private String buildJavaAppName(String name) {
        return this.moduleMetaData.ivLogicalName + "/" + name;
    }

    @Override
    public void unbindEJBLocal(List<String> names) throws NamingException {
        this.ejbLocalNamingHelper.removeBindings(names);
    }

    @Override
    public void unbindLocalColonEJB(List<String> names) throws NamingException {
        this.localColonNamingHelper.removeBindings(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindRemote(List<String> names) {
        ServiceRegistration<?> removedRegistration = null;
        List<ServiceRegistration<?>> list = registrations;
        synchronized (list) {
            for (String name : names) {
                for (ServiceRegistration<?> registration : registrations) {
                    if (!name.equals(registration.getReference().getProperty(JNDI_SERVICENAME))) continue;
                    removedRegistration = registration;
                    registration.unregister();
                    break;
                }
                if (removedRegistration == null) continue;
                registrations.remove(removedRegistration);
                removedRegistration = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePreviousRemoteBinding(String bindingName) {
        ServiceRegistration<?> removedRegistration = null;
        List<ServiceRegistration<?>> list = registrations;
        synchronized (list) {
            for (ServiceRegistration<?> registration : registrations) {
                if (!bindingName.equals(registration.getReference().getProperty(JNDI_SERVICENAME))) continue;
                removedRegistration = registration;
                registration.unregister();
                break;
            }
            if (removedRegistration != null) {
                registrations.remove(removedRegistration);
            }
        }
    }
}

