/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.Element;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;

final class CacheElementEnumerator
implements Enumeration<Element> {
    private static final TraceComponent tc = Tr.register(CacheElementEnumerator.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private Cache ivCache = null;
    private int ivBucketCount = 0;
    private int ivBucketIndex = 0;
    private Element[] ivBucket = null;
    private int ivBucketSize = 0;
    private int ivElementIndex = 0;
    private int ivElementsReturned = 0;
    private int ivMaxBucketSize = 0;
    private long ivTotalLookups = 0L;
    private final int[] ivBucketSizeStats = new int[21];

    public CacheElementEnumerator(Cache cache) {
        this.ivCache = cache;
        this.ivBucket = new Element[50];
        this.reset();
    }

    void reset() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset", (Object[])new Object[0]);
        }
        Random random = new Random();
        this.ivBucketIndex = random.nextInt(this.ivCache.getNumBuckets());
        if (isTraceOn && tc.isDebugEnabled()) {
            String stats = "";
            if (this.ivBucketCount > 0 && (this.ivBucketCount < this.ivCache.getNumBuckets() || this.ivElementIndex < this.ivBucketSize)) {
                stats = ", returned = " + this.ivElementsReturned + " (lookup avg = " + (float)this.ivTotalLookups / (float)this.ivElementsReturned + ", max = " + this.ivMaxBucketSize + ")";
            }
            Tr.debug((TraceComponent)tc, (String)("reset : " + this.ivCache.getName() + " = " + this.ivCache.numObjects + ", index = " + this.ivBucketIndex + "/" + this.ivCache.getNumBuckets() + stats), (Object[])new Object[0]);
            this.ivElementsReturned = 0;
            this.ivMaxBucketSize = 0;
            this.ivTotalLookups = 0L;
            for (int i = 0; i < this.ivBucketSizeStats.length; ++i) {
                this.ivBucketSizeStats[i] = 0;
            }
        }
        Arrays.fill(this.ivBucket, null);
        this.ivBucketCount = 0;
        this.ivBucketSize = 0;
        this.ivElementIndex = 0;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.ivElementIndex < this.ivBucketSize) {
            return true;
        }
        return this.findNextBucket();
    }

    @Override
    public Element nextElement() throws NoSuchElementException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.ivElementIndex >= this.ivBucketSize && !this.findNextBucket()) {
            throw new NoSuchElementException();
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            ++this.ivElementsReturned;
        }
        return this.ivBucket[this.ivElementIndex++];
    }

    public Object nextElemNoEx() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (this.ivElementIndex >= this.ivBucketSize && !this.findNextBucket()) {
            return null;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            ++this.ivElementsReturned;
        }
        return this.ivBucket[this.ivElementIndex++];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findNextBucket() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        while (this.ivBucketCount < this.ivCache.getNumBuckets()) {
            this.ivBucketIndex = (this.ivBucketIndex + 1) % this.ivCache.getNumBuckets();
            Bucket bucket = this.ivCache.getBucketForKey(this.ivBucketIndex);
            ++this.ivBucketCount;
            if (bucket == null) {
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                this.ivBucketSizeStats[0] = this.ivBucketSizeStats[0] + 1;
                continue;
            }
            Bucket bucket2 = bucket;
            synchronized (bucket2) {
                if (!bucket.isEmpty()) {
                    this.ivBucketSize = bucket.size();
                    if (this.ivBucket.length < this.ivBucketSize) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(this.ivCache.getName() + ": Expanding internal bucket from " + this.ivBucket.length + " to " + (this.ivBucketSize + 20)), (Object[])new Object[0]);
                        }
                        this.ivBucket = new Element[this.ivBucketSize + 20];
                    }
                    bucket.toArray(this.ivBucket);
                    this.ivElementIndex = 0;
                    if (isTraceOn && tc.isDebugEnabled()) {
                        if (this.ivBucketSize > this.ivMaxBucketSize) {
                            this.ivMaxBucketSize = this.ivBucketSize;
                        }
                        if (this.ivBucketSize < this.ivBucketSizeStats.length) {
                            int n = this.ivBucketSize;
                            this.ivBucketSizeStats[n] = this.ivBucketSizeStats[n] + 1;
                        } else {
                            int n = this.ivBucketSizeStats.length - 1;
                            this.ivBucketSizeStats[n] = this.ivBucketSizeStats[n] + 1;
                        }
                        for (int j = 1; j <= this.ivBucketSize; ++j) {
                            this.ivTotalLookups += (long)j;
                        }
                        if (this.ivBucketSize > 100) {
                            Tr.debug((TraceComponent)tc, (String)(this.ivCache.getName() + ": Hash = " + this.ivBucketIndex + ", size = " + this.ivBucketSize), (Object[])new Object[0]);
                        }
                    }
                    return true;
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    this.ivBucketSizeStats[0] = this.ivBucketSizeStats[0] + 1;
                }
            }
        }
        if (isTraceOn && tc.isDebugEnabled() && this.ivElementsReturned > 0) {
            int pCapacity = (int)((float)this.ivElementsReturned / (float)this.ivBucketCount * 100.0f);
            Tr.debug((TraceComponent)tc, (String)("Empty : " + this.ivCache.getName() + " returned = " + this.ivElementsReturned + ", " + pCapacity + "% capacity (lookup avg = " + (float)this.ivTotalLookups / (float)this.ivElementsReturned + ", max = " + this.ivMaxBucketSize + ")"), (Object[])new Object[0]);
            String bucketStats = "0[" + this.ivBucketSizeStats[0] + "]";
            for (int i = 1; i < this.ivBucketSizeStats.length; ++i) {
                if (this.ivBucketSizeStats[i] <= 0) continue;
                bucketStats = bucketStats + ", " + i;
                if (i == this.ivBucketSizeStats.length - 1) {
                    bucketStats = bucketStats + "+";
                }
                bucketStats = bucketStats + "[" + this.ivBucketSizeStats[i] + "]";
            }
            Tr.debug((TraceComponent)tc, (String)("Empty : " + this.ivCache.getName() + " size[buckets] = " + bucketStats), (Object[])new Object[0]);
        }
        return false;
    }
}

