/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;

public abstract class ExceptionMappingStrategy {
    private static final TraceComponent tc = Tr.register(ExceptionMappingStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    public abstract Throwable setUncheckedException(EJSDeployedSupport var1, Throwable var2);

    public abstract Exception mapCSITransactionRolledBackException(EJSDeployedSupport var1, CSITransactionRolledbackException var2) throws CSIException;

    public Throwable findRootCause(Throwable throwable) {
        return ExceptionUtil.findRootCause(throwable);
    }

    public final void setCheckedException(EJSDeployedSupport s, Exception ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"setting checked exception", (Object[])new Object[]{ex});
        }
        s.exType = ExceptionType.CHECKED_EXCEPTION;
        s.ivException = ex;
        s.rootEx = this.findRootCause(ex);
        Boolean applicationExceptionRollback = s.getApplicationExceptionRollback(ex);
        if (applicationExceptionRollback == Boolean.TRUE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"ApplicationException with rollback set to true, setting rollback only", (Object[])new Object[]{ex});
            }
            s.currentTx.setRollbackOnly();
        }
    }
}

