/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.validation;

import java.lang.reflect.Method;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.validation.BeanValidationProvider;

public abstract class AbstractValidationInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractValidationInterceptor.class);
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractValidationInterceptor.class);
    private Object serviceObject;
    private volatile BeanValidationProvider provider;

    public AbstractValidationInterceptor(String phase) {
        super(phase);
    }

    public void setServiceObject(Object object) {
        this.serviceObject = object;
    }

    public void setProvider(BeanValidationProvider provider) {
        this.provider = provider;
    }

    public void handleMessage(Message message) throws Fault {
        ExecutableType[] execTypes;
        Object theServiceObject = this.getServiceObject(message);
        if (theServiceObject == null) {
            return;
        }
        Method method = this.getServiceMethod(message);
        if (method == null) {
            return;
        }
        ValidateOnExecution validateOnExec = method.getAnnotation(ValidateOnExecution.class);
        if (validateOnExec != null && (execTypes = validateOnExec.type()).length == 1 && execTypes[0] == ExecutableType.NONE) {
            return;
        }
        MessageContentsList arguments = MessageContentsList.getContentsList((Message)message);
        this.handleValidation(message, theServiceObject, method, (List<Object>)arguments);
    }

    protected Object getServiceObject(Message message) {
        FactoryInvoker factoryInvoker;
        Invoker invoker;
        if (this.serviceObject != null) {
            return this.serviceObject;
        }
        Object current = message.getExchange().get((Object)"org.apache.cxf.service.object");
        if (current != null) {
            return current;
        }
        Endpoint e = message.getExchange().getEndpoint();
        if (e != null && e.getService() != null && (invoker = e.getService().getInvoker()) instanceof FactoryInvoker && (factoryInvoker = (FactoryInvoker)invoker).isSingletonFactory()) {
            return factoryInvoker.getServiceObject(message.getExchange());
        }
        return null;
    }

    protected Method getServiceMethod(Message message) {
        BindingOperationInfo bop;
        Message inMessage = message.getExchange().getInMessage();
        Method method = null;
        if (inMessage != null && (method = (Method)inMessage.get((Object)"org.apache.cxf.resource.method")) == null && (bop = inMessage.getExchange().getBindingOperationInfo()) != null) {
            MethodDispatcher md = (MethodDispatcher)inMessage.getExchange().getService().get((Object)MethodDispatcher.class.getName());
            method = md.getMethod(bop);
        }
        if (method == null) {
            method = (Method)message.getExchange().get(Method.class);
        }
        return method;
    }

    protected abstract void handleValidation(Message var1, Object var2, Method var3, List<Object> var4);

    protected BeanValidationProvider getProvider(Message message) {
        if (this.provider == null) {
            Object prop = message.getContextualProperty(BeanValidationProvider.class.getName());
            this.provider = prop != null ? (BeanValidationProvider)prop : new BeanValidationProvider();
        }
        return this.provider;
    }
}

