/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientAuthnData {
    private static TraceComponent tc = Tr.register(ClientAuthnData.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String Authorization_Header = "Authorization";
    public static final String AUTHORIZATION_ENCODING = "Authorization-Encoding";
    public static final String BasicAuthEncoding = System.getProperty("com.ibm.websphere.security.BasicAuthEncoding", "UTF-8");
    String userName = null;
    String passWord = null;
    boolean authnData = false;
    boolean isBasicAuth = false;
    static final long serialVersionUID = -182367662242483189L;

    public ClientAuthnData(HttpServletRequest req, HttpServletResponse res) throws OAuth20DuplicateParameterException {
        String hdrValue = req.getHeader(Authorization_Header);
        if (hdrValue == null || !hdrValue.startsWith("Basic ")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authorization header was null or wasn't basic auth; looking for client_id and client_secret parameters", (Object[])new Object[0]);
            }
            this.passWord = this.checkForRepeatedOrEmptyParameter(req, "client_secret");
            this.userName = this.checkForRepeatedOrEmptyParameter(req, "client_id");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authorization header set to basic auth; decoding header and extracting user name and password", (Object[])new Object[0]);
            }
            this.isBasicAuth = true;
            String encoding = req.getHeader(AUTHORIZATION_ENCODING);
            int idx = (hdrValue = ClientAuthnData.decodeAuthorizationHeader(hdrValue, encoding)).indexOf(58);
            if (idx < 0) {
                this.userName = hdrValue;
            } else {
                this.userName = hdrValue.substring(0, idx);
                this.passWord = hdrValue.substring(idx + 1);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Use authentication data from Authentication head for client: " + this.userName), (Object[])new Object[0]);
        }
        if (this.userName != null && this.userName.length() > 0) {
            this.authnData = true;
        }
    }

    @Sensitive
    public static String decodeAuthorizationHeader(HttpServletRequest req) {
        String hdrValue = req.getHeader(Authorization_Header);
        String encoding = req.getHeader(AUTHORIZATION_ENCODING);
        if (hdrValue == null || !hdrValue.startsWith("Basic ")) {
            return null;
        }
        return ClientAuthnData.decodeAuthorizationHeader(hdrValue, encoding);
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public static String decodeAuthorizationHeader(@Sensitive String hdrValue, String encoding) {
        block9: {
            boolean decoded;
            byte[] headerBytes;
            boolean useDefault;
            block8: {
                if (hdrValue == null) {
                    return null;
                }
                useDefault = false;
                if (encoding == null) {
                    encoding = BasicAuthEncoding;
                    useDefault = true;
                }
                headerBytes = Base64.decode(hdrValue.substring(6));
                decoded = false;
                if (encoding != null && encoding.length() > 0) {
                    try {
                        hdrValue = new String(headerBytes, encoding);
                        decoded = true;
                    }
                    catch (Exception exception) {
                        void e;
                        Object[] objectArray = new Object[2];
                        objectArray[0] = "<sensitive java.lang.String>";
                        objectArray[1] = encoding;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.web.ClientAuthnData", (String)"96", null, (Object[])objectArray);
                        decoded = false;
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug((TraceComponent)tc, (String)("Decoding fails with encoding:" + encoding), (Object[])new Object[]{e});
                    }
                }
            }
            if (!decoded && !useDefault) {
                try {
                    hdrValue = new String(headerBytes, BasicAuthEncoding);
                }
                catch (Exception e) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = "<sensitive java.lang.String>";
                    objectArray[1] = encoding;
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.web.ClientAuthnData", (String)"106", null, (Object[])objectArray);
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Decoding fails with default encoding:" + BasicAuthEncoding), (Object[])new Object[]{e});
                }
            }
        }
        return hdrValue;
    }

    public String getUserName() {
        return this.userName;
    }

    @Sensitive
    public String getPassWord() {
        return this.passWord;
    }

    public boolean hasAuthnData() {
        return this.authnData;
    }

    public boolean isBasicAuth() {
        return this.isBasicAuth;
    }

    @Sensitive
    private String checkForRepeatedOrEmptyParameter(HttpServletRequest request, String parameter) throws OAuth20DuplicateParameterException {
        String[] paramArray = request.getParameterValues(parameter);
        if (paramArray != null && paramArray.length > 1) {
            throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", parameter);
        }
        if (paramArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No values found for parameter: " + parameter), (Object[])new Object[0]);
            }
            return null;
        }
        String paramValue = paramArray[0];
        if (paramValue.isEmpty()) {
            return null;
        }
        return paramValue;
    }
}

