/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.jose4j;

import com.ibm.oauth.core.internal.OAuthUtil;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.common.claims.UserClaimsRetrieverService;
import com.ibm.ws.security.oauth20.plugins.jose4j.JWTData;
import com.ibm.ws.security.oauth20.plugins.jose4j.JwsSigner;
import com.ibm.ws.security.oauth20.plugins.jose4j.OidcUserClaims;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtCreator {
    private static TraceComponent tc = Tr.register(JwtCreator.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final String CFG_KEY_ISSUER_IDENTIFIER = "issuerIdentifier";
    private static final String JTI_CLAIM = "jti";
    public static final String AT_HASH = "at_hash";
    public static final String AZP = "azp";
    private static final String UPN_CLAIM = "upn";
    private static final String GROUP_CLAIM = "groups";
    static final long serialVersionUID = -9219915364983015887L;

    @FFDCIgnore(value={Exception.class})
    public static String createJwtAsString(OidcServerConfig oidcServerConfig, String clientId, String username, String[] scope, int lifetimeSeconds, Map<String, String[]> tokenMap, Map<String, Object> userClaims, JWTData jwtData, boolean mpJwt) {
        boolean bJwt = jwtData.isJwt();
        String jwt = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("PI78760, PI80166 are present, OidcServerConfig is: " + oidcServerConfig), (Object[])new Object[0]);
            }
            String[] audiences = null;
            JwtClaims claims = new JwtClaims();
            claims.setSubject(username);
            if (bJwt || mpJwt) {
                audiences = tokenMap.get("resource");
                claims.setClaim("token_type", (Object)"Bearer");
                if (scope != null && scope.length > 0) {
                    claims.setStringListClaim("scope", scope);
                }
                if (!mpJwt) {
                    claims.setClaim(AZP, (Object)clientId);
                }
            } else {
                String nonce = OAuth20Util.getValueFromMap("nonce", tokenMap);
                if (nonce != null && !nonce.isEmpty()) {
                    claims.setClaim("nonce", (Object)nonce);
                }
                audiences = new String[]{clientId};
                if (userClaims != null) {
                    for (Map.Entry<String, Object> e : userClaims.entrySet()) {
                        claims.setClaim(e.getKey(), e.getValue());
                    }
                }
            }
            if (oidcServerConfig.isJTIClaimEnabled() || mpJwt) {
                claims.setClaim(JTI_CLAIM, (Object)OAuthUtil.getRandom(16));
            }
            claims.setIssuer(JwtCreator.getIssuerIdentifier(tokenMap, oidcServerConfig));
            if (audiences != null && audiences.length > 0) {
                claims.setAudience(audiences);
            }
            long timeInMilliSeconds = System.currentTimeMillis();
            NumericDate ndIat = NumericDate.fromMilliseconds((long)timeInMilliSeconds);
            NumericDate ndExp = NumericDate.fromMilliseconds((long)(timeInMilliSeconds + (long)lifetimeSeconds * 1000L));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting iat to [" + ndIat.toString() + "]"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Setting exp to [" + ndExp.toString() + "]"), (Object[])new Object[0]);
            }
            claims.setExpirationTime(ndExp);
            claims.setIssuedAt(ndIat);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"intermediate: audiences claims", (Object[])new Object[]{audiences, claims});
            }
            if (bJwt || mpJwt) {
                JwtCreator.addFunctionalUserAndGroupIDs(claims, tokenMap, oidcServerConfig);
                JwtCreator.addCustomClaims(claims, tokenMap, oidcServerConfig);
            } else {
                JwtCreator.addExternalClaims(claims, tokenMap);
            }
            if (mpJwt) {
                Object user;
                String groupIdKey = oidcServerConfig.getGroupIdentifier();
                Object groups = claims.getClaimValue(groupIdKey);
                if (groups != null) {
                    claims.unsetClaim(groupIdKey);
                    claims.setClaim(GROUP_CLAIM, groups);
                }
                if ((user = claims.getClaimValue("uniqueSecurityName")) != null) {
                    claims.setClaim(UPN_CLAIM, user);
                    claims.unsetClaim("uniqueSecurityName");
                }
                claims.unsetClaim("realmName");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"final: audiences claims", (Object[])new Object[]{audiences, claims});
            }
            jwt = JwsSigner.getSignedJwt(claims, oidcServerConfig, jwtData);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{e});
            }
            Object[] objs = new Object[]{oidcServerConfig.getProviderId(), e.getLocalizedMessage()};
            Tr.error((TraceComponent)tc, (String)"JWT_CANNOT_GENERATE_JWT", (Object[])objs);
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JWT_CANNOT_GENERATE_JWT", (Object[])objs));
        }
        return jwt;
    }

    private static String getIssuerIdentifier(@Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        String issuerIdentifier = oidcServerConfig.getIssuerIdentifier();
        if (issuerIdentifier == null || issuerIdentifier.isEmpty() || issuerIdentifier.equalsIgnoreCase("null")) {
            issuerIdentifier = OAuth20Util.getValueFromMap(CFG_KEY_ISSUER_IDENTIFIER, tokenMap);
        }
        return issuerIdentifier;
    }

    private static void addCustomClaims(JwtClaims claims, @Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        String groupIdentifier;
        String username;
        UserClaims oauthUserClaims;
        UserClaimsRetrieverService userClaimsRetrieverService;
        if (oidcServerConfig.isCustomClaimsEnabled() && (userClaimsRetrieverService = ConfigUtils.getUserClaimsRetrieverService()) != null && (oauthUserClaims = userClaimsRetrieverService.getUserClaims(username = OAuth20Util.getValueFromMap("username", tokenMap), groupIdentifier = oidcServerConfig.getGroupIdentifier())) != null) {
            Map<String, Object> customMap = null;
            if (oauthUserClaims.isEnabled()) {
                OidcUserClaims oidcUserClaims = new OidcUserClaims(oauthUserClaims);
                oidcUserClaims.addExtraClaims(oidcServerConfig);
                customMap = oidcUserClaims.asMap();
            } else {
                customMap = oauthUserClaims.asMap();
            }
            Set<Map.Entry<String, Object>> entries = customMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                claims.setClaim(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void addFunctionalUserAndGroupIDs(JwtClaims claims, @Sensitive Map<String, String[]> tokenMap, OidcServerConfig oidcServerConfig) {
        String[] funcGroups;
        String[] funcUsers = tokenMap.get("functional_user_id");
        String funcUser = null;
        if (funcUsers != null && funcUsers.length > 0) {
            funcUser = funcUsers[0];
            claims.setClaim("functional_user_id", (Object)funcUser);
        }
        if ((funcGroups = tokenMap.get("functional_user_groupIds")) != null && funcGroups.length > 0) {
            claims.setClaim("functional_user_groupIds", (Object)funcGroups);
        }
    }

    private static void addExternalClaims(JwtClaims claims, Map<String, String[]> tokenMap) {
        Set<Map.Entry<String, String[]>> entries = tokenMap.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            String key = entry.getKey();
            if (!key.startsWith("com.ibm.wsspi.security.oidc.external.claims:")) continue;
            String shortKey = key.substring(OAuth20Constants.EXTERNAL_CLAIMS_PREFIX_LENGTH);
            String[] values = tokenMap.get(key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" longKey:" + key + " shortKey:" + shortKey + " values length:" + (values == null ? 0 : values.length)), (Object[])new Object[0]);
            }
            if (values == null || values.length <= 0) continue;
            if (values.length == 1) {
                claims.setClaim(shortKey, (Object)values[0]);
                continue;
            }
            claims.setClaim(shortKey, (Object)values);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String createJwtAsStringForSpi(String jsonFromSpi, OidcServerConfig oidcServerConfig, String clientId, String username, String[] scope, int lifetimeSeconds, Map<String, String[]> tokenMap, String grantType, String accessTokenHash, JWTData jwtData) {
        String jwt = null;
        try {
            JwtClaims claims = JwtClaims.parse((String)jsonFromSpi);
            if (claims.getIssuer() == null) {
                claims.setIssuer(JwtCreator.getIssuerIdentifier(tokenMap, oidcServerConfig));
            }
            if (claims.getSubject() == null) {
                claims.setSubject(username);
            }
            if (claims.getExpirationTime() == null) {
                claims.setExpirationTimeMinutesInTheFuture((float)lifetimeSeconds / 60.0f);
            }
            if (accessTokenHash != null) {
                claims.setClaim(AT_HASH, (Object)accessTokenHash);
            }
            jwt = JwsSigner.getSignedJwt(claims, oidcServerConfig, jwtData);
        }
        catch (Exception claims) {
            void e;
            FFDCFilter.processException((Throwable)claims, (String)"com.ibm.ws.security.oauth20.plugins.jose4j.JwtCreator", (String)"283", null, (Object[])new Object[]{jsonFromSpi, oidcServerConfig, clientId, username, scope, lifetimeSeconds, tokenMap, grantType, accessTokenHash, jwtData});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception", (Object[])new Object[]{e});
            }
            Object[] objs = new Object[]{oidcServerConfig.getProviderId(), e.getLocalizedMessage()};
            Tr.error((TraceComponent)tc, (String)"JWT_CANNOT_GENERATE_JWT", (Object[])objs);
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"JWT_CANNOT_GENERATE_JWT", (Object[])objs));
        }
        return jwt;
    }
}

