/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.client.OAuth20Client;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedClientProvider;
import com.ibm.ws.security.oauth20.exception.OAuthProviderException;
import com.ibm.ws.security.oauth20.platform.PlatformServiceFactory;
import com.ibm.ws.security.oauth20.plugins.BaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.ClientUtils;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class BaseClientProvider
implements OAuth20EnhancedClientProvider {
    private static TraceComponent tc = Tr.register(BaseClientProvider.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private Logger logger;
    static boolean initializedStatics = false;
    protected static HashMap<String, BaseClient> clientMap = new HashMap();
    protected String providerID;
    protected boolean hasRewrites;
    protected static final List<BaseClient> clientsList = new ArrayList<BaseClient>();
    private String[] providerRewrites;
    static final long serialVersionUID = 295609894440954107L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public BaseClientProvider() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this.logger = Logger.getLogger(BaseClientProvider.class.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public BaseClientProvider(String providerID, String[] providerRewrites) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{providerID, providerRewrites});
        }
        this.logger = Logger.getLogger(BaseClientProvider.class.getName());
        this.providerID = providerID;
        String[] stringArray = this.providerRewrites = providerRewrites != null ? (String[])providerRewrites.clone() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.hasRewrites = ClientUtils.initRewrites(this.providerID, this.providerRewrites);
        this.loadClients();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void init(OAuthComponentConfiguration config) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.providerID = config.getUniqueId();
        this.hasRewrites = ClientUtils.initRewrites(config);
        this.loadClients();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void loadClients() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadClients", (Object)new Object[0]);
        }
        try {
            ArrayList<OidcBaseClient> clientsList = new ArrayList<OidcBaseClient>();
            clientsList.addAll(ConfigUtils.getClients());
            HashMap<String, BaseClient> hashMap = clientMap;
            synchronized (hashMap) {
                for (BaseClient baseClient : clientsList) {
                    String key = this.getKey(baseClient.getClientId(), baseClient.getComponentId());
                    clientMap.put(key, baseClient);
                }
            }
        }
        catch (Exception clientsList) {
            void e;
            FFDCFilter.processException((Throwable)clientsList, (String)"com.ibm.ws.security.oauth20.plugins.BaseClientProvider", (String)"101", (Object)this, (Object[])new Object[0]);
            this.logger.log(Level.WARNING, e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadClients");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean exists(String clientIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"exists");
        }
        boolean result = clientMap.containsKey(this.getKey(clientIdentifier));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exists", (Object)result);
        }
        return result;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OAuth20Client get(String clientIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get");
        }
        BaseClient result = this.getClient(this.getKey(clientIdentifier));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get", (Object)result);
        }
        return result;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Collection<BaseClient> getAll() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAll");
        }
        ArrayList<BaseClient> results = new ArrayList<BaseClient>();
        for (String key : clientMap.keySet()) {
            if (!this.providerOwns(key)) continue;
            results.add(this.getClient(key));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAll");
        }
        return results;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean validateClient(String clientIdentifier, String clientSecret) {
        String secret;
        BaseClient client;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateClient");
        }
        boolean result = false;
        if (clientIdentifier != null && clientSecret != null && (client = this.getClient(this.getKey(clientIdentifier))) != null && (secret = client.getClientSecret()) != null && secret.equals(clientSecret)) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateClient", (Object)(result + ""));
        }
        return result;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public BaseClient update(BaseClient newClient) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"update");
        }
        this.put(newClient);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"update");
        }
        return newClient;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected String getKey(BaseClient newClient) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey", (Object)new Object[]{newClient});
        }
        String string = this.getKey(newClient.getClientId(), newClient.getComponentId());
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"getKey", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected String getKey(String clientId) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey", (Object)new Object[]{clientId});
        }
        String string = this.getKey(clientId, this.providerID);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"getKey", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected String getKey(String clientId, String providerId) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey", (Object)new Object[]{clientId, providerId});
        }
        String string = clientId + "_" + providerId;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"getKey", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected boolean providerOwns(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"providerOwns", (Object)new Object[]{key});
        }
        boolean bl = key.endsWith("_" + this.providerID);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((TraceComponent)tc, (String)"providerOwns", (Object)bl);
        }
        return bl;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected BaseClient getClient(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getClient " + key));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clientMap ", clientMap);
        }
        BaseClient result = clientMap.get(key);
        if (this.hasRewrites && result != null) {
            result = ClientUtils.uriRewrite(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClient", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean delete(String clientIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delete");
        }
        if (!PlatformServiceFactory.getPlatformService().isDistributedCapable()) {
            HashMap<String, BaseClient> hashMap = clientMap;
            synchronized (hashMap) {
                clientMap.remove(this.getKey(clientIdentifier, this.providerID));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delete");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public BaseClient put(BaseClient newClient) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put");
        }
        if (!PlatformServiceFactory.getPlatformService().isDistributedCapable()) {
            HashMap<String, BaseClient> hashMap = clientMap;
            synchronized (hashMap) {
                clientMap.put(this.getKey(newClient), newClient);
                this.storeClients();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put");
        }
        return newClient;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void storeClients() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeClients", (Object)new Object[0]);
        }
        try {
            ClientUtils.storeClients(clientMap.values());
        }
        catch (OAuthProviderException oAuthProviderException) {
            void e;
            FFDCFilter.processException((Throwable)oAuthProviderException, (String)"com.ibm.ws.security.oauth20.plugins.BaseClientProvider", (String)"256", (Object)this, (Object[])new Object[0]);
            this.logger.log(Level.WARNING, e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeClients");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public int getCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCount", (Object)new Object[0]);
        }
        int n = clientMap.size();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            n = n;
            Tr.exit((TraceComponent)tc, (String)"getCount", (Object)n);
        }
        return n;
    }
}

