/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.impl;

import com.ibm.oauth.core.api.config.SampleComponentConfiguration;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20ProviderConfiguration;
import com.ibm.ws.security.oauth20.exception.CannotModifyOAuthParameterException;
import com.ibm.ws.security.oauth20.filter.OAuthResourceProtectionFilter;
import com.ibm.ws.security.oauth20.util.OAuth20Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuth20ComponentConfigurationImpl
extends SampleComponentConfiguration
implements OAuth20ProviderConfiguration {
    private static final TraceComponent tc = Tr.register(OAuth20ComponentConfigurationImpl.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    String uniqueId;
    private OAuthResourceProtectionFilter filter = null;
    private static final String FILTER = "filter";
    private ClassLoader pluginClassLoader = null;
    List<OAuth20Parameter> params;
    static final long serialVersionUID = 4340143206514585148L;

    public OAuth20ComponentConfigurationImpl(String id, List<OAuth20Parameter> parameters, ClassLoader classLoader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ctor", (Object[])new Object[]{id, parameters, classLoader});
        }
        this.uniqueId = id;
        this.params = parameters;
        this.pluginClassLoader = classLoader;
        this._config.clear();
        for (OAuth20Parameter param : this.params) {
            this.putConfigPropertyValues(param.getName(), param.getValues().toArray(new String[0]));
        }
    }

    @Override
    public List<OAuth20Parameter> getParameters() {
        return this.params;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Properties getCustomizableProperties() {
        Properties props = new Properties();
        for (OAuth20Parameter param : this.params) {
            if (!"true".equalsIgnoreCase(param.getCustomizable())) continue;
            String key = param.getName();
            String value = param.getValues().get(0);
            if (param.getValues().size() > 1) {
                for (int i = 1; i < param.getValues().size(); ++i) {
                    value = value + "," + param.getValues().get(i);
                }
            }
            props.put(key, value);
        }
        return props;
    }

    @Override
    public List<OAuth20Parameter> mergeCustomizedProperties(Properties props) throws CannotModifyOAuthParameterException {
        String newValue;
        String name;
        HashSet<String> addedprops = new HashSet<String>();
        ArrayList<OAuth20Parameter> newparams = new ArrayList<OAuth20Parameter>();
        for (OAuth20Parameter oAuth20Parameter : this.params) {
            name = oAuth20Parameter.getName();
            newValue = props.getProperty(name);
            OAuth20Parameter newparam = new OAuth20Parameter(oAuth20Parameter);
            if (newValue != null) {
                if ("false".equalsIgnoreCase(oAuth20Parameter.getCustomizable())) {
                    throw new CannotModifyOAuthParameterException(name);
                }
                List<String> values = Arrays.asList(newValue.split(","));
                newparam.setValues(values);
            }
            newparams.add(newparam);
            addedprops.add(name);
        }
        for (Map.Entry entry : props.entrySet()) {
            name = (String)entry.getKey();
            newValue = (String)entry.getValue();
            if (addedprops.contains(name) || newValue == null) continue;
            List<String> values = Arrays.asList(newValue.split(","));
            OAuth20Parameter newparam = new OAuth20Parameter(name, "cc", "true");
            newparam.setValues(values);
            newparams.add(newparam);
        }
        return newparams;
    }

    @Override
    public OAuthResourceProtectionFilter getFilter() {
        if (this.filter == null) {
            String filterString = this.getConfigPropertyValue(FILTER);
            this.filter = filterString != null ? new OAuthResourceProtectionFilter(filterString, false) : new OAuthResourceProtectionFilter(false);
        }
        return this.filter;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        if (this.pluginClassLoader != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"using user defined shared lib classloader: ", (Object[])new Object[]{this.pluginClassLoader});
            }
            return this.pluginClassLoader;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"using default classloader", (Object[])new Object[0]);
        }
        return super.getPluginClassLoader();
    }
}

