/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.statistics;

import com.ibm.oauth.core.api.statistics.OAuthStatistic;
import java.math.BigInteger;
import java.util.Date;

public class OAuthStatisticImpl
implements OAuthStatistic {
    String _name;
    long _count;
    BigInteger _elapsedTime;
    Date _timestamp;

    public OAuthStatisticImpl(String name) {
        this.init(name, 0L, null, null);
    }

    public OAuthStatisticImpl(OAuthStatisticImpl other) {
        this.init(other._name, other._count, other._elapsedTime, other._timestamp);
    }

    public void setToNow() {
        this._timestamp = new Date();
    }

    public void addMeasurement(long elapsedTimeMilliseconds) {
        ++this._count;
        this._elapsedTime = this._elapsedTime.add(BigInteger.valueOf(elapsedTimeMilliseconds));
    }

    void init(String name, long count, BigInteger elapsedTime, Date timestamp) {
        this._name = name;
        this._count = count;
        this._elapsedTime = elapsedTime != null ? new BigInteger(elapsedTime.toByteArray()) : BigInteger.ZERO;
        this._timestamp = timestamp != null ? timestamp : new Date();
    }

    @Override
    public long getCount() {
        return this._count;
    }

    @Override
    public BigInteger getElapsedTime() {
        return this._elapsedTime;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Date getTimestamp() {
        return this._timestamp;
    }
}

