/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.granttype.impl;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20AuthorizationCodeInvalidClientException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MismatchedRedirectUriException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20GrantTypeHandlerCodeImpl
implements OAuth20GrantTypeHandler {
    static final String CLASS = OAuth20GrantTypeHandlerCodeImpl.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getKeysGrantType(AttributeList attributeList) throws OAuthException {
        String methodName = "getKeysGrantType";
        _log.entering(CLASS, methodName);
        ArrayList<String> tokenKeys = null;
        try {
            String code = attributeList.getAttributeValueByNameAndType("code", "urn:ibm:names:body:param");
            if (code == null) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "code", null);
            }
            tokenKeys = new ArrayList<String>();
            tokenKeys.add(code);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateRequestGrantType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String methodName = "validateRequestGrantType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token code;
            if (tokens.size() >= 1 && (code = tokens.get(0)) != null) {
                String clientId = attributeList.getAttributeValueByName("client_id");
                if (!clientId.equals(code.getClientId())) {
                    throw new OAuth20AuthorizationCodeInvalidClientException("security.oauth20.error.invalid.authorizationcode", code.getTokenString(), clientId);
                }
                String redirectUri = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:body:param");
                String codeUri = code.getRedirectUri();
                if (redirectUri == null) {
                    if (codeUri != null) {
                        throw new OAuth20MismatchedRedirectUriException("security.oauth20.error.mismatched.redirecturi.null.request.redirecturi", redirectUri, codeUri);
                    }
                } else if (codeUri == null || !codeUri.equals(redirectUri)) {
                    throw new OAuth20MismatchedRedirectUriException("security.oauth20.error.mismatched.redirecturi", redirectUri, codeUri);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuth20Token> buildTokensGrantType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, List<OAuth20Token> tokens) {
        String methodName = "buildTokensGrantType";
        _log.entering(CLASS, methodName);
        ArrayList<OAuth20Token> tokenList = null;
        try {
            OAuth20Token code;
            if (tokens.size() >= 1 && (code = tokens.get(0)) != null) {
                String clientId = attributeList.getAttributeValueByName("client_id");
                String redirectUri = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:body:param");
                String[] scope = code.getScope();
                String username = code.getUsername();
                String stateId = code.getStateId();
                Map<String, String[]> refreshTokenMap = tokenFactory.buildTokenMap(clientId, username, redirectUri, stateId, scope, code, "authorization_code");
                String key = "com.ibm.wsspi.security.oidc.external.claims:originalGrantType";
                refreshTokenMap.put(key, new String[]{"authorization_code"});
                OAuth20Token refresh = tokenFactory.createRefreshToken(refreshTokenMap);
                Map<String, String[]> accessTokenMap = tokenFactory.buildTokenMap(clientId, username, redirectUri, stateId, scope, code, "authorization_code");
                if (refresh != null) {
                    accessTokenMap.put("refresh_key", new String[]{refresh.getId()});
                }
                OAuth20Util.populateJwtAccessTokenData(attributeList, accessTokenMap);
                String proxy = attributeList.getAttributeValueByName("X-Forwarded-Host");
                accessTokenMap.put("X-Forwarded-Host", new String[]{proxy});
                OAuth20Token access = tokenFactory.createAccessToken(accessTokenMap);
                tokenList = new ArrayList<OAuth20Token>();
                tokenList.add(access);
                if (refresh != null) {
                    tokenList.add(refresh);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseGrantType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token refresh;
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                String accessToken = token.getTokenString();
                attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{accessToken});
                String accessTokenId = token.getId();
                attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{accessTokenId});
                String type = token.getSubType();
                attributeList.setAttribute("token_type", "urn:ibm:names:oauth:response:attribute", new String[]{type});
                String expires = OAuth20TokenHelper.expiresInSeconds(token);
                attributeList.setAttribute("expires_in", "urn:ibm:names:oauth:response:attribute", new String[]{expires});
                String stateId = token.getStateId();
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{stateId});
                String[] scope = token.getScope();
                attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
            }
            if (tokens.size() >= 2 && (refresh = tokens.get(1)) != null) {
                String refreshToken = refresh.getTokenString();
                attributeList.setAttribute("refresh_token", "urn:ibm:names:oauth:response:attribute", new String[]{refreshToken});
                String refreshTokenId = refresh.getId();
                attributeList.setAttribute("refresh_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{refreshTokenId});
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

