/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.audit;

import com.ibm.oauth.core.api.audit.OAuthAuditHandler;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentInternal;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20AuditHandlerFactory {
    static final String CLASS = OAuth20AuditHandlerFactory.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);
    static Map<String, OAuthAuditHandler> _auditHandlerMap = new HashMap<String, OAuthAuditHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OAuthAuditHandler getAuditHandler(OAuth20ComponentInternal component) throws OAuthConfigurationException {
        String methodName = "getAuditHandler";
        _log.entering(CLASS, methodName);
        OAuthAuditHandler result = null;
        try {
            String componentId = component.getParentComponentInstance().getInstanceId();
            if (!_auditHandlerMap.containsKey(componentId)) {
                Map<String, OAuthAuditHandler> map = _auditHandlerMap;
                synchronized (map) {
                    if (!_auditHandlerMap.containsKey(componentId)) {
                        OAuth20ConfigProvider config = component.get20Configuration();
                        result = config.getAuditHandler();
                        _auditHandlerMap.put(componentId, result);
                    }
                }
            }
            result = _auditHandlerMap.get(componentId);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return result;
    }
}

