/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.config;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.util.ConfigUtils;

public class OAuthConfigurationImpl {
    protected OAuthComponentConfiguration _oldconfig;
    private static final TraceComponent tc = Tr.register(OAuthConfigurationImpl.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");

    public OAuthConfigurationImpl(OAuthComponentConfiguration configIn) {
        this._oldconfig = configIn;
    }

    protected Object processClass(String className, String configConstant, Class<?> interfaceName) throws OAuthException {
        if (className == null) {
            throw new OAuthConfigurationException("security.oauth.error.config.notspecified.exception", configConstant, "null", null);
        }
        try {
            Object ret;
            ClassLoader cl = null;
            cl = !ConfigUtils.isBuiltinClass(className) ? this._oldconfig.getPluginClassLoader() : this.getClass().getClassLoader();
            Class<?> klass = cl.loadClass(className);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processClass", (Object[])new Object[]{className, configConstant, interfaceName, cl});
            }
            if (!interfaceName.isAssignableFrom((ret = klass.newInstance()).getClass())) {
                throw new OAuthConfigurationException("security.oauth.error.classmismatch.exception", configConstant, interfaceName.getName(), null);
            }
            return ret;
        }
        catch (ClassNotFoundException e) {
            throw new OAuthConfigurationException("security.oauth.error.classinstantiation.exception", configConstant, className, e);
        }
        catch (IllegalAccessException e) {
            throw new OAuthConfigurationException("security.oauth.error.classinstantiation.exception", configConstant, className, e);
        }
        catch (InstantiationException e) {
            throw new OAuthConfigurationException("security.oauth.error.classinstantiation.exception", configConstant, className, e);
        }
    }

    protected int validateNonNegativeInt(String configConstant) throws OAuthException {
        int result = this._oldconfig.getConfigPropertyIntValue(configConstant);
        if (result < 0) {
            throw new OAuthConfigurationException("security.oauth.error.invalidconfig.exception", configConstant, result + "", null);
        }
        return result;
    }

    protected boolean validateBoolean(String configConstant) throws OAuthException {
        boolean result = this._oldconfig.getConfigPropertyBooleanValue(configConstant);
        return result;
    }
}

