/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.builtin;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authorization.RoleSet;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class BaseAuthorizationTableService
implements UserRegistryChangeListener {
    private static final TraceComponent tc = Tr.register(BaseAuthorizationTableService.class, (String)"Security.Authorization", (String)"com.ibm.ws.security.authorization.builtin.internal.resources.AuthorizationMessages");
    static final String KEY_SECURITY_SERVICE = "securityService";
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    static final String KEY_CONFIG_ADMIN = "configurationAdmin";
    protected final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    static final String KEY_LDAP_REGISTRY = "(service.factoryPid=com.ibm.ws.security.registry.ldap.config)";
    static final String KEY_IGNORE_CASE = "ignoreCase";
    static final String KEY_CONFIGURATION = "configuration";
    private boolean isIgnoreCaseSet = false;
    private boolean isIgnoreCase = false;
    protected String bundleLocation;
    static final long serialVersionUID = -8927056895720643177L;

    @Reference(service=SecurityService.class, name="securityService", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    @Reference(service=ConfigurationAdmin.class, name="configurationAdmin", cardinality=ReferenceCardinality.OPTIONAL)
    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> reference) {
        this.configAdminRef.setReference(reference);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> reference) {
        this.configAdminRef.unsetReference(reference);
    }

    protected void activate(ComponentContext cc) {
        this.securityServiceRef.activate(cc);
        this.configAdminRef.activate(cc);
        this.bundleLocation = cc.getBundleContext().getBundle().getLocation();
    }

    protected void deactivate(ComponentContext cc) {
        this.securityServiceRef.deactivate(cc);
        this.configAdminRef.deactivate(cc);
        this.bundleLocation = null;
    }

    public void notifyOfUserRegistryChange() {
        this.isIgnoreCaseSet = false;
    }

    protected boolean isIgnoreCase() {
        if (!this.isIgnoreCaseSet) {
            this.isIgnoreCase = this.getIgnoreCase();
            this.isIgnoreCaseSet = true;
        }
        return this.isIgnoreCase;
    }

    protected boolean isMatch(String a, String b) {
        boolean match = false;
        match = this.isIgnoreCase() ? a.equalsIgnoreCase(b) : a.equals(b);
        return match;
    }

    @FFDCIgnore(value={InvalidNameException.class})
    private boolean areLDAPNames(String a, String b) {
        try {
            new LdapName(this.getNameFromAccessId(a));
            new LdapName(this.getNameFromAccessId(b));
        }
        catch (InvalidNameException e) {
            return false;
        }
        return true;
    }

    private String getNameFromAccessId(String id) {
        if (id == null) {
            return "";
        }
        int realmDelimiterIndex = (id = id.trim()).indexOf("/");
        if (realmDelimiterIndex < 0) {
            return "";
        }
        return id.substring(realmDelimiterIndex + 1);
    }

    protected Set<String> getRoles(Map<String, Set<String>> table, String key) {
        Set<String> value = null;
        if (this.isIgnoreCase()) {
            for (Map.Entry<String, Set<String>> entry : table.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(key)) continue;
                value = entry.getValue();
                break;
            }
        } else {
            value = table.get(key);
        }
        return value;
    }

    protected RoleSet getRoleSet(Map<String, RoleSet> table, String key) {
        RoleSet value = null;
        if (this.isIgnoreCase()) {
            for (Map.Entry<String, RoleSet> entry : table.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(key)) continue;
                value = entry.getValue();
                break;
            }
        } else {
            value = table.get(key);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean getIgnoreCase() {
        boolean value;
        block13: {
            value = false;
            if (this.securityServiceRef != null && this.configAdminRef != null) {
                try {
                    String type;
                    UserRegistryService userRegistryService;
                    SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                    if (securityService == null || (userRegistryService = securityService.getUserRegistryService()) == null || !userRegistryService.isUserRegistryConfigured() || !"LDAP".equalsIgnoreCase(type = userRegistryService.getUserRegistryType()) && !"WIM".equalsIgnoreCase(type)) break block13;
                    value = true;
                    ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
                    if (configAdmin != null) {
                        Configuration[] ldapRegistryConfigs = configAdmin.listConfigurations(KEY_LDAP_REGISTRY);
                        if (ldapRegistryConfigs != null) {
                            for (int i = 0; i < ldapRegistryConfigs.length; ++i) {
                                Object ignoreCaseObject;
                                Dictionary props = ldapRegistryConfigs[i].getProperties();
                                if (props != null && (ignoreCaseObject = props.get(KEY_IGNORE_CASE)) != null) {
                                    if (ignoreCaseObject instanceof Boolean) {
                                        value = (Boolean)ignoreCaseObject;
                                    } else if (ignoreCaseObject instanceof String && "false".equalsIgnoreCase((String)ignoreCaseObject)) {
                                        value = false;
                                    }
                                }
                                if (value) {
                                    continue;
                                }
                                break block13;
                            }
                            break block13;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The Ldap Configuration object is null, use the default value which is true.", (Object[])new Object[0]);
                        }
                        break block13;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The ConfigurationAdmin object is null, use the default value which is true.", (Object[])new Object[0]);
                    }
                }
                catch (Exception securityService) {
                    void e;
                    FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.security.authorization.builtin.BaseAuthorizationTableService", (String)"234", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)("Exception is caught while accessing the user registry configuration information. The default value " + value + " is used."), (Object[])new Object[]{e});
                }
            }
        }
        return value;
    }
}

