/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.uow;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import java.util.ArrayList;
import java.util.Iterator;

public class UOWScopeCallbackManager {
    private static final TraceComponent tc = Tr.register(UOWScopeCallbackManager.class, (String)"Transaction", null);
    private ArrayList<UOWScopeCallback> _callbacks;

    public void addCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCallback", (Object)callback);
        }
        if (this._callbacks == null) {
            this._callbacks = new ArrayList();
        }
        this._callbacks.add(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCallback");
        }
    }

    public void removeCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeCallback", (Object)callback);
        }
        if (this._callbacks != null) {
            boolean result = this._callbacks.remove(callback);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("callback found/removed: " + result));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeCallback");
        }
    }

    public void notifyCallbacks(int contextChangeType, UOWScope scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyCallbacks", (Object)new Object[]{contextChangeType, scope, this});
        }
        if (this._callbacks != null) {
            Iterator<UOWScopeCallback> callbacks = this._callbacks.iterator();
            while (callbacks.hasNext()) {
                callbacks.next().contextChange(contextChangeType, scope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyCallbacks");
        }
    }
}

