/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.util.logging;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.util.logging.TxTraceComponent;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.tx.util.logging.Tracer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TxTr
implements Tracer {
    private static Logger _logger;
    private String SOURCE_METHOD;
    private static String TRACEFile;
    private static String TRACELoggerName;
    private static String TRACELoggerResourceBundle;

    public TxTr() throws Exception {
        this(TRACEFile);
    }

    public TxTr(String file) throws Exception {
        _logger = TRACELoggerName == null ? Logger.getAnonymousLogger() : Logger.getLogger(TRACELoggerName, TRACELoggerResourceBundle);
        _logger.setLevel(Level.OFF);
        _logger.addHandler(new FileHandler(file));
    }

    public void initTrace() {
        Level traceLevel = ConfigurationProviderManager.getConfigurationProvider().getTraceLevel();
        _logger.setLevel(traceLevel);
        if (traceLevel.intValue() <= Level.FINE.intValue()) {
            TxTraceComponent.svDebugEnabled = true;
            TxTraceComponent.svEntryEnabled = true;
            TxTraceComponent.svEventEnabled = true;
        }
    }

    public void debug(TraceComponent tc, String s) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s);
    }

    public void debug(TraceComponent tc, String s, Object o) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void debug(TraceComponent tc, String s, Object[] o) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void entry(TraceComponent tc, String s, Object o) {
        _logger.entering(((TxTraceComponent)tc).getClassName(), s, o);
    }

    public void entry(TraceComponent tc, String s, Object[] o) {
        _logger.entering(((TxTraceComponent)tc).getClassName(), s, o);
    }

    public void entry(TraceComponent tc, String s) {
        _logger.entering(((TxTraceComponent)tc).getClassName(), s);
    }

    public void error(TraceComponent tc, String s, Object o) {
        _logger.logp(Level.SEVERE, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void error(TraceComponent tc, String s, Object[] o) {
        _logger.logp(Level.SEVERE, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void error(TraceComponent tc, String s) {
        _logger.logp(Level.SEVERE, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s);
    }

    public void event(TraceComponent tc, String s) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s);
    }

    public void event(TraceComponent tc, String s, Object o) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void event(TraceComponent tc, String s, Object[] o) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void exit(TraceComponent tc, String s) {
        _logger.exiting(((TxTraceComponent)tc).getClassName(), s);
    }

    public void exit(TraceComponent tc, String s, Object o) {
        _logger.exiting(((TxTraceComponent)tc).getClassName(), s, o);
    }

    public void exit(TraceComponent tc, String s, Object[] o) {
        _logger.exiting(((TxTraceComponent)tc).getClassName(), s, o);
    }

    public void fatal(TraceComponent tc, String s) {
        _logger.logp(Level.SEVERE, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s);
    }

    public void fatal(TraceComponent tc, String s, Object o) {
        _logger.logp(Level.SEVERE, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void fatal(TraceComponent tc, String s, Object[] o) {
        _logger.logp(Level.SEVERE, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void info(TraceComponent tc, String s, Object o) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void info(TraceComponent tc, String s, Object[] o) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public TraceComponent register(Class cl, String traceGroup, String nlsFile) {
        return new TxTraceComponent(cl, traceGroup, nlsFile);
    }

    public TraceComponent register(String s, String traceGroup, String nlsFile) {
        return new TxTraceComponent(s, traceGroup, nlsFile);
    }

    public void warning(TraceComponent tc, String s, Object o) {
        _logger.logp(Level.WARNING, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void warning(TraceComponent tc, String s, Object[] o) {
        _logger.logp(Level.WARNING, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void audit(TraceComponent tc, String s) {
        _logger.logp(Level.WARNING, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s);
    }

    public void audit(TraceComponent tc, String s, Object o) {
        _logger.logp(Level.WARNING, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void audit(TraceComponent tc, String s, Object[] o) {
        _logger.logp(Level.WARNING, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s, o);
    }

    public void info(TraceComponent tc, String s) {
        _logger.logp(Level.INFO, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s);
    }

    public void warning(TraceComponent tc, String s) {
        _logger.logp(Level.WARNING, ((TxTraceComponent)tc).getClassName(), this.SOURCE_METHOD, s);
    }

    static {
        TRACEFile = System.getProperty("com.ibm.tx.TraceFile", "trace.xml");
        TRACELoggerName = System.getProperty("com.ibm.tx.TraceLoggerName");
        TRACELoggerResourceBundle = System.getProperty("com.ibm.tx.TraceLoggerResourceBundle");
    }
}

