/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.config.DefaultConfigurationProvider;
import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.LeaseTimeoutManager;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.util.TranLogConfiguration;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.HeartbeatLog;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.InvalidLogPropertiesException;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.resource.ResourceFactory;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class TxRecoveryAgentImpl
implements RecoveryAgent {
    private static final TraceComponent tc = Tr.register(TxRecoveryAgentImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int transactionLogRLI = 1;
    private static final int partnerLogRLI = 2;
    private static final int TRANSACTION_RECOVERYLOG_FORMAT_VERSION = 1;
    protected RecoveryDirector _recoveryDirector;
    private RecoveryManager _recoveryManager;
    protected final HashMap<String, FailureScopeController> failureScopeControllerTable = new HashMap();
    private RecoveryLog _transactionLog;
    private RecoveryLog _partnerLog;
    SharedServerLeaseLog _leaseLog;
    private String _recoveryGroup;
    private boolean _isPeerRecoverySupported;
    protected String localRecoveryIdentity;
    private ClassLoadingService clService;
    private boolean _checkingLeases = true;
    private static ThreadLocal<Boolean> _replayThread = new ThreadLocal();

    protected TxRecoveryAgentImpl() {
    }

    public TxRecoveryAgentImpl(RecoveryDirector rd) throws Exception {
        this._recoveryDirector = rd;
        RecoveryLogManager rlm = rd.registerService((RecoveryAgent)this, 2);
        Configuration.setLogManager(rlm);
        FailureScope currentFailureScope = rd.currentFailureScope();
        Configuration.setServerName(currentFailureScope.serverName());
        this.localRecoveryIdentity = currentFailureScope.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"TxRecoveryAgentImpl constructor - localRecoveryIdentity set to ", (Object[])new Object[]{this.localRecoveryIdentity});
        }
        FailureScopeController fsc = this.createFailureScopeController(currentFailureScope);
        this.failureScopeControllerTable.put(currentFailureScope.serverName(), fsc);
        Configuration.setFailureScopeController(fsc);
        byte[] newApplId = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        _replayThread.set(false);
        if (cp.getApplId() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TXAGENT, cp applid null - " + cp + " set applid - " + Util.toHexString(newApplId)), (Object[])new Object[0]);
            }
            cp.setApplId(newApplId);
            Configuration.setApplId(newApplId);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TXAGENT, do not reset cp - " + cp + " set applid - " + Util.toHexString(cp.getApplId())), (Object[])new Object[0]);
            }
            Configuration.setApplId(cp.getApplId());
        }
    }

    public void agentReportedFailure(int clientId, FailureScope failureScope) {
    }

    public int clientIdentifier() {
        return 1;
    }

    public String clientName() {
        return "transaction";
    }

    public int clientVersion() {
        return 1;
    }

    public boolean disableFileLocking() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initiateRecovery(FailureScope fs) throws RecoveryFailedException {
        block49: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initiateRecovery", (Object[])new Object[]{fs});
            }
            String recoveredServerIdentity = null;
            try {
                RecoveryFailedException rex;
                boolean localRecovery;
                FailureScopeController fsc;
                ConfigurationProvider cp;
                block50: {
                    TranLogConfiguration tlc;
                    block52: {
                        block51: {
                            recoveredServerIdentity = fs.serverName();
                            if (this._isPeerRecoverySupported) {
                                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Recovery initiated for server " + recoveredServerIdentity), (Object[])new Object[0]);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Recovery initiated for server -  ", (Object[])new Object[]{recoveredServerIdentity});
                            }
                            boolean isCustom = false;
                            cp = ConfigurationProviderManager.getConfigurationProvider();
                            String logDir = cp.getTransactionLogDirectory();
                            int logSize = cp.getTransactionLogSize();
                            if (logDir.startsWith("custom")) {
                                isCustom = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Found a custom tran log directory", (Object[])new Object[0]);
                                }
                            }
                            tlc = null;
                            tlc = isCustom ? this.createCustomTranLogConfiguration(recoveredServerIdentity, logDir, this._isPeerRecoverySupported) : this.createFileTranLogConfiguration(recoveredServerIdentity, fs, logDir, logSize, this._isPeerRecoverySupported);
                            fsc = this.failureScopeControllerTable.get(recoveredServerIdentity);
                            if (fsc == null) break block51;
                            if (fsc.getRecoveryManager() == null) break block52;
                            if (this._isPeerRecoverySupported) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Where peer recovery is supported, a pre-existing RM is ok", (Object[])new Object[0]);
                                }
                                break block52;
                            } else {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)("already recovering failure scope " + fs));
                                }
                                throw new RecoveryFailedException("Already recovering failure scope " + fs);
                            }
                        }
                        try {
                            fsc = this.createFailureScopeController(fs);
                        }
                        catch (Exception exc) {
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1177", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception caught whist creating FailureScopeController", (Object[])new Object[]{exc});
                            }
                            throw new RecoveryFailedException((Throwable)exc);
                        }
                        this.failureScopeControllerTable.put(recoveredServerIdentity, fsc);
                    }
                    byte[] applId = ConfigurationProviderManager.getConfigurationProvider().getApplId();
                    int epoch = Configuration.getCurrentEpoch();
                    if (tlc != null && tlc.enabled()) {
                        HeartbeatLog heartbeatLog;
                        CustomLogProperties partnerLogProps;
                        CustomLogProperties transactionLogProps;
                        if (tlc.type() == 3) {
                            transactionLogProps = new CustomLogProperties(1, "tranlog", tlc.customId(), tlc.customProperties());
                            partnerLogProps = new CustomLogProperties(2, "partnerlog", tlc.customId(), tlc.customProperties());
                            ResourceFactory nontranDSResourceFactory = ConfigurationProviderManager.getConfigurationProvider().getResourceFactory();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Retrieved non tran DS Resource Factory, ", (Object[])new Object[]{nontranDSResourceFactory});
                            }
                            transactionLogProps.setResourceFactory(nontranDSResourceFactory);
                            partnerLogProps.setResourceFactory(nontranDSResourceFactory);
                        } else {
                            String tranLogDirStem = tlc.expandedLogDirectory();
                            tranLogDirStem = tranLogDirStem.trim();
                            String tranLogDirToUse = tranLogDirStem + File.separator + "tranlog";
                            transactionLogProps = new FileLogProperties(1, "tranlog", tranLogDirToUse, tlc.logFileSize(), tranLogDirStem);
                            String partnerLogDirToUse = tlc.expandedLogDirectory();
                            partnerLogDirToUse = partnerLogDirToUse.trim() + File.separator + "partnerlog";
                            partnerLogProps = new FileLogProperties(2, "partnerlog", partnerLogDirToUse, tlc.logFileSize());
                        }
                        RecoveryLogManager rlm = Configuration.getLogManager();
                        this._transactionLog = rlm.getRecoveryLog(fs, (LogProperties)transactionLogProps);
                        if (this._transactionLog != null && this._transactionLog instanceof HeartbeatLog) {
                            heartbeatLog = (HeartbeatLog)this._transactionLog;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"The transaction log is a Heartbeatlog, configure SQL HADB retry parameters", (Object[])new Object[0]);
                            }
                            this.configureSQLHADBRetryParameters(heartbeatLog, cp);
                        }
                        this._partnerLog = rlm.getRecoveryLog(fs, (LogProperties)partnerLogProps);
                        if (this._partnerLog != null && this._partnerLog instanceof HeartbeatLog) {
                            heartbeatLog = (HeartbeatLog)this._partnerLog;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"The partner log is a Heartbeatlog, configure SQL HADB retry parameters", (Object[])new Object[0]);
                            }
                            this.configureSQLHADBRetryParameters(heartbeatLog, cp);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Test to see if peer recovery is supported -  ", (Object[])new Object[]{this._isPeerRecoverySupported});
                        }
                        if (this._isPeerRecoverySupported) {
                            this._leaseLog = rlm.getLeaseLog(this.localRecoveryIdentity, this._recoveryGroup, cp.getLeaseCheckInterval(), cp.getLeaseCheckStrategy(), cp.getLeaseLength(), (LogProperties)transactionLogProps);
                        }
                    }
                    fsc.createRecoveryManager(this, this._transactionLog, this._partnerLog, null, applId, epoch);
                    this._recoveryManager = fsc.getRecoveryManager();
                    localRecovery = recoveredServerIdentity.equals(this.localRecoveryIdentity);
                    if (this._leaseLog != null) {
                        if (localRecovery && !this._leaseLog.lockLocalLease(this.localRecoveryIdentity)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Cannot lock server's own logs", (Object[])new Object[0]);
                            }
                            Object[] errorObject = new Object[]{this.localRecoveryIdentity};
                            rex = new RecoveryFailedException("Cannot lock server's own logs");
                            Tr.audit((TraceComponent)tc, (String)"CWRLS0008_RECOVERY_LOG_FAILED", (Object[])errorObject);
                            Tr.info((TraceComponent)tc, (String)"CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", (Object[])new Object[]{rex});
                            this._recoveryManager.recoveryFailed(rex);
                            if (!this.doNotShutdownOnRecoveryFailure()) {
                                cp.shutDownFramework();
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)rex));
                            }
                            Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{rex});
                            throw rex;
                        }
                        this._recoveryManager.setLeaseLog(this._leaseLog);
                        this._recoveryManager.setRecoveryGroup(this._recoveryGroup);
                        this._recoveryManager.setLocalRecoveryIdentity(this.localRecoveryIdentity);
                    }
                    final Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                        @Override
                        public Thread run() {
                            return new Thread((Runnable)TxRecoveryAgentImpl.this._recoveryManager, "Recovery Thread");
                        }
                    });
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws RecoveryFailedException {
                            if (!cp.getClass().getCanonicalName().equals(DefaultConfigurationProvider.class.getCanonicalName())) {
                                ClassLoader cl = TxRecoveryAgentImpl.this.getThreadContextClassLoader(TxRecoveryAgentImpl.class);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Setting Context ClassLoader on " + t.getName() + " (" + String.format("%08X", t.getId()) + ")"), (Object[])new Object[]{cl});
                                }
                                t.setContextClassLoader(cl);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("unit testing so not setting Context ClassLoader on " + t.getName() + " (" + String.format("%08X", t.getId()) + ")"), (Object[])new Object[0]);
                            }
                            return null;
                        }
                    });
                    t.start();
                    this._recoveryDirector.serialRecoveryComplete((RecoveryAgent)this, fs);
                    fsc.getRecoveryManager().waitForReplayCompletion();
                    if (!localRecovery) {
                        fsc.getRecoveryManager().waitForRecoveryCompletion();
                    }
                    if (this._leaseLog == null) break block49;
                    try {
                        if (localRecovery) {
                            if (this._leaseLog.releaseLocalLease(recoveredServerIdentity) && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Have released locallease lock", (Object[])new Object[0]);
                            }
                            break block50;
                        }
                        if (this._leaseLog.releasePeerLease(recoveredServerIdentity) && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Have released peer lease lock", (Object[])new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block50;
                        Tr.debug((TraceComponent)tc, (String)("Caught exception on lock release - " + e), (Object[])new Object[0]);
                    }
                }
                if (fsc.getRecoveryManager().recoveryFailed()) {
                    rex = new RecoveryFailedException();
                    if (localRecovery && !this.doNotShutdownOnRecoveryFailure()) {
                        cp.shutDownFramework();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)rex));
                    }
                    Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{rex});
                    throw rex;
                }
                if (localRecovery) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Local server recovery identity so spawn lease timeout manager", (Object[])new Object[0]);
                    }
                    LeaseTimeoutManager.setTimeouts(this._leaseLog, recoveredServerIdentity, this._recoveryGroup, this, this._recoveryDirector, cp.getLeaseLength() * cp.getLeaseRenewalTime() / 100, cp.getLeaseCheckInterval());
                }
            }
            catch (InvalidFailureScopeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1599", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)e));
                }
                throw new RecoveryFailedException((Throwable)e);
            }
            catch (InvalidLogPropertiesException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1599", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)e));
                }
                throw new RecoveryFailedException((Throwable)e);
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1599", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)e);
                }
                throw new RecoveryFailedException((Throwable)e);
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"463", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)e);
                }
                throw new RecoveryFailedException((Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initiateRecovery");
        }
    }

    private ClassLoader getThreadContextClassLoader(Class<? extends TxRecoveryAgentImpl> cl) throws RecoveryFailedException {
        return this.getClassLoadingService().createThreadContextClassLoader(cl.getClassLoader());
    }

    public synchronized ClassLoadingService getClassLoadingService() throws RecoveryFailedException {
        if (this.clService == null) {
            this.clService = this.getService(ClassLoadingService.class);
        }
        return this.clService;
    }

    private <T> T getService(Class<T> service) throws RecoveryFailedException {
        Object impl = null;
        BundleContext context = FrameworkUtil.getBundle(service).getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        if (ref == null) {
            throw new RecoveryFailedException("Unable to locate service: " + service);
        }
        impl = context.getService(ref);
        return (T)impl;
    }

    public void terminateRecovery(FailureScope fs) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminateRecovery", (Object[])new Object[]{fs});
        }
        String terminateServerName = fs.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The transaction service has received a request to terminate recovery processing for server " + terminateServerName), (Object[])new Object[0]);
        }
        RecoveryDirector recoveryDirector = null;
        try {
            recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.runtime.component.TxServiceImpl.terminateRecovery", (String)"1274", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException((Throwable)exc);
        }
        boolean terminatingThisServer = terminateServerName.equals(Configuration.getServerName());
        if (terminatingThisServer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received unexpected request to terminate recovery processing for local failure scope", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException();
        }
        FailureScopeController fsc = this.failureScopeControllerTable.remove(terminateServerName);
        if (fsc != null) {
            fsc.shutdown(false);
        }
        try {
            recoveryDirector.terminationComplete((RecoveryAgent)this, fs);
        }
        catch (InvalidFailureScopeException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.runtime.component.TxServiceImpl.terminateRecovery", (String)"1308", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to indicate termination completion to recovery director: " + (Object)((Object)exc)), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
        }
    }

    public void stop(boolean immediate) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop", (Object[])new Object[]{immediate});
        }
        LeaseTimeoutManager.stopTimeout();
        if (this._partnerLog != null && this._partnerLog instanceof HeartbeatLog) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The log is a Heartbeatlog", (Object[])new Object[0]);
            }
            HeartbeatLog heartbeatLog = (HeartbeatLog)this._partnerLog;
            heartbeatLog.serverStopping();
        }
        Collection<FailureScopeController> failureScopeControllerTableValues = this.failureScopeControllerTable.values();
        for (FailureScopeController fsc : failureScopeControllerTableValues) {
            fsc.shutdown(immediate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void logFileWarning(String logname, int bytesInUse, int bytesTotal) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logFileWarning", (Object[])new Object[]{logname, bytesInUse, bytesTotal});
        }
    }

    public void setRecoveryGroup(String recoveryGroup) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setRecoveryGroup", (Object[])new Object[]{recoveryGroup});
        }
        this._recoveryGroup = recoveryGroup;
    }

    public String getRecoveryGroup() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryGroup", (Object[])new Object[]{this._recoveryGroup});
        }
        return this._recoveryGroup;
    }

    public void setPeerRecoverySupported(boolean isPeerRecoverySupported) {
        this._isPeerRecoverySupported = isPeerRecoverySupported;
    }

    public ArrayList<String> processLeasesForPeers(String recoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processLeasesForPeers", (Object[])new Object[]{recoveryIdentity, recoveryGroup});
        }
        ArrayList peersToRecover = null;
        if (this._leaseLog != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("work with leaseLog " + this._leaseLog), (Object[])new Object[0]);
            }
            try {
                PeerLeaseTable peerLeaseTable = new PeerLeaseTable();
                this._leaseLog.getLeasesForPeers(peerLeaseTable, recoveryGroup);
                peersToRecover = peerLeaseTable.getExpiredPeers();
                peersToRecover.remove(recoveryIdentity);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have checked leases for " + peerLeaseTable.size() + " peer" + (peerLeaseTable.size() != 1 ? "s" : "") + " in recovery group " + recoveryGroup), (Object[])new Object[0]);
                    if (peersToRecover.size() > 0) {
                        for (String peer : peersToRecover) {
                            Tr.debug((TraceComponent)tc, (String)("Need to recover: " + peer), (Object[])new Object[0]);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Caught exception when trying to get leases for peers: " + e);
                e.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLeasesForPeers", peersToRecover);
        }
        return peersToRecover;
    }

    public boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, this});
        }
        boolean peerClaimed = this._leaseLog.claimPeerLeaseForRecovery(recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)peerClaimed);
        }
        return peerClaimed;
    }

    private TranLogConfiguration createCustomTranLogConfiguration(String recoveredServerIdentity, String logDir, boolean isPeerRecoverySupported) throws URISyntaxException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCustomTranLogConfiguration", (Object[])new Object[]{recoveredServerIdentity, logDir, this});
        }
        TranLogConfiguration tlc = null;
        Properties props = new Properties();
        URI logSettingURI = new URI(logDir);
        String scheme = logSettingURI.getScheme();
        String logSetting = logSettingURI.getAuthority();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Scheme read from URI " + scheme + ", log setting" + logSetting), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Test to see if peer recovery is supported -  ", (Object[])new Object[]{isPeerRecoverySupported});
        }
        if (isPeerRecoverySupported) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Work with server recovery identity -  " + recoveredServerIdentity + ", reset current logdir"), (Object[])new Object[0]);
            }
            if (recoveredServerIdentity != null) {
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty,tablesuffix=" + recoveredServerIdentity;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"log dir is now -  ", (Object[])new Object[]{logDir});
                }
            }
        }
        props.setProperty("LOG_DIRECTORY", logDir);
        tlc = new TranLogConfiguration(logSetting, props);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCustomTranLogConfiguration", (Object)tlc);
        }
        return tlc;
    }

    private TranLogConfiguration createFileTranLogConfiguration(String recoveredServerIdentity, FailureScope fs, String logDir, int logSize, boolean isPeerRecoverySupported) throws URISyntaxException, RecoveryFailedException {
        FileFailureScope ffs;
        LeaseInfo li;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFileTranLogConfiguration", (Object[])new Object[]{recoveredServerIdentity, fs, logDir, logSize, this});
        }
        TranLogConfiguration tlc = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Work with server recovery identity -  ", (Object[])new Object[]{recoveredServerIdentity});
        }
        if (recoveredServerIdentity.equals(this.localRecoveryIdentity)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Local server recovery identity so no need to reset the logDir", (Object[])new Object[0]);
            }
            tlc = new TranLogConfiguration(logDir, logDir, logSize);
        } else if (fs instanceof FileFailureScope && (li = (ffs = (FileFailureScope)fs).getLeaseInfo()) != null) {
            String s = li.getLeaseDetail().getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using log directory", (Object[])new Object[]{s});
            }
            tlc = new TranLogConfiguration(s, s, logSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFileTranLogConfiguration", (Object)tlc);
        }
        return tlc;
    }

    private boolean doNotShutdownOnRecoveryFailure() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doNotShutdownOnRecoveryFailure", (Object[])new Object[0]);
        }
        boolean doCheck = true;
        Boolean doNotShutdownOnRecoveryFailure = null;
        try {
            doNotShutdownOnRecoveryFailure = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    Boolean theResult = Boolean.getBoolean("com.ibm.ws.recoverylog.spi.DoNotShutdownOnRecoveryFailure");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have retrieved jvm property with result, " + theResult), (Object[])new Object[0]);
                    }
                    return theResult;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting DoNotShutdownOnRecoveryFailure property", (Object[])new Object[]{e});
            }
            doNotShutdownOnRecoveryFailure = null;
        }
        if (doNotShutdownOnRecoveryFailure == null) {
            doNotShutdownOnRecoveryFailure = Boolean.TRUE;
        }
        doCheck = doNotShutdownOnRecoveryFailure;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doNotShutdownOnRecoveryFailure", (Object)doCheck);
        }
        return doCheck;
    }

    protected FailureScopeController createFailureScopeController(FailureScope currentFailureScope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFailureScopeController", (Object[])new Object[]{currentFailureScope});
        }
        FailureScopeController fsc = new FailureScopeController(currentFailureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFailureScopeController", (Object)fsc);
        }
        return fsc;
    }

    public HeartbeatLog getHeartbeatLog(FailureScope fs) {
        HeartbeatLog heartbeatLog;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getHeartbeatLog", (Object[])new Object[]{fs});
            }
            RecoveryLog partnerLog = null;
            heartbeatLog = null;
            String recoveredServerIdentity = null;
            try {
                recoveredServerIdentity = fs.serverName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getHeartbeatLog for server -  ", (Object[])new Object[]{recoveredServerIdentity});
                }
                boolean isCustom = false;
                String logDir = ConfigurationProviderManager.getConfigurationProvider().getTransactionLogDirectory();
                if (logDir.startsWith("custom")) {
                    isCustom = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found a custom tran log directory", (Object[])new Object[0]);
                    }
                }
                TranLogConfiguration tlc = null;
                if (isCustom && (tlc = this.createCustomTranLogConfiguration(recoveredServerIdentity, logDir, this._isPeerRecoverySupported)) != null && tlc.enabled() && tlc.type() == 3) {
                    CustomLogProperties partnerLogProps = new CustomLogProperties(2, "partnerlog", tlc.customId(), tlc.customProperties());
                    ResourceFactory nontranDSResourceFactory = ConfigurationProviderManager.getConfigurationProvider().getResourceFactory();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Retrieved non tran DS Resource Factory, ", (Object[])new Object[]{nontranDSResourceFactory});
                    }
                    partnerLogProps.setResourceFactory(nontranDSResourceFactory);
                    RecoveryLogManager rlm = Configuration.getLogManager();
                    partnerLog = rlm.getRecoveryLog(fs, (LogProperties)partnerLogProps);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Custom PartnerLog is set - ", (Object[])new Object[]{partnerLog});
                    }
                    if (partnerLog != null && partnerLog instanceof HeartbeatLog) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The log is a Heartbeatlog", (Object[])new Object[0]);
                        }
                        heartbeatLog = (HeartbeatLog)partnerLog;
                        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
                        this.configureSQLPeerLockParameters(heartbeatLog, cp);
                        this.configureSQLHADBRetryParameters(heartbeatLog, cp);
                        this.configureSQLHADBLightweightRetryParameters(heartbeatLog, cp);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isEntryEnabled()) break block12;
                Tr.exit((TraceComponent)tc, (String)"getHeartbeatLog", (Object)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHeartbeatLog", heartbeatLog);
        }
        return heartbeatLog;
    }

    public boolean isDBTXLogPeerLocking() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isDBTXLogPeerLocking", (Object[])new Object[0]);
        }
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        boolean enableLocking = cp.enableHADBPeerLocking();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isDBTXLogPeerLocking", (Object)enableLocking);
        }
        return enableLocking;
    }

    private void configureSQLPeerLockParameters(HeartbeatLog heartbeatLog, ConfigurationProvider cp) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configureSQLPeerLockParameters", (Object[])new Object[]{heartbeatLog, cp, this});
        }
        int peerLockTimeBeforeStale = cp.getPeerTimeBeforeStale();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"peerLockTimeBeforeStale - ", (Object[])new Object[]{peerLockTimeBeforeStale});
        }
        heartbeatLog.setTimeBeforeLogStale(peerLockTimeBeforeStale);
        int timeBetweenHeartbeats = cp.getTimeBetweenHeartbeats();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"timeBetweenHeartbeats - ", (Object[])new Object[]{timeBetweenHeartbeats});
        }
        heartbeatLog.setTimeBetweenHeartbeats(timeBetweenHeartbeats);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configureSQLPeerLockParameters");
        }
    }

    private void configureSQLHADBRetryParameters(HeartbeatLog heartbeatLog, ConfigurationProvider cp) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configureSQLHADBRetryParameters", (Object[])new Object[]{heartbeatLog, cp, this});
        }
        int standardTransientErrorRetryTime = cp.getStandardTransientErrorRetryTime();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"standardTransientErrorRetryTime - ", (Object[])new Object[]{standardTransientErrorRetryTime});
        }
        heartbeatLog.setStandardTransientErrorRetryTime(standardTransientErrorRetryTime);
        int standardTransientErrorRetryAttempts = cp.getStandardTransientErrorRetryAttempts();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"standardTransientErrorRetryAttempts - ", (Object[])new Object[]{standardTransientErrorRetryAttempts});
        }
        heartbeatLog.setStandardTransientErrorRetryAttempts(standardTransientErrorRetryAttempts);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configureSQLHADBRetryParameters");
        }
    }

    private void configureSQLHADBLightweightRetryParameters(HeartbeatLog heartbeatLog, ConfigurationProvider cp) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configureSQLHADBLightweightRetryParameters", (Object[])new Object[]{heartbeatLog, cp, this});
        }
        int lightweightTransientErrorRetryTime = cp.getLightweightTransientErrorRetryTime();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"lightweightTransientErrorRetryTime - ", (Object[])new Object[]{lightweightTransientErrorRetryTime});
        }
        heartbeatLog.setLightweightTransientErrorRetryTime(lightweightTransientErrorRetryTime);
        int lightweightTransientErrorRetryAttempts = cp.getLightweightTransientErrorRetryAttempts();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"lightweightTransientErrorRetryAttempts - ", (Object[])new Object[]{lightweightTransientErrorRetryAttempts});
        }
        heartbeatLog.setLightweightTransientErrorRetryAttempts(lightweightTransientErrorRetryAttempts);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configureSQLHADBLightweightRetryParameters");
        }
    }

    public RecoveryManager getRecoveryManager() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryManager", (Object[])new Object[]{this._recoveryManager});
        }
        return this._recoveryManager;
    }

    public boolean isReplayThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isReplayThread", (Object[])new Object[0]);
        }
        boolean isReplayThread = false;
        if (_replayThread.get() != null) {
            isReplayThread = _replayThread.get();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isReplayThread", (Object)isReplayThread);
        }
        return isReplayThread;
    }

    public void setReplayThread() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReplayThread", (Object[])new Object[0]);
        }
        _replayThread.set(Boolean.TRUE);
    }

    public boolean checkingLeases() {
        return this._checkingLeases;
    }

    public void setCheckingLeases(boolean b) {
        if (tc.isDebugEnabled() && b != this._checkingLeases) {
            if (b) {
                Tr.debug((TraceComponent)tc, (String)"Enabling lease checking", (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)"Disabling lease checking", (Object[])new Object[0]);
            }
        }
        this._checkingLeases = b;
    }

    public void terminateServer() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"terminateServer", (Object[])new Object[0]);
        }
        ConfigurationProviderManager.getConfigurationProvider().shutDownFramework();
    }
}

