/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.eca;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class ECAConnection {
    private static TraceComponent tc = Tr.register(ECAConnection.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static boolean usingSocket = true;
    Socket sock;

    public ECAConnection(Socket s) {
        this.sock = s;
    }

    public InputStream getInputStream() {
        InputStream s;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getInputStream", (Object[])new Object[0]);
            }
            s = null;
            try {
                if (usingSocket) {
                    s = this.sock.getInputStream();
                }
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("getInputStream exception " + e), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInputStream stream : " + s));
        }
        return s;
    }

    public OutputStream getOutputStream() {
        OutputStream o;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOutputStream", (Object[])new Object[0]);
            }
            o = null;
            try {
                if (usingSocket) {
                    o = this.sock.getOutputStream();
                }
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("getOutputStream exception " + e), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getOutputStream stream : " + o));
        }
        return o;
    }

    public InetAddress getInetAddress() {
        InetAddress a;
        block4: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getInetAddress", (Object[])new Object[0]);
            }
            a = null;
            try {
                a = usingSocket ? this.sock.getInetAddress() : InetAddress.getLocalHost();
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("getInetAddress exception " + e), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInetAddress addr : " + a));
        }
        return a;
    }

    public void close() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"close", (Object[])new Object[0]);
            }
            if (usingSocket) {
                try {
                    this.sock.close();
                }
                catch (IOException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("close exception " + e), (Object[])new Object[0]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }
}

