/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ConfigErrorHandler
implements ErrorHandler {
    private static TraceComponent tc = Tr.register(ConfigErrorHandler.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private URI _url;

    public ConfigErrorHandler(URL url) {
        try {
            this._url = url.toURI();
        }
        catch (URISyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + "<init>"), (String)"30", (Object)this);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        String filename = exception.getSystemId();
        if (filename == null && this._url != null) {
            filename = this._url.toString();
        }
        String msg = exception.getMessage();
        String line = Integer.toString(exception.getLineNumber());
        String col = Integer.toString(exception.getColumnNumber());
        Tr.error((TraceComponent)tc, (String)"DYNA0044E", (Object[])new Object[]{msg, filename, line, col});
    }

    @Override
    public void fatalError(SAXParseException exception) {
        String filename = exception.getSystemId();
        if (filename == null && this._url != null) {
            filename = this._url.toString();
        }
        String msg = exception.getMessage();
        String line = Integer.toString(exception.getLineNumber());
        String col = Integer.toString(exception.getColumnNumber());
        Tr.error((TraceComponent)tc, (String)"DYNA0045E", (Object[])new Object[]{msg, filename, line, col});
    }

    @Override
    public void warning(SAXParseException exception) {
        String filename = exception.getSystemId();
        if (filename == null && this._url != null) {
            filename = this._url.toString();
        }
        String msg = exception.getMessage();
        String line = Integer.toString(exception.getLineNumber());
        String col = Integer.toString(exception.getColumnNumber());
        Tr.error((TraceComponent)tc, (String)"DYNA0044E", (Object[])new Object[]{msg, filename, line, col});
    }
}

