/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.DiskCacheSizeInfo;
import com.ibm.ws.cache.HTODDependencyTable;
import com.ibm.ws.cache.HTODInvalidationBuffer;
import com.ibm.ws.cache.PrimitiveArrayPool;
import com.ibm.ws.cache.Result;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerException;
import com.ibm.ws.cache.persistent.filemgr.FileManagerImpl;
import com.ibm.ws.cache.persistent.htod.HashtableAction;
import com.ibm.ws.cache.persistent.htod.HashtableEntry;
import com.ibm.ws.cache.persistent.htod.HashtableOnDisk;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HTODDynacache {
    TraceComponent tc = Tr.register(HTODDynacache.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final boolean CHECK_EXPIRED = true;
    public static final boolean DELETE = true;
    public static final boolean EXIST = true;
    public static final boolean COMPLETE_CLEAR = true;
    public static final boolean FILTER = true;
    public static final boolean ALL = true;
    public static final boolean ADD_IF_NEW = true;
    public static final int NUM_SCAN = 50;
    public static final String DISKCACHE_MORE = "DISKCACHE_MORE";
    public static final boolean CALLED_FROM_REMOVE = true;
    public static final int NO_EXCEPTION = 0;
    public static final int DISK_EXCEPTION = 1;
    public static final int DISK_SIZE_OVER_LIMIT_EXCEPTION = 2;
    public static final int OTHER_EXCEPTION = 3;
    public static final int SERIALIZATION_EXCEPTION = 4;
    public static final int DISK_SIZE_IN_ENTRIES_OVER_LIMIT_EXCEPTION = 5;
    public static final int DISK_CACHE_ENTRY_SIZE_OVER_LIMIT_EXCEPTION = 6;
    public static final int NO_EXCEPTION_ENTRY_OVERWRITTEN = 7;
    public static final int NO_HASHCODE_OLD_FORMAT = 8;
    public static final int CACHE_ID_DATA = 1;
    public static final int DEP_ID_DATA = 2;
    public static final int TEMPLATE_ID_DATA = 3;
    public static final String DISK_CACHE_IN_GB_OVER_LIMIT_MSG = "The disk cache size in GB is over the limit.";
    public static final ValueSet EMPTY_VS = new ValueSet(1);
    protected ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public PrimitiveArrayPool byteArrayPool = null;
    public PrimitiveArrayPool longArrayPool = null;
    public HashtableEntryObjectPool htEntryPool = null;
    protected ResultObjectPool resultPool = null;
    protected EvictionEntryPool evictionEntryPool = null;
    protected HTODInvalidationBuffer invalidationBuffer = null;
    protected String filename;
    protected String dirname;
    protected FileManager object_filemgr;
    protected FileManager dependency_filemgr;
    protected FileManager template_filemgr;
    public static String object_suffix = "-objects";
    public static String dependency_suffix = "-dependencies";
    public static String template_suffix = "-templates";
    protected HashtableOnDisk object_cache = null;
    protected HashtableOnDisk dependency_cache = null;
    protected HashtableOnDisk template_cache = null;
    protected DCache cache = null;
    protected CacheOnDisk cod = null;
    boolean auto_rehash = false;
    long scanExpiredTime = 0L;
    public String cacheName = "";
    protected int initial_hashtable_size = 1296109;
    protected int hashtable_threshold = 75;
    protected int initial_valueset_size = 509;
    protected boolean valueset_rehash = true;
    protected int physical_disk_manager = 2;
    protected ValueSet removeIdsList = null;
    protected HTODDependencyTable auxDataDependencyTable = null;
    protected HTODDependencyTable auxTemplateDependencyTable = null;
    protected boolean delayOffload = false;
    protected boolean disableDependencyId = false;
    protected boolean disableTemplatesSupport = false;
    protected long minDiskCacheSizeInBytes = 0L;
    protected BinaryHeap EvictionTable = null;
    protected Object evictionTableMonitor = new Object();
    protected Random rand = null;
    protected Exception diskCacheException = null;
    protected boolean deleteDiskFiles = false;
    protected long timeElapsedWriteAuxTables = 0L;
    protected int numDepIdsInAuxTable = 0;
    protected int numCacheIdsInDepIdAuxTable = 0;
    protected int numTemplatesInAuxTable = 0;
    protected int numCacheIdsInTemplateAuxTable = 0;
    protected int numExplicitBufferLimitOnStop = 0;
    protected HashMap<Object, Object> cacheIdsTable = null;
    long totalDeleted = 0L;
    long totalDeletedSize = 0L;

    public HTODDynacache() {
        PrimitiveArrayPool.PoolConfig bytePoolConfig = new PrimitiveArrayPool.PoolConfig();
        bytePoolConfig.type = 1;
        bytePoolConfig.numberOfPools = 20;
        bytePoolConfig.poolSize = 2;
        bytePoolConfig.poolEntryLife = 300000;
        bytePoolConfig.scanFrequency = 60000;
        this.byteArrayPool = new PrimitiveArrayPool(bytePoolConfig, this.cacheName);
        PrimitiveArrayPool.PoolConfig longPoolConfig = new PrimitiveArrayPool.PoolConfig();
        longPoolConfig.type = 2;
        longPoolConfig.numberOfPools = 20;
        longPoolConfig.poolSize = 2;
        longPoolConfig.poolEntryLife = 300000;
        longPoolConfig.scanFrequency = 60000;
        this.longArrayPool = new PrimitiveArrayPool(longPoolConfig, this.cacheName);
        this.htEntryPool = new HashtableEntryObjectPool(200);
        this.resultPool = new ResultObjectPool(10);
        this.minDiskCacheSizeInBytes = this.calculateMinCacheSizeInBytes();
        this.rand = new Random(System.currentTimeMillis());
    }

    public HTODDynacache(String dirname, String filename, DCache cache, CacheOnDisk cod) throws IOException, ClassNotFoundException, FileManagerException {
        this.dirname = dirname;
        this.filename = filename;
        this.cache = cache;
        this.cod = cod;
        this.cacheName = cache.getCacheName();
        this.delayOffload = cod.delayOffload;
        this.disableDependencyId = cod.disableDependencyId;
        this.disableTemplatesSupport = cod.disableTemplatesSupport;
        PrimitiveArrayPool.PoolConfig bytePoolConfig = new PrimitiveArrayPool.PoolConfig();
        bytePoolConfig.type = 1;
        bytePoolConfig.numberOfPools = cod.numberOfPools;
        bytePoolConfig.poolSize = cod.poolSize;
        bytePoolConfig.poolEntryLife = cod.poolEntryLife;
        bytePoolConfig.scanFrequency = 60000;
        this.byteArrayPool = new PrimitiveArrayPool(bytePoolConfig, this.cacheName);
        PrimitiveArrayPool.PoolConfig longPoolConfig = new PrimitiveArrayPool.PoolConfig();
        longPoolConfig.type = 2;
        longPoolConfig.numberOfPools = cod.numberOfPools;
        longPoolConfig.poolSize = cod.poolSize;
        longPoolConfig.poolEntryLife = cod.poolEntryLife;
        longPoolConfig.scanFrequency = 60000;
        this.longArrayPool = new PrimitiveArrayPool(longPoolConfig, this.cacheName);
        this.htEntryPool = new HashtableEntryObjectPool(200);
        this.invalidationBuffer = new HTODInvalidationBuffer(this.cod);
        this.init_files();
        if (this.delayOffload) {
            if (!this.disableDependencyId) {
                this.auxDataDependencyTable = new HTODDependencyTable(1, 1000, cod.delayOffloadDepIdBuckets, 2, cod.delayOffloadEntriesLimit, cod.dependencyCacheIndexEnabled, this);
            }
            if (!this.disableTemplatesSupport) {
                this.auxTemplateDependencyTable = new HTODDependencyTable(2, 100, cod.delayOffloadTemplateBuckets, 2, cod.delayOffloadEntriesLimit, cod.dependencyCacheIndexEnabled, this);
            }
        }
        this.minDiskCacheSizeInBytes = this.calculateMinCacheSizeInBytes();
        ValueSet valueSet = this.cod.readAndDeleteInvalidationFile();
        if (valueSet != null && valueSet.size() > 0) {
            this.invalidationBuffer.add(valueSet, 2, 1, 5, false, true, false);
            this.cod.startState = 2;
            valueSet.clear();
            valueSet = null;
        }
        if (this.cod.currentCacheSizeInBytes == 0L && this.getCacheIdsSize() == 0) {
            this.cod.currentCacheSizeInBytes = this.minDiskCacheSizeInBytes;
        }
        this.resultPool = new ResultObjectPool(10);
        this.rand = new Random(System.currentTimeMillis());
        this.totalDeleted = 0L;
        this.totalDeletedSize = 0L;
    }

    protected void init_files() throws IOException, ClassNotFoundException, FileManagerException {
        this.initFileManager();
        this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L, true, this);
        if (this.object_cache == null) {
            HashtableOnDisk.createInstance(this.object_filemgr, this.cod.dataHashtableSize, this.hashtable_threshold);
            this.cod.dataGB = 1;
            this.cod.dataFiles = 1;
            this.object_cache = HashtableOnDisk.getInstance(this.object_filemgr, this.auto_rehash, 0L, true, this);
        }
        if (!this.disableDependencyId) {
            this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L, false, this);
            if (this.dependency_cache == null) {
                HashtableOnDisk.createInstance(this.dependency_filemgr, this.cod.depIdHashtableSize, this.hashtable_threshold);
                this.cod.dependencyIdGB = 1;
                this.cod.dependencyIdFiles = 1;
                this.dependency_cache = HashtableOnDisk.getInstance(this.dependency_filemgr, this.auto_rehash, 0L, false, this);
            }
        } else {
            this.cod.dependencyIdGB = 0;
            this.cod.dependencyIdFiles = 0;
        }
        if (!this.disableTemplatesSupport) {
            this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L, false, this);
            if (this.template_cache == null) {
                HashtableOnDisk.createInstance(this.template_filemgr, this.cod.templateHashtableSize, this.hashtable_threshold);
                this.cod.templateGB = 1;
                this.cod.templateFiles = 1;
                this.template_cache = HashtableOnDisk.getInstance(this.template_filemgr, this.auto_rehash, 0L, false, this);
            }
        } else {
            this.cod.templateGB = 0;
            this.cod.templateFiles = 0;
        }
    }

    void initFileManager() throws IOException, FileManagerException {
        String methodName = "initFileManager()";
        this.object_filemgr = new FileManagerImpl(this.filename + object_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
        if (!this.disableDependencyId) {
            this.dependency_filemgr = new FileManagerImpl(this.filename + dependency_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
        }
        if (!this.disableTemplatesSupport) {
            this.template_filemgr = new FileManagerImpl(this.filename + template_suffix + ".htod", false, "rw", this.physical_disk_manager, this);
        }
    }

    public void initializeEvictionTable() {
        this.evictionEntryPool = new EvictionEntryPool(500);
        this.EvictionTable = new BinaryHeap(new EvictionTableEntry());
    }

    public void close() {
        try {
            this.rwLock.writeLock().lock();
            this.closeNoRWLock();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (this.deleteDiskFiles) {
            this.deleteDiskCacheFiles();
            this.deleteDiskFiles = false;
        }
    }

    private void closeNoRWLock() {
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            String methodName = "closeNoRWLock()";
                            this.cod.diskCacheSizeInfo.allowOverflow = true;
                            try {
                                this.object_cache.close();
                            }
                            catch (Exception ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.HTODDynacache.closeNoRWLock", (String)"309", (Object)this);
                                if (!this.tc.isDebugEnabled()) break block20;
                                Tr.debug((TraceComponent)this.tc, (String)"closeNoRWLock()", (Object[])new Object[]{"this.cacheName=" + this.cacheName + "\n Exception: " + ExceptionUtility.getStackTrace(ex)});
                            }
                        }
                        try {
                            if (!this.disableDependencyId) {
                                this.dependency_cache.close();
                            }
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.HTODDynacache.closeNoRWLock", (String)"315", (Object)this);
                            if (!this.tc.isDebugEnabled()) break block21;
                            Tr.debug((TraceComponent)this.tc, (String)"closeNoRWLock()", (Object[])new Object[]{"cacheName=" + this.cacheName + "\n Exception: " + ExceptionUtility.getStackTrace(ex)});
                        }
                    }
                    try {
                        if (!this.disableTemplatesSupport) {
                            this.template_cache.close();
                        }
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.HTODDynacache.closeNoRWLock", (String)"321", (Object)this);
                        if (!this.tc.isDebugEnabled()) break block22;
                        Tr.debug((TraceComponent)this.tc, (String)"closeNoRWLock()", (Object[])new Object[]{"cacheName=" + this.cacheName + "\n Exception: " + ExceptionUtility.getStackTrace(ex)});
                    }
                }
                try {
                    this.object_filemgr.close();
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.HTODDynacache.closeNoRWLock", (String)"327", (Object)this);
                    if (!this.tc.isDebugEnabled()) break block23;
                    Tr.debug((TraceComponent)this.tc, (String)"closeNoRWLock()", (Object[])new Object[]{"cacheName=" + this.cacheName + "\n Exception: " + ExceptionUtility.getStackTrace(ex)});
                }
            }
            try {
                if (!this.disableDependencyId) {
                    this.dependency_filemgr.close();
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.HTODDynacache.closeNoRWLock", (String)"333", (Object)this);
                if (!this.tc.isDebugEnabled()) break block24;
                Tr.debug((TraceComponent)this.tc, (String)"closeNoRWLock()", (Object[])new Object[]{"cacheName=" + this.cacheName + "\n Exception: " + ExceptionUtility.getStackTrace(ex)});
            }
        }
        try {
            if (!this.disableTemplatesSupport) {
                this.template_filemgr.close();
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.HTODDynacache.closeNoRWLock", (String)"339", (Object)this);
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"closeNoRWLock()", (Object[])new Object[]{"cacheName=" + this.cacheName + "\n Exception: " + ExceptionUtility.getStackTrace(ex)});
            }
        }
        finally {
            this.cod.diskCacheSizeInfo.allowOverflow = false;
        }
    }

    public int writeAuxiliaryDepTables() {
        String methodName = "writeAuxiliaryDepTables()";
        this.numDepIdsInAuxTable = 0;
        this.numTemplatesInAuxTable = 0;
        this.numCacheIdsInDepIdAuxTable = 0;
        this.numCacheIdsInTemplateAuxTable = 0;
        this.numExplicitBufferLimitOnStop = 0;
        int returnCode = 0;
        if (this.cod.valueSet == null) {
            this.cod.valueSet = new ValueSet(16);
        }
        if (this.delayOffload) {
            int size;
            ValueSet valueSet;
            Enumeration e;
            long start = System.nanoTime();
            if (!this.disableDependencyId && !this.auxDataDependencyTable.isEmpty()) {
                e = this.auxDataDependencyTable.getKeys();
                while (e.hasMoreElements()) {
                    Object id = e.nextElement();
                    if (!this.auxDataDependencyTable.isUpdated(id)) continue;
                    valueSet = this.auxDataDependencyTable.getEntries(id);
                    if (valueSet != null && valueSet.size() > 0) {
                        this.numCacheIdsInDepIdAuxTable += valueSet.size();
                    }
                    returnCode = this.writeValueSet(2, id, valueSet, true);
                    this.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(id);
                    if (returnCode == 1) {
                        return returnCode;
                    }
                    if (returnCode == 2) {
                        size = valueSet.size();
                        if (this.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)this.tc, (String)"writeAuxiliaryDepTables()", (Object[])new Object[]{"cacheName=" + this.cacheName + " depid=" + id + " disk overflow size=" + size});
                        }
                        if (size > 0) {
                            this.cod.valueSet.union(valueSet);
                        }
                    }
                    ++this.numDepIdsInAuxTable;
                }
                this.auxDataDependencyTable.clear();
            }
            if (!this.disableTemplatesSupport && !this.auxTemplateDependencyTable.isEmpty()) {
                e = this.auxTemplateDependencyTable.getKeys();
                while (e.hasMoreElements()) {
                    Object template = e.nextElement();
                    if (!this.auxTemplateDependencyTable.isUpdated(template)) continue;
                    valueSet = this.auxTemplateDependencyTable.getEntries(template);
                    if (valueSet != null && valueSet.size() > 0) {
                        this.numCacheIdsInTemplateAuxTable += valueSet.size();
                    }
                    returnCode = this.writeValueSet(3, template, valueSet, true);
                    this.cache.getCacheStatisticsListener().templatesOffloadedToDisk(template);
                    if (returnCode == 1) {
                        return returnCode;
                    }
                    if (returnCode == 2) {
                        size = valueSet.size();
                        if (this.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)this.tc, (String)"writeAuxiliaryDepTables()", (Object[])new Object[]{"cacheName=" + this.cacheName + " template=" + template + " disk overflow size=" + size});
                        }
                        if (size > 0) {
                            this.cod.valueSet.union(valueSet);
                        }
                    }
                    ++this.numTemplatesInAuxTable;
                }
                this.auxTemplateDependencyTable.clear();
            }
            this.timeElapsedWriteAuxTables = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            if (this.cod.valueSet != null && this.cod.valueSet.size() > 0) {
                this.numExplicitBufferLimitOnStop = this.cod.valueSet.size();
                if (this.cod.explicitBufferLimitOnStop > 0 && this.cod.valueSet.size() > this.cod.explicitBufferLimitOnStop) {
                    this.deleteDiskFiles = true;
                } else {
                    this.cod.createInvalidationFile();
                }
                this.cod.valueSet.clear();
                this.cod.valueSet = null;
            }
        }
        return returnCode;
    }

    public void dump_object_statistics() {
        block4: {
            String methodName = "dump_object_statistics()";
            try {
                OutputStreamWriter out = new OutputStreamWriter(System.out);
                out.write("========================================================================");
                out.write("------------------ Object File Manager Statistics ---------------\n");
                this.object_filemgr.dump_stats(out, true);
                out.write("------------------ Object HTOD Statistics ---------------\n");
                this.object_cache.dump_htod_stats(out, true);
                out.write("========================================================================");
                if (!this.disableDependencyId) {
                    out.write("========================================================================");
                    out.write("------------------ Dependency File Manager Statistics ---------------\n");
                    this.dependency_filemgr.dump_stats(out, true);
                    out.write("------------------ Dependency HTOD Statistics ---------------\n");
                    this.dependency_cache.dump_htod_stats(out, true);
                    out.write("========================================================================");
                }
                if (!this.disableTemplatesSupport) {
                    out.write("========================================================================");
                    out.write("------------------ Template File Manager Statistics ---------------\n");
                    this.template_filemgr.dump_stats(out, true);
                    out.write("------------------ Template HTOD Statistics ---------------\n");
                    this.template_cache.dump_htod_stats(out, true);
                    out.write("========================================================================");
                }
                out.flush();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.HTODDynacache.dump_object_statistics", (String)"376", (Object)this);
                if (!this.tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)this.tc, (String)"dump_object_statistics()", (Object[])new Object[]{"cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t)});
            }
        }
    }

    /*
     * Exception decompiling
     */
    public int clearDiskCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop(boolean completeClear) {
        String methodName = "stop()";
        if (this.invalidationBuffer.isBackgroundInvalidationInProgress()) {
            this.invalidationBuffer.setLoopOnce(true);
            if (this.invalidationBuffer.isCleanupPending()) {
                this.invalidationBuffer.resetCleanupPending();
            }
            this.cod.waitForCleanupComplete();
            this.invalidationBuffer.setLoopOnce(false);
        }
        if (completeClear) {
            this.invalidationBuffer.clear(2);
            this.invalidationBuffer.clear(1);
            this.invalidationBuffer.clear(3);
        } else {
            this.invalidationBuffer.clear(1);
            this.invalidationBuffer.clear(3);
            this.cod.valueSet = this.invalidationBuffer.getAndRemoveFromExplicitBuffer();
            if (this.cod.valueSet != null && this.cod.valueSet.size() > 0 && this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"stop()", (Object[])new Object[]{"cacheName=" + this.cacheName + " offload explicit buffer size=" + this.cod.valueSet.size()});
            }
        }
    }

    public void deleteDiskCacheFiles() {
        this.cod.deleteDiskCacheFiles();
    }

    public void delCacheEntry(CacheEntry ce, int cause, int source, boolean fromDepIdTemplateInvalidation) {
        this.invalidationBuffer.add(ce.id, 2, cause, source, fromDepIdTemplateInvalidation, false, false);
        for (int i = 0; i < ce.aliasList.length; ++i) {
            this.invalidationBuffer.add(ce.aliasList[i], 2, cause, source, fromDepIdTemplateInvalidation, false, true);
        }
    }

    public void delCacheEntry(ValueSet deleteList, int cause, int source, boolean fromDepIdTemplateInvalidation, boolean fireEvent) {
        if (deleteList != null && deleteList.size() > 0) {
            this.invalidationBuffer.add(deleteList, 2, cause, source, fromDepIdTemplateInvalidation, fireEvent, true);
        }
    }

    /*
     * Exception decompiling
     */
    private Result delCacheEntry(Object id, int bufferType, boolean explicitBufferFirst) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int delDependency(Object id) {
        int returnCode = 0;
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                this.auxDataDependencyTable.removeDependency(id);
            }
            returnCode = this.delValueSet(2, id);
        }
        return returnCode;
    }

    public int delTemplate(String template) {
        int returnCode = 0;
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                this.auxTemplateDependencyTable.removeDependency(template);
            }
            returnCode = this.delValueSet(3, template);
        }
        return returnCode;
    }

    public int delDependencyEntry(Object id, Object entry) {
        int returnCode = 0;
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                Result result = this.auxDataDependencyTable.removeEntry(id, entry);
                returnCode = result.returnCode;
                if (!result.bExist && returnCode != 1) {
                    returnCode = this.delValueSetEntry(2, id, entry);
                }
            } else {
                returnCode = this.delValueSetEntry(2, id, entry);
            }
        }
        return returnCode;
    }

    public int delTemplateEntry(String template, Object entry) {
        int returnCode = 0;
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                Result result = this.auxTemplateDependencyTable.removeEntry(template, entry);
                returnCode = result.returnCode;
                if (!result.bExist && returnCode != 1) {
                    returnCode = this.delValueSetEntry(3, template, entry);
                }
            } else {
                returnCode = this.delValueSetEntry(3, template, entry);
            }
        }
        return returnCode;
    }

    public Result readCacheEntry(Object id) {
        return this.readCacheEntry(id, false);
    }

    /*
     * Exception decompiling
     */
    public Result readCacheEntry(Object id, boolean calledFromRemove) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Result readDependency(Object id, boolean delete) {
        Result result = this.getFromResultPool();
        ValueSet vs = null;
        if (id == null) {
            return result;
        }
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                vs = this.auxDataDependencyTable.getEntries(id);
                if (vs == null) {
                    Result other = this.readValueSet(2, id, delete);
                    result.copy(other);
                    this.returnToResultPool(other);
                    if (result.returnCode != 1 && (vs = (ValueSet)result.data) != null && !delete && vs.size() <= this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                        result.returnCode = this.auxDataDependencyTable.add(id, vs);
                    }
                } else if (delete) {
                    this.auxDataDependencyTable.removeDependency(id);
                    result.returnCode = this.delValueSet(2, id);
                }
            } else {
                Result other = this.readValueSet(2, id, delete);
                result.copy(other);
                this.returnToResultPool(other);
                vs = (ValueSet)result.data;
            }
            if (result.returnCode != 1 && vs != null) {
                this.invalidationBuffer.filter(vs);
            }
            result.data = vs;
        }
        return result;
    }

    public Result readTemplate(String template, boolean delete) {
        Result result = this.getFromResultPool();
        ValueSet vs = null;
        if (template == null) {
            return result;
        }
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                vs = this.auxTemplateDependencyTable.getEntries(template);
                if (vs == null) {
                    Result other = this.readValueSet(3, template, delete);
                    result.copy(other);
                    this.returnToResultPool(other);
                    if (result.returnCode != 1 && (vs = (ValueSet)result.data) != null && !delete && vs.size() <= this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                        result.returnCode = this.auxTemplateDependencyTable.add((Object)template, vs);
                    }
                } else if (delete) {
                    this.auxTemplateDependencyTable.removeDependency(template);
                    result.returnCode = this.delValueSet(3, template);
                }
            } else {
                Result other = this.readValueSet(3, template, delete);
                result.copy(other);
                this.returnToResultPool(other);
                vs = (ValueSet)result.data;
            }
            if (result.returnCode != 1 && vs != null) {
                this.invalidationBuffer.filter(vs);
            }
            result.data = vs;
        }
        return result;
    }

    public Result readCacheIdsByRange(int index, int length) {
        Result result = this.readByRange(1, index, length, true, true);
        return result;
    }

    public Result readDependencyByRange(int index, int length) {
        Result result = this.getFromResultPool();
        if (!this.disableDependencyId) {
            Result other = this.readByRange(2, index, length, false, false);
            result.copy(other);
            this.returnToResultPool(other);
        }
        return result;
    }

    public Result readTemplatesByRange(int index, int length) {
        Result result = this.getFromResultPool();
        if (!this.disableDependencyId) {
            Result other = this.readByRange(3, index, length, false, false);
            result.copy(other);
            this.returnToResultPool(other);
        }
        return result;
    }

    public int getCacheIdsSize(boolean filter) {
        return this.getCacheIdsSize();
    }

    public int getCacheIdsSize() {
        try {
            this.rwLock.readLock().lock();
            int length = this.object_cache.size();
            if (length < 0) {
                int n = 0;
                return n;
            }
            int n = length;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int getDepIdsSize() {
        int length = 0;
        if (!this.disableDependencyId) {
            try {
                this.rwLock.readLock().lock();
                length = this.dependency_cache.size();
            }
            finally {
                this.rwLock.readLock().unlock();
            }
            if (length < 0) {
                length = 0;
            }
        }
        return length;
    }

    public int getTemplatesSize() {
        int length = 0;
        if (!this.disableTemplatesSupport) {
            try {
                this.rwLock.readLock().lock();
                length = this.template_cache.size();
            }
            finally {
                this.rwLock.readLock().unlock();
            }
            if (length < 0) {
                length = 0;
            }
        }
        return length;
    }

    /*
     * Exception decompiling
     */
    public int writeCacheEntry(CacheEntry ce) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int updateExpirationTime(Object id, long oldExpirationTime, int size, long newExpirationTime, long newValidatorExpirationTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int writeDependency(Object id, ValueSet valueSet) {
        String methodName = "writeDependency()";
        int rc = 0;
        if (valueSet.size() == 0 && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"writeDependency()", (Object[])new Object[]{"cacheName=" + this.cacheName + " valueSet=0"});
        }
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                ValueSet vs = this.auxDataDependencyTable.getEntries(id);
                if (vs == null) {
                    if (valueSet.size() <= this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                        Result result = this.writeValueSetEntry(2, id, null, valueSet, false);
                        rc = result.returnCode;
                        boolean bComplete = result.bComplete;
                        this.returnToResultPool(result);
                        if (rc != 1 && !bComplete) {
                            rc = this.auxDataDependencyTable.add(id, valueSet);
                        }
                    } else {
                        rc = this.writeValueSet(2, id, valueSet, false);
                        this.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(id);
                    }
                } else {
                    vs.union(valueSet);
                    if (vs.size() > this.auxDataDependencyTable.delayOffloadEntriesLimit) {
                        this.auxDataDependencyTable.removeDependency(id);
                        rc = this.writeValueSet(2, id, vs, true);
                        if (rc != 0) {
                            valueSet.clear();
                            valueSet.addAll(vs);
                        }
                        this.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(id);
                    }
                }
            } else {
                rc = this.writeValueSet(2, id, valueSet, false);
            }
        }
        return rc;
    }

    public int writeDependencyEntry(Object id, Object entry) {
        int rc = 0;
        if (!this.disableDependencyId) {
            if (this.delayOffload) {
                ValueSet vs = this.auxDataDependencyTable.getEntries(id);
                if (vs == null) {
                    Result result = this.writeValueSetEntry(2, id, entry, null, false);
                    rc = result.returnCode;
                    boolean bExist = result.bExist;
                    this.returnToResultPool(result);
                    if (rc != 1 && rc != 2 && !bExist) {
                        rc = this.auxDataDependencyTable.add(id, entry);
                    }
                } else {
                    rc = this.auxDataDependencyTable.add(id, vs, entry);
                }
            } else {
                Result result = this.writeValueSetEntry(2, id, entry, null, true);
                rc = result.returnCode;
                this.returnToResultPool(result);
            }
        }
        return rc;
    }

    public int writeTemplate(String template, ValueSet valueSet) {
        String methodName = "writeTemplate()";
        int rc = 0;
        if (valueSet.size() == 0 && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"writeTemplate()", (Object[])new Object[]{"cacheName=" + this.cacheName + " valueSet=0"});
        }
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                ValueSet vs = this.auxTemplateDependencyTable.getEntries(template);
                if (vs == null) {
                    if (valueSet.size() <= this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                        Result result = this.writeValueSetEntry(3, template, null, valueSet, false);
                        rc = result.returnCode;
                        boolean bComplete = result.bComplete;
                        this.returnToResultPool(result);
                        if (rc != 1 && !bComplete) {
                            rc = this.auxTemplateDependencyTable.add((Object)template, valueSet);
                        }
                    } else {
                        rc = this.writeValueSet(3, template, valueSet, false);
                        this.cache.getCacheStatisticsListener().templatesOffloadedToDisk(template);
                    }
                } else {
                    vs.union(valueSet);
                    if (vs.size() > this.auxTemplateDependencyTable.delayOffloadEntriesLimit) {
                        this.auxTemplateDependencyTable.removeDependency(template);
                        rc = this.writeValueSet(3, template, vs, true);
                        if (rc != 0) {
                            valueSet.clear();
                            valueSet.addAll(vs);
                        }
                        this.cache.getCacheStatisticsListener().templatesOffloadedToDisk(template);
                    }
                }
            } else {
                rc = this.writeValueSet(3, template, valueSet, false);
            }
        }
        return rc;
    }

    public int writeTemplateEntry(String template, Object entry) {
        int rc = 0;
        if (!this.disableTemplatesSupport) {
            if (this.delayOffload) {
                ValueSet vs = this.auxTemplateDependencyTable.getEntries(template);
                if (vs == null) {
                    Result result = this.writeValueSetEntry(3, template, entry, null, false);
                    rc = result.returnCode;
                    boolean bExist = result.bExist;
                    this.returnToResultPool(result);
                    if (rc != 1 && rc != 2 && !bExist) {
                        rc = this.auxTemplateDependencyTable.add((Object)template, entry);
                    }
                } else {
                    rc = this.auxTemplateDependencyTable.add(template, vs, entry);
                }
            } else {
                Result result = this.writeValueSetEntry(3, template, entry, null, true);
                rc = result.returnCode;
                this.returnToResultPool(result);
            }
        }
        return rc;
    }

    /*
     * Exception decompiling
     */
    Result readValueSet(int type, Object id, boolean delete) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    Result readValueSetSize(int type, Object id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Result readByRange(int type, int index, int length, boolean checkExpired, boolean filter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected Result readExpiredByRange(ValueSet expiredIds, int index, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Result readHashcodeByRange(int index, int length, boolean debug, boolean useValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    int writeValueSet(int type, Object id, ValueSet vs, boolean all) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    int delValueSet(int type, Object id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    int delValueSetEntry(int type, Object id, Object entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    Result writeValueSetEntry(int type, Object id, Object entry, ValueSet valueSet, boolean addIfNew) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getNumObjects() {
        try {
            this.rwLock.readLock().lock();
            int answer = Math.max(this.object_cache.size(), 0);
            if (!this.disableDependencyId) {
                answer += Math.max(this.dependency_cache.size(), 0);
            }
            if (!this.disableTemplatesSupport) {
                answer += Math.max(this.template_cache.size(), 0);
            }
            int n = answer;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public String cacheType() {
        return "htod";
    }

    public void dump_htod_stats(Writer out, boolean labels) {
        try {
            this.object_cache.dump_htod_stats(out, labels);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.HTODDynacache.dump_htod_stats", (String)"2646", (Object)this);
        }
    }

    public void dump_filemgr_stats(Writer out, boolean labels) {
        try {
            this.object_cache.dump_filemgr_stats(out, labels);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.HTODDynacache.dump_filemgr_stats", (String)"2655", (Object)this);
        }
    }

    public void dump_stats_header(Writer out) {
        try {
            this.object_cache.dump_stats_header(out);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.HTODDynacache.dump_stats_header", (String)"2664", (Object)this);
        }
    }

    public void dump_filemgr_header(Writer out) {
        try {
            this.object_cache.dump_filemgr_header(out);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.HTODDynacache.dump_filemgr_header", (String)"2673", (Object)this);
        }
    }

    public void reset_stats() {
        this.object_cache.reset_stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object id) {
        String methodName = "containsKey()";
        boolean found = false;
        if (!this.invalidationBuffer.contains(id)) {
            try {
                this.rwLock.readLock().lock();
                found = this.object_cache.containsKey(id);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.HTODDynacache.containsKey", (String)"1877", (Object)this);
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)"containsKey()", (Object[])new Object[]{"cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(t)});
                }
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
        return found;
    }

    private int populateAuxDependencyTable(int type, HashMap cacheIdsTable, int vlimit, int hlimit) {
        String methodName = "populateAuxDependencyTable()";
        int returnCode = 0;
        HTODDependencyTable depTable = null;
        int size = 0;
        if (type == 2) {
            depTable = this.auxDataDependencyTable;
            size = this.getDepIdsSize();
        } else {
            depTable = this.auxTemplateDependencyTable;
            size = this.getTemplatesSize();
        }
        if (size == 0) {
            return returnCode;
        }
        Result result = this.readByRange(type, 0, -1, false, false);
        returnCode = result.returnCode;
        if (returnCode == 1) {
            this.returnToResultPool(result);
            return returnCode;
        }
        ValueSet valueSet = (ValueSet)result.data;
        this.returnToResultPool(result);
        if (valueSet == null || valueSet.isEmpty()) {
            return returnCode;
        }
        Iterator it = null;
        Iterator it2 = null;
        if (this.cod.diskCachePerformanceLevel == 2 || this.cod.diskCachePerformanceLevel == 1) {
            int i;
            ArrayList<DepEntry> depSizes = new ArrayList<DepEntry>(vlimit);
            int index = 0;
            for (Object did : valueSet) {
                result = this.readValueSetSize(type, did);
                if (returnCode == 1) {
                    this.returnToResultPool(result);
                    return returnCode;
                }
                int csize = result.dataSize;
                if (csize > hlimit) continue;
                DepEntry de = new DepEntry(did, csize);
                depSizes.add(index, de);
                ++index;
            }
            depSizes.trimToSize();
            if (depSizes.size() > vlimit) {
                int dsize = depSizes.size() - vlimit;
                Collections.sort(depSizes, new DepSizeComparator());
                for (i = 0; i < dsize; ++i) {
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)"populateAuxDependencyTable()", (Object[])new Object[]{" remove id=" + ((DepEntry)depSizes.get((int)0)).id});
                    }
                    depSizes.remove(0);
                }
            }
            int dsize = depSizes.size();
            valueSet.clear();
            for (i = 0; i < dsize; ++i) {
                valueSet.add(((DepEntry)depSizes.get((int)i)).id);
            }
        }
        for (Object did : valueSet) {
            result = this.readValueSet(type, did, false);
            if (returnCode == 1) {
                this.returnToResultPool(result);
                return returnCode;
            }
            ValueSet tempValueSet = (ValueSet)result.data;
            this.returnToResultPool(result);
            if (tempValueSet == null || tempValueSet.isEmpty()) continue;
            ValueSet idValueSet = new ValueSet(tempValueSet.size());
            for (Object cid : tempValueSet) {
                Object tid = cacheIdsTable.get(cid);
                if (tid == null) {
                    cacheIdsTable.put(cid, cid);
                    tid = cid;
                }
                idValueSet.add(tid);
            }
            depTable.add(did, idValueSet);
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"populateAuxDependencyTable()", (Object[])new Object[]{" did= " + did + " cacheIdsSize=" + idValueSet.size()});
            }
            if (returnCode != 1) continue;
            return returnCode;
        }
        return returnCode;
    }

    protected int removeExpiredCache(boolean scan) {
        int totalSize;
        String methodName = "removeExpiredCache()";
        int returnCode = 0;
        if (this.object_cache == null) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"removeExpiredCache()", (Object[])new Object[]{"The disk object cache is null for cacheName=" + this.cacheName});
            }
            return returnCode;
        }
        long start = System.nanoTime();
        long tPopulateDepTablesTime = 0L;
        long tReadRangeTime = 0L;
        long tDeleteTime = 0L;
        long tScanExpiredCount = 0L;
        long tExplicitDeleted = 0L;
        long tScanDeleted = 0L;
        long tGCDeleted = 0L;
        long tDeletedSize = 0L;
        if (!scan && (totalSize = this.invalidationBuffer.size() + this.invalidationBuffer.size(3)) == 0) {
            return returnCode;
        }
        if (this.getCacheIdsSize() > 0) {
            long t;
            StringBuffer dcmsg = new StringBuffer();
            dcmsg.append("  DiskCacheSize=");
            dcmsg.append(this.getCacheIdsSize());
            dcmsg.append("  DepIdsSize=");
            dcmsg.append(this.getDepIdsSize());
            dcmsg.append("  TemplatesSize=");
            dcmsg.append(this.getTemplatesSize());
            if (this.cod.enableCacheSizeInBytes) {
                dcmsg.append("  CacheSizeInBytes=");
                dcmsg.append(this.cod.currentCacheSizeInBytes);
            }
            dcmsg.append("  Scan=");
            dcmsg.append(scan);
            dcmsg.append("  ExplicitBuffer=");
            dcmsg.append(this.invalidationBuffer.size(2));
            dcmsg.append("  ScanBuffer=");
            dcmsg.append(this.invalidationBuffer.size(1));
            dcmsg.append("  GCBuffer=");
            dcmsg.append(this.invalidationBuffer.size(3));
            if (scan) {
                Tr.info((TraceComponent)this.tc, (String)"DYNA0057I", (Object[])new Object[]{this.cacheName, dcmsg.toString()});
            } else if (!scan && this.tc.isEventEnabled()) {
                Tr.event((TraceComponent)this.tc, (String)("The disk cache cleanup started for the cache name \"" + this.cacheName + "\".The statistics are: " + dcmsg.toString()), (Object[])new Object[0]);
            } else if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"removeExpiredCache()", (Object[])new Object[]{"The disk cache cleanup started for cache name \"" + this.cacheName + "\". The statistics are: " + dcmsg.toString()});
            }
            if (this.cod.populateDependencyTable) {
                this.cacheIdsTable = new HashMap(this.getCacheIdsSize());
                this.cod.populateDependencyTable = false;
                t = System.nanoTime();
                if (!this.disableDependencyId && (returnCode = this.populateAuxDependencyTable(2, this.cacheIdsTable, this.cod.delayOffloadDepIdBuckets, this.cod.delayOffloadEntriesLimit)) == 1) {
                    this.cacheIdsTable.clear();
                    this.cacheIdsTable = null;
                    return returnCode;
                }
                if (!this.disableTemplatesSupport && (returnCode = this.populateAuxDependencyTable(3, this.cacheIdsTable, this.cod.delayOffloadTemplateBuckets, this.cod.delayOffloadEntriesLimit)) == 1) {
                    this.cacheIdsTable.clear();
                    this.cacheIdsTable = null;
                    return returnCode;
                }
                tPopulateDepTablesTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            }
            int i = 0;
            boolean complete = false;
            ValueSet expiredIds = new ValueSet(50);
            long lastTimeToDisplay = System.nanoTime();
            boolean firstScan = true;
            do {
                int scanExpiredCount = 0;
                this.scanExpiredTime = 0L;
                if (scan && this.invalidationBuffer.size() < this.cod.invalidationBufferSize) {
                    if (this.invalidationBuffer.isLoopOnce()) break;
                    if (this.cod.evictionPolicy != 0 && this.cod.diskCachePerformanceLevel != 3 && this.EvictionTable.size() > 0) {
                        ArrayList alist = this.getExpiredEntriesFromEvictionTable();
                        tScanExpiredCount += (long)alist.size();
                        this.invalidationBuffer.add(alist, 3);
                        if (this.tc.isDebugEnabled() || this.tc.isEventEnabled()) {
                            lastTimeToDisplay = System.nanoTime();
                            dcmsg.setLength(0);
                            dcmsg.append("removeExpiredCache()");
                            dcmsg.append(":scanGC ++++ cacheName=");
                            dcmsg.append(this.cacheName);
                            dcmsg.append(" DiskCacheSize=");
                            dcmsg.append(this.getCacheIdsSize());
                            if (this.cod.enableCacheSizeInBytes) {
                                dcmsg.append("  CacheSizeInBytes=");
                                dcmsg.append(this.cod.currentCacheSizeInBytes);
                            }
                            dcmsg.append(" ScanExpiredEntries=");
                            dcmsg.append(tScanExpiredCount);
                            dcmsg.append(" ExplicitEntriesDeleted=");
                            dcmsg.append(tExplicitDeleted);
                            dcmsg.append(" ScanEntriesDeleted=");
                            dcmsg.append(tScanDeleted);
                            dcmsg.append(" GCEntriesDeleted=");
                            dcmsg.append(tGCDeleted);
                            dcmsg.append(" DeletedSize=");
                            dcmsg.append(tDeletedSize);
                            dcmsg.append(" ExplicitBuffer=");
                            dcmsg.append(this.invalidationBuffer.size(2));
                            dcmsg.append(" ScanBuffer=");
                            dcmsg.append(this.invalidationBuffer.size(1));
                            dcmsg.append(" GCBuffer=");
                            dcmsg.append(this.invalidationBuffer.size(3));
                            dcmsg.append(" CleanupScanPending=");
                            dcmsg.append(this.invalidationBuffer.isCleanupPending());
                            if (this.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)this.tc, (String)dcmsg.toString(), (Object[])new Object[0]);
                            } else {
                                Tr.event((TraceComponent)this.tc, (String)dcmsg.toString(), (Object[])new Object[0]);
                            }
                        }
                        complete = true;
                    } else {
                        if (firstScan) {
                            i = 0;
                            firstScan = false;
                        }
                        Result result = this.readExpiredByRange(expiredIds, i, 50);
                        returnCode = result.returnCode;
                        if (returnCode == 1) break;
                        complete = result.bComplete;
                        tReadRangeTime += this.scanExpiredTime;
                        scanExpiredCount = expiredIds.size();
                        if (scanExpiredCount > 0) {
                            this.invalidationBuffer.add(expiredIds, 1, 3, 5, false, true, false);
                            expiredIds.clear();
                        }
                        tScanExpiredCount += (long)scanExpiredCount;
                        if (this.tc.isEventEnabled() && System.nanoTime() - lastTimeToDisplay >= TimeUnit.SECONDS.toNanos(10L)) {
                            lastTimeToDisplay = System.nanoTime();
                            dcmsg.setLength(0);
                            dcmsg.append("removeExpiredCache()");
                            dcmsg.append(":scanDisk ++++ cacheName=");
                            dcmsg.append(this.cacheName);
                            dcmsg.append(" DiskCacheSize=");
                            dcmsg.append(this.getCacheIdsSize());
                            if (this.cod.enableCacheSizeInBytes) {
                                dcmsg.append("  CacheSizeInBytes=");
                                dcmsg.append(this.cod.currentCacheSizeInBytes);
                            }
                            dcmsg.append(" ScanExpiredEntries=");
                            dcmsg.append(tScanExpiredCount);
                            dcmsg.append(" ExplicitEntriesDeleted=");
                            dcmsg.append(tExplicitDeleted);
                            dcmsg.append(" ScanEntriesDeleted=");
                            dcmsg.append(tScanDeleted);
                            dcmsg.append(" GCEntriesDeleted=");
                            dcmsg.append(tGCDeleted);
                            dcmsg.append(" DeletedSize=");
                            dcmsg.append(tDeletedSize);
                            dcmsg.append(" ExplicitBuffer=");
                            dcmsg.append(this.invalidationBuffer.size(2));
                            dcmsg.append(" ScanBuffer=");
                            dcmsg.append(this.invalidationBuffer.size(1));
                            dcmsg.append(" GCBuffer=");
                            dcmsg.append(this.invalidationBuffer.size(3));
                            dcmsg.append(" CleanupScanPending=");
                            dcmsg.append(this.invalidationBuffer.isCleanupPending());
                            Tr.event((TraceComponent)this.tc, (String)dcmsg.toString(), (Object[])new Object[0]);
                        }
                        if (this.getDiskCacheSizeInfo().doYield(this.getCacheIdsSize(), this.cod.currentCacheSizeInBytes)) {
                            Thread.yield();
                        }
                    }
                } else if (!scan) {
                    complete = true;
                }
                if (this.invalidationBuffer.isLoopOnce()) break;
                t = System.nanoTime();
                Result res = this.deleteEntriesFromInvalidationBuffer(true);
                tDeleteTime += System.nanoTime() - t;
                returnCode = res.returnCode;
                tExplicitDeleted += res.numExplicitDeleted;
                tScanDeleted += res.numScanDeleted;
                tGCDeleted += res.numGCDeleted;
                tDeletedSize += res.deletedSize;
                this.returnToResultPool(res);
            } while (returnCode != 1 && !complete && returnCode != 1 && !this.invalidationBuffer.isLoopOnce() && ++i > 0);
            this.totalDeleted += tExplicitDeleted + tScanDeleted + tGCDeleted;
            this.totalDeletedSize += tDeletedSize;
            dcmsg.setLength(0);
            dcmsg.append("  DiskCacheSize=");
            dcmsg.append(this.getCacheIdsSize());
            dcmsg.append("  DepIdsSize=");
            dcmsg.append(this.getDepIdsSize());
            dcmsg.append("  TemplatesSize=");
            dcmsg.append(this.getTemplatesSize());
            if (this.cod.enableCacheSizeInBytes) {
                dcmsg.append("  CacheSizeInBytes=");
                dcmsg.append(this.cod.currentCacheSizeInBytes);
            }
            dcmsg.append("  TimeElapsed=");
            dcmsg.append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            if (tPopulateDepTablesTime != 0L) {
                dcmsg.append("  PopulateDepTablesTime=");
                dcmsg.append(tPopulateDepTablesTime);
            }
            dcmsg.append("  ScanTime=");
            dcmsg.append(tReadRangeTime);
            dcmsg.append(" ScanExpiredEntries=");
            dcmsg.append(tScanExpiredCount);
            dcmsg.append("  DeleteTime=");
            dcmsg.append(TimeUnit.NANOSECONDS.toMillis(tDeleteTime));
            dcmsg.append("  ExplicitEntriesDeleted=");
            dcmsg.append(tExplicitDeleted);
            dcmsg.append("  ScanEntriesDeleted=");
            dcmsg.append(tScanDeleted);
            dcmsg.append("  GCEntriesDeleted=");
            dcmsg.append(tGCDeleted);
            dcmsg.append("  DeletedSize=");
            dcmsg.append(tDeletedSize);
            dcmsg.append("  totalDeleted=");
            dcmsg.append(this.totalDeleted);
            dcmsg.append("  totalDeletedSize=");
            dcmsg.append(this.totalDeletedSize);
            if (scan) {
                Tr.info((TraceComponent)this.tc, (String)"DYNA0058I", (Object[])new Object[]{this.cacheName, dcmsg.toString()});
            } else if (!scan && this.tc.isEventEnabled()) {
                Tr.event((TraceComponent)this.tc, (String)("The disk cache cleanup finished for cache name \"" + this.cacheName + "\". The statistics are: " + dcmsg.toString()), (Object[])new Object[0]);
            } else if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"removeExpiredCache()", (Object[])new Object[]{"The disk cache cleanup finished for cache name \"" + this.cacheName + "\". The statistics are: " + dcmsg.toString()});
            }
            this.getDiskCacheSizeInfo().displayDiskCacheInfo();
        }
        this.invalidationBuffer.setlastRemoveTime();
        this.cod.populateDependencyTable = false;
        if (this.cacheIdsTable != null) {
            this.cacheIdsTable.clear();
            this.cacheIdsTable = null;
        }
        return returnCode;
    }

    protected Result deleteEntriesFromInvalidationBuffer(boolean explicitBufferFirst) {
        String methodName = "deleteEntriesFromInvalidationBuffer()";
        Result result = this.getFromResultPool();
        result.returnCode = 0;
        if (this.object_cache == null) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"deleteEntriesFromInvalidationBuffer()", (Object[])new Object[]{"The disk object cache is null for cacheName=" + this.cacheName});
            }
            return result;
        }
        Object id = null;
        while (!this.invalidationBuffer.isLoopOnce()) {
            int bufferType;
            if (explicitBufferFirst) {
                id = this.invalidationBuffer.getAndRemove(2);
                bufferType = 2;
                if (id == null) {
                    id = this.invalidationBuffer.getAndRemove(1);
                    bufferType = 1;
                    if (id == null) {
                        id = this.invalidationBuffer.getAndRemove(3);
                        bufferType = 3;
                    }
                }
            } else {
                id = this.invalidationBuffer.getAndRemove(3);
                bufferType = 3;
                if (id == null) {
                    id = this.invalidationBuffer.getAndRemove(1);
                    bufferType = 1;
                    if (id == null) {
                        id = this.invalidationBuffer.getAndRemove(2);
                        bufferType = 2;
                    }
                }
            }
            if (id != null) {
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)"deleteEntriesFromInvalidationBuffer()", (Object[])new Object[]{"Get id for deletion: cacheName=" + this.cacheName + " id=" + id + " explicitBufferFirst=" + explicitBufferFirst});
                }
                Result res = this.delCacheEntry(id, bufferType, explicitBufferFirst);
                result.returnCode = res.returnCode;
                if (result.returnCode == 1) break;
                if (res.numDelete > 0) {
                    id = res.data;
                    result.deletedSize += res.deletedSize;
                    if (bufferType == 2) {
                        result.numExplicitDeleted += (long)res.numDelete;
                    } else if (bufferType == 1) {
                        result.numScanDeleted += (long)res.numDelete;
                        this.cache.internalInvalidateByDepId(id, res.cause, res.source, true);
                    } else {
                        result.numGCDeleted += (long)res.numDelete;
                        this.cache.internalInvalidateByDepId(id, res.cause, res.source, true);
                    }
                }
                this.returnToResultPool(res);
            }
            if (this.getDiskCacheSizeInfo().doYield(this.getCacheIdsSize(), this.cod.currentCacheSizeInBytes)) {
                Thread.yield();
            }
            if (id != null) continue;
        }
        return result;
    }

    private int calculateTableSize(Object id, int size) {
        String methodName = "calculateTableSize()";
        int tableSize = this.initial_valueset_size;
        boolean finish = false;
        do {
            if (size > tableSize) {
                tableSize = tableSize * 2 + 1;
                continue;
            }
            float ratio = (float)tableSize / (float)size;
            if ((double)ratio < 1.5) {
                tableSize = tableSize * 2 + 1;
            }
            finish = true;
        } while (!finish);
        if (this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"calculateTableSize()", (Object[])new Object[]{"cacheName=" + this.cacheName + " id=" + id + " size=" + size + " tableSize=" + tableSize});
        }
        return tableSize;
    }

    protected int calculateMinCacheSizeInBytes() {
        return this.cod.dataHashtableSize * 8 + 16900;
    }

    public DiskCacheSizeInfo getDiskCacheSizeInfo() {
        return this.cod.diskCacheSizeInfo;
    }

    public void returnToHashtableEntryPool(HashtableEntry htEntry) {
        if (htEntry != null) {
            htEntry.reset();
            this.htEntryPool.add(htEntry);
        }
    }

    public HashtableEntry getFromHashtableEntryPool() {
        return (HashtableEntry)this.htEntryPool.remove();
    }

    public void returnToResultPool(Result result) {
        if (result != null) {
            result.reset();
            this.resultPool.add(result);
        }
    }

    public Result getFromResultPool() {
        return (Result)this.resultPool.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList walkEvictionTable(int evictionPolicy, int deleteEntries, long deleteSize) {
        Object object;
        String methodName = "walkEvictionTable()";
        if (evictionPolicy != 1 && evictionPolicy != 2) {
            return null;
        }
        ArrayList<EvictionTableEntry> vs = null;
        vs = deleteEntries > 0 ? new ArrayList<EvictionTableEntry>(deleteEntries) : new ArrayList(256);
        int i = 0;
        long size = 0L;
        EvictionTableEntry min = null;
        long startCurrentTime = System.currentTimeMillis();
        do {
            object = this.evictionTableMonitor;
            synchronized (object) {
                min = this.EvictionTable.minimum();
                if (min != null && min.expirationTime <= startCurrentTime) {
                    vs.add(this.EvictionTable.deleteMin());
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)"walkEvictionTable()", (Object[])new Object[]{"cacheName=" + this.cacheName + " expiredEntry=" + min.toString()});
                    }
                    ++i;
                    size += (long)min.size;
                } else {
                    min = null;
                }
            }
        } while (min != null);
        if (deleteEntries > 0 && deleteEntries <= i || deleteSize > 0L && deleteSize <= size) {
            return vs;
        }
        if (evictionPolicy == 1) {
            if (deleteEntries > 0) {
                while (i < deleteEntries && this.EvictionTable.size() > 0) {
                    object = this.evictionTableMonitor;
                    synchronized (object) {
                        int index = this.rand.nextInt(this.EvictionTable.size()) + 1;
                        EvictionTableEntry evt = this.EvictionTable.heapArray[index];
                        if (evt != null) {
                            ++i;
                            vs.add(evt);
                            this.EvictionTable.delete(evt);
                        }
                    }
                }
            } else {
                while (size < deleteSize && this.EvictionTable.size() > 0) {
                    object = this.evictionTableMonitor;
                    synchronized (object) {
                        int index = this.rand.nextInt(this.EvictionTable.size()) + 1;
                        EvictionTableEntry evt = this.EvictionTable.heapArray[index];
                        if (evt != null) {
                            size += (long)evt.size;
                            vs.add(evt);
                            this.EvictionTable.delete(evt);
                        }
                    }
                }
            }
        } else if (evictionPolicy == 2) {
            object = this.evictionTableMonitor;
            synchronized (object) {
                int j;
                EvictionTableEntry[] tempArray = new EvictionTableEntry[this.EvictionTable.size()];
                System.arraycopy(this.EvictionTable.heapArray, 1, tempArray, 0, this.EvictionTable.size());
                Arrays.sort(tempArray, new EvictionSizeComparator());
                if (deleteEntries > 0) {
                    for (j = tempArray.length - 1; i < deleteEntries && j >= 0; ++i, --j) {
                        EvictionTableEntry evt = tempArray[j];
                        vs.add(evt);
                        this.EvictionTable.delete(evt);
                    }
                } else {
                    while (size < deleteSize && j >= 0) {
                        EvictionTableEntry evt = tempArray[j];
                        size += (long)evt.size;
                        vs.add(evt);
                        --j;
                        this.EvictionTable.delete(evt);
                    }
                }
            }
        }
        return vs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getExpiredEntriesFromEvictionTable() {
        String methodName = "getExpiredEntriesFromEvictionTable()";
        if (this.cod.evictionPolicy == 0) {
            return null;
        }
        ArrayList<EvictionTableEntry> vs = new ArrayList<EvictionTableEntry>(256);
        EvictionTableEntry min = null;
        long startCurrenTime = System.currentTimeMillis();
        do {
            Object object = this.evictionTableMonitor;
            synchronized (object) {
                min = this.EvictionTable.minimum();
                if (min != null && min.expirationTime <= startCurrenTime) {
                    vs.add(this.EvictionTable.deleteMin());
                    if (this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)"getExpiredEntriesFromEvictionTable()", (Object[])new Object[]{"cacheName=" + this.cacheName + " expiredEntry=" + min.toString()});
                    }
                } else {
                    min = null;
                }
            }
        } while (min != null);
        if (this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"getExpiredEntriesFromEvictionTable()", (Object[])new Object[]{"cacheName=" + this.cacheName + " expiredSize=" + vs.size()});
        }
        return vs;
    }

    public int getPendingRemovalSize() {
        return this.invalidationBuffer.size();
    }

    public int getDepIdsBufferedSize() {
        if (this.delayOffload) {
            if (!this.disableDependencyId) {
                return this.auxDataDependencyTable.size();
            }
            return 0;
        }
        return 0;
    }

    public int getTemplatesBufferedSize() {
        if (this.delayOffload) {
            if (!this.disableTemplatesSupport) {
                return this.auxTemplateDependencyTable.size();
            }
            return 0;
        }
        return 0;
    }

    public void releaseUnusedPools() {
        this.byteArrayPool.release();
        this.longArrayPool.release();
    }

    public boolean isCacheIdInAuxDepIdTable(Object id) {
        if (this.delayOffload) {
            if (!this.disableDependencyId) {
                return this.auxDataDependencyTable.containsCacheId(id);
            }
            return false;
        }
        return false;
    }

    public static class DepEntry {
        public int size;
        public Object id;

        public DepEntry(Object id, int size) {
            this.id = id;
            this.size = size;
        }
    }

    public static class DepSizeComparator
    implements Comparator {
        public int compare(Object evt1, Object evt2) {
            return ((DepEntry)evt1).size - ((DepEntry)evt2).size;
        }
    }

    public static class BinaryHeap {
        public EvictionTableEntry[] heapArray = new EvictionTableEntry[1024];
        private static final int DEFAULT_SIZE = 1024;
        private int heapSize;

        public BinaryHeap(EvictionTableEntry negInfinity) {
            this.heapArray[0] = negInfinity;
            this.heapArray[0].index = 0;
            this.heapArray[0].expirationTime = Long.MIN_VALUE;
            this.heapSize = 0;
        }

        public synchronized void insert(EvictionTableEntry el) {
            int i = ++this.heapSize;
            this.growIfNec();
            while (el.lessThan(this.heapArray[BinaryHeap.parent(i)])) {
                this.heapArray[i] = this.heapArray[BinaryHeap.parent(i)];
                this.heapArray[i].index = i;
                i = BinaryHeap.parent(i);
            }
            this.heapArray[i] = el;
            this.heapArray[i].index = i;
        }

        public void printHeap() {
            System.out.println("PRINT HEAP");
            for (int i = 0; i <= this.size(); ++i) {
                System.out.println("*** evt:" + this.heapArray[i]);
            }
        }

        public EvictionTableEntry minimum() {
            if (this.isEmpty()) {
                return null;
            }
            return this.heapArray[1];
        }

        public synchronized void clear() {
            for (int i = 1; i <= this.heapSize; ++i) {
                this.heapArray[i] = null;
            }
            this.heapSize = 0;
        }

        public synchronized EvictionTableEntry deleteMin() {
            EvictionTableEntry min;
            if (this.isEmpty()) {
                min = null;
            } else {
                EvictionTableEntry last = this.heapArray[this.heapSize];
                this.heapArray[this.heapSize--] = null;
                if (this.isEmpty()) {
                    min = last;
                } else {
                    min = this.heapArray[1];
                    this.heapArray[1] = last;
                    this.heapArray[1].index = 1;
                    this.heapify(1);
                }
            }
            return min;
        }

        public synchronized EvictionTableEntry findAndRemove(long expirationTime, int hashcode, int size) {
            int i;
            EvictionTableEntry he = null;
            for (i = 1; i <= this.heapSize; ++i) {
                he = this.heapArray[i];
                if (he.expirationTime == expirationTime && he.size == size && he.hashcode == hashcode) break;
            }
            if (i > this.heapSize) {
                he = null;
            } else {
                this.heapArray[i] = this.heapArray[0];
                this.heapArray[i].index = i;
                this.percolateUp(i);
                this.deleteMin();
                this.heapArray[0].index = 0;
            }
            return he;
        }

        public synchronized void delete(EvictionTableEntry el) {
            int i = this.findKey(el);
            if (i == -1) {
                throw new IllegalArgumentException();
            }
            this.heapArray[i] = this.heapArray[0];
            this.heapArray[i].index = i;
            this.percolateUp(i);
            this.deleteMin();
            this.heapArray[0].index = 0;
        }

        private int findKey(EvictionTableEntry c) {
            return c.index;
        }

        private void percolateUp(int i) {
            while (this.heapArray[i].lessThan(this.heapArray[BinaryHeap.parent(i)])) {
                int j = BinaryHeap.parent(i);
                EvictionTableEntry c = this.heapArray[j];
                this.heapArray[j] = this.heapArray[i];
                this.heapArray[j].index = j;
                this.heapArray[i] = c;
                this.heapArray[i].index = i;
                int prev = i;
                i = j;
                this.heapify(prev);
            }
        }

        private void heapify(int i) {
            EvictionTableEntry tmp = this.heapArray[i];
            while (BinaryHeap.left(i) <= this.heapSize) {
                int l = BinaryHeap.left(i);
                if (l < this.heapSize && this.heapArray[BinaryHeap.right(i)].lessThan(this.heapArray[l])) {
                    ++l;
                }
                if (!this.heapArray[l].lessThan(tmp)) break;
                this.heapArray[i] = this.heapArray[l];
                this.heapArray[i].index = i;
                i = l;
            }
            this.heapArray[i] = tmp;
            this.heapArray[i].index = i;
        }

        public boolean isEmpty() {
            return this.heapSize == 0;
        }

        public int size() {
            return this.heapSize;
        }

        private static int parent(int i) {
            return i / 2;
        }

        private static int left(int i) {
            return 2 * i;
        }

        private static int right(int i) {
            return 2 * i + 1;
        }

        private void growIfNec() {
            if (this.heapSize + 1 == this.heapArray.length) {
                EvictionTableEntry[] oldHeap = this.heapArray;
                this.heapArray = new EvictionTableEntry[this.heapSize * 2];
                System.arraycopy(oldHeap, 0, this.heapArray, 0, oldHeap.length);
            }
        }
    }

    static class EvictionEntryPool
    extends ObjectPool {
        public EvictionEntryPool(int size) {
            super("EvictionEntryPool", size);
        }

        public Object createObject() {
            return new EvictionTableEntry();
        }

        public boolean add(EvictionTableEntry evt) {
            evt.reset();
            return super.add((Object)evt);
        }
    }

    public static class EvictionTableEntry {
        public int size;
        public long expirationTime;
        public int hashcode;
        public int index;
        public Object id;

        public boolean lessThan(EvictionTableEntry other) {
            return this.expirationTime < other.expirationTime;
        }

        public boolean equals(EvictionTableEntry other) {
            return this.expirationTime == other.expirationTime;
        }

        public boolean lessThanOrEquals(EvictionTableEntry other) {
            return this.expirationTime <= other.expirationTime;
        }

        public void reset() {
            this.expirationTime = 0L;
            this.size = 0;
            this.hashcode = 0;
            this.index = -1;
            this.id = "";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("EVT: index=");
            sb.append(this.index);
            sb.append(" expirationTime=");
            sb.append(this.expirationTime);
            sb.append(" id=");
            sb.append(this.id);
            sb.append(" hashcode=");
            sb.append(this.hashcode);
            sb.append(" size=");
            sb.append(this.size);
            return sb.toString();
        }
    }

    public static class EvictionSizeComparator
    implements Comparator {
        public int compare(Object evt1, Object evt2) {
            return ((EvictionTableEntry)evt1).size - ((EvictionTableEntry)evt2).size;
        }

        @Override
        public boolean equals(Object cmp) {
            if (this == cmp) {
                return true;
            }
            if (cmp == null) {
                return false;
            }
            return this.getClass() == cmp.getClass();
        }
    }

    class DynaAction
    implements HashtableAction {
        ValueSet expiredIds;
        int notExpiredCount = 0;
        HTODDynacache htod = null;

        DynaAction(ValueSet expiredIds, HTODDynacache htod) {
            this.expiredIds = expiredIds;
            this.htod = htod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(HashtableEntry entry) throws Exception {
            String methodName = "execute()";
            Object id = entry.getKey();
            Object tid = null;
            if (this.htod.cacheIdsTable != null) {
                tid = HTODDynacache.this.cacheIdsTable.get(id);
                if (tid == null) {
                    HTODDynacache.this.cacheIdsTable.put(id, id);
                    tid = id;
                }
            } else {
                tid = id;
            }
            if (entry.isExpired()) {
                this.expiredIds.add(tid);
            } else {
                long expirationTime;
                if (this.htod.cod.populateEvictionTable && !entry.isAliasId()) {
                    EvictionTableEntry evt = (EvictionTableEntry)this.htod.evictionEntryPool.remove();
                    evt.hashcode = tid.hashCode();
                    evt.expirationTime = entry.expirationTime();
                    if (evt.expirationTime <= 0L) {
                        evt.expirationTime = Long.MAX_VALUE;
                    }
                    evt.size = entry.size();
                    Object object = this.htod.evictionTableMonitor;
                    synchronized (object) {
                        if (HTODDynacache.this.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)HTODDynacache.this.tc, (String)"execute()", (Object[])new Object[]{"Adding evt during startup, hashcode:" + evt.hashcode + " expirationTime:" + evt.expirationTime + " size:" + evt.size + " index:" + evt.index + " EvictionTable.size" + HTODDynacache.this.EvictionTable.size()});
                        }
                        this.htod.EvictionTable.insert(evt);
                    }
                }
                ++this.notExpiredCount;
                if (!entry.isAliasId() && this.htod.cod.diskCachePerformanceLevel == 3 && (expirationTime = entry.expirationTime()) > 0L && !this.htod.invalidationBuffer.contains(tid)) {
                    if (HTODDynacache.this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)HTODDynacache.this.tc, (String)"execute()", (Object[])new Object[]{"cacheName=" + this.htod.cacheName + " id=" + tid + " expiration=" + expirationTime});
                    }
                    this.htod.cache.addToTimeLimitDaemon(tid, expirationTime, -1);
                }
            }
            HTODDynacache.this.returnToHashtableEntryPool(entry);
            return true;
        }
    }

    class HashcodeReadCallback
    implements HashtableAction {
        HTODInvalidationBuffer invalidationBuffer = null;
        int totalHashcode = 0;
        List<String> list = new ArrayList<String>(100);
        boolean debug = false;
        int count = 0;
        int expiredCount = 0;
        boolean includeValue = false;
        boolean isValidHashCode = true;

        HashcodeReadCallback(HTODInvalidationBuffer invalidationBuffer, boolean debug, boolean includeValue) {
            this.invalidationBuffer = invalidationBuffer;
            this.debug = debug;
            this.includeValue = includeValue;
            this.totalHashcode = 0;
            this.count = 0;
            this.expiredCount = 0;
            this.isValidHashCode = true;
        }

        @Override
        public boolean execute(HashtableEntry entry) throws Exception {
            if (this.isValidHashCode) {
                Object id = entry.getKey();
                if (!entry.isExpired() && !this.invalidationBuffer.contains(id)) {
                    int id_hc = id.hashCode();
                    this.totalHashcode += id_hc;
                    int value_hc = 0;
                    if (this.includeValue) {
                        if (entry.isValidHashcodeForValue()) {
                            value_hc = entry.getCacheValueHashcode();
                            this.totalHashcode += value_hc;
                        } else {
                            this.isValidHashCode = false;
                        }
                    }
                    if (this.isValidHashCode) {
                        ++this.count;
                        if (this.debug) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("\nid=");
                            sb.append(id);
                            sb.append(" id_hashcode=");
                            sb.append(id_hc);
                            if (this.includeValue) {
                                sb.append(" value_hashcode=");
                                sb.append(value_hc);
                            }
                            this.list.add(sb.toString());
                        }
                    }
                } else {
                    ++this.expiredCount;
                }
            }
            HTODDynacache.this.returnToHashtableEntryPool(entry);
            return this.isValidHashCode;
        }
    }

    class ValueSetReadCallback
    implements HashtableAction {
        ValueSet ids;
        ValueSet expiredIds;

        ValueSetReadCallback(ValueSet ids, ValueSet expiredIds) {
            this.ids = ids;
            this.expiredIds = expiredIds;
        }

        @Override
        public boolean execute(HashtableEntry entry) throws Exception {
            if (this.expiredIds != null && entry.isExpired()) {
                this.expiredIds.add(entry.getKey());
            } else {
                this.ids.add(entry.getKey());
            }
            HTODDynacache.this.returnToHashtableEntryPool(entry);
            return true;
        }
    }

    static class ResultObjectPool
    extends ObjectPool {
        public ResultObjectPool(int size) {
            super("HashtableEntryPool", size);
        }

        public Object createObject() {
            return new Result();
        }
    }

    static class HashtableEntryObjectPool
    extends ObjectPool {
        public HashtableEntryObjectPool(int size) {
            super("HashtableEntryPool", size);
        }

        public Object createObject() {
            return new HashtableEntry();
        }
    }
}

