/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.ValueSet;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DependencyTable
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Tr.register(DependencyTable.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final int DEFAULT_SIZE = 2000;
    static final int CONCURRENT_HASHMAP = 0;
    public static final int HASHTABLE = 1;
    private int tableType = 0;
    private Map<Object, ValueSet> dependencyToEntryTable = null;

    public DependencyTable() {
        this(2000);
    }

    public DependencyTable(int initialSize) {
        this.dependencyToEntryTable = new ConcurrentHashMap<Object, ValueSet>(initialSize, 0.75f, 1);
    }

    public DependencyTable(int tableType, int initialSize) {
        if (tableType == 1) {
            this.dependencyToEntryTable = new Hashtable<Object, ValueSet>(initialSize);
            this.tableType = tableType;
        } else {
            this.dependencyToEntryTable = new ConcurrentHashMap<Object, ValueSet>(initialSize, 0.75f, 1);
        }
    }

    public void add(Object dependency, Object entry) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("IMPORTANT: adding dependency " + dependency + " --> " + entry), (Object[])new Object[0]);
        }
        if (dependency == null) {
            throw new IllegalArgumentException("dependency cannot be null");
        }
        ValueSet valueSet = this.dependencyToEntryTable.get(dependency);
        if (valueSet == null) {
            valueSet = new ValueSet(4);
            this.dependencyToEntryTable.put(dependency, valueSet);
        }
        valueSet.add(entry);
    }

    public void add(Object dependency, ValueSet valueSet) {
        if (dependency == null) {
            throw new IllegalArgumentException("dependency cannot be null");
        }
        if (valueSet != null) {
            this.dependencyToEntryTable.put(dependency, valueSet);
        }
    }

    public ValueSet removeDependency(Object dependency) {
        return this.dependencyToEntryTable.remove(dependency);
    }

    public boolean removeEntry(String dependency, Object entry) {
        return this.removeEntry((Object)dependency, entry);
    }

    public boolean removeEntry(Object dependency, Object entry) {
        boolean found = false;
        ValueSet valueSet = this.dependencyToEntryTable.get(dependency);
        if (valueSet == null) {
            return found;
        }
        found = valueSet.remove(entry);
        if (valueSet.size() == 0) {
            this.removeDependency(dependency);
        }
        return found;
    }

    public void clear() {
        if (this.tableType == 1) {
            ((Hashtable)this.dependencyToEntryTable).clear();
        } else {
            ((FastHashtable)((Object)this.dependencyToEntryTable)).clear();
        }
    }

    public Iterator<Object> getKeys() {
        return this.dependencyToEntryTable.keySet().iterator();
    }

    public ValueSet getEntries(Object dependency) {
        ValueSet valueSet = this.dependencyToEntryTable.get(dependency);
        return valueSet;
    }
}

