/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.TokenService;
import com.ibm.ws.security.token.ltpa.LTPAConfiguration;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.util.Map;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPATokenService
implements TokenService {
    private volatile LTPAConfiguration ltpaConfig;
    static final long serialVersionUID = 2921105089052226251L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void setLtpaConfig(LTPAConfiguration ltpaConfig) {
        this.ltpaConfig = ltpaConfig;
    }

    protected void unsetLtpaConfig(LTPAConfiguration ltpaConfig) {
        if (this.ltpaConfig == ltpaConfig) {
            ltpaConfig = null;
        }
    }

    protected void activate(ComponentContext context) {
    }

    protected void deactivate(ComponentContext context) {
    }

    public Token createToken(Map<String, Object> tokenData) throws TokenCreationFailedException {
        TokenFactory tokenFactory = this.ltpaConfig.getTokenFactory();
        return tokenFactory.createToken(tokenData);
    }

    public Token recreateTokenFromBytes(byte[] tokenBytes) throws InvalidTokenException, TokenExpiredException {
        TokenFactory tokenFactory = this.ltpaConfig.getTokenFactory();
        Token token = tokenFactory.validateTokenBytes(tokenBytes);
        this.validateRecreatedToken(token);
        return token;
    }

    public Token recreateTokenFromBytes(byte[] tokenBytes, String ... removeAttributes) throws InvalidTokenException, TokenExpiredException {
        TokenFactory tokenFactory = this.ltpaConfig.getTokenFactory();
        Token token = tokenFactory.validateTokenBytes(tokenBytes, removeAttributes);
        return token;
    }

    private void validateRecreatedToken(Token token) throws InvalidTokenException, TokenExpiredException {
        if (token != null && token.isValid()) {
            return;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.token.ltpa.internal.LTPATokenService", LTPATokenService.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    }
}

