/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.ws.logging.hpel.Guid;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Level;

public class HpelCBEFormatter
extends HpelFormatter {
    private static final String CBE_HEADER_STRING = "<CommonBaseEvents xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"commonbaseevent1_0.xsd\">";
    private static final String CBE_FOOTER_STRING = "</CommonBaseEvents>";
    private static final String GUID_PREFIX = "CE";
    private static final SimpleDateFormat CBE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String[] INDENT = new String[]{"\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String STR_DEFAULT_LOCALIZATION = "default";
    private static final String STR_REQUIRES_LOCALIZATION = "yes";
    private static final String STR_REQUIRES_NO_LOCALIZATION = "no";

    @Override
    public String formatRecord(RepositoryLogRecord record, Locale locale) {
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        return this.getFormattedRecord(record, locale);
    }

    @Override
    public String getFooter() {
        return CBE_FOOTER_STRING;
    }

    @Override
    public String[] getHeader() {
        return new String[]{CBE_HEADER_STRING};
    }

    public String getFormattedRecord(RepositoryLogRecord record, Locale locale) {
        StringBuilder sb = new StringBuilder(300);
        this.createEventOTag(sb, record, locale);
        this.createExtendedElement(sb, record);
        this.createExtendedElement(sb, "CommonBaseEventLogRecord:sequenceNumber", "long", String.valueOf(record.getSequence()));
        this.createExtendedElement(sb, "CommonBaseEventLogRecord:threadID", "int", String.valueOf(record.getThreadID()));
        if (record.getLoggerName() != null) {
            this.createExtendedElement(sb, "CommonBaseEventLogRecord:loggerName", "string", record.getLoggerName());
        }
        for (String name : record.getExtensions().keySet()) {
            if ("thread".equals(name)) continue;
            this.createExtendedElement(sb, record, name);
        }
        if (this.headerProps.getProperty("Version") != null) {
            this.createExtendedElement(sb, "version", "string", this.headerProps.getProperty("Version"));
        }
        if (this.headerProps.getProperty("ProcessId") != null) {
            this.createExtendedElement(sb, "processId", "string", this.headerProps.getProperty("ProcessId"));
        }
        if (this.headerProps.getProperty("ServerName") != null) {
            this.createExtendedElement(sb, "processName", "string", this.headerProps.getProperty("ServerName"));
        }
        switch (record.getLocalizable()) {
            case 1: {
                this.createExtendedElement(sb, "localizable", "string", STR_REQUIRES_LOCALIZATION);
                break;
            }
            case 2: {
                this.createExtendedElement(sb, "localizable", "string", STR_REQUIRES_NO_LOCALIZATION);
                break;
            }
            default: {
                this.createExtendedElement(sb, "localizable", "string", STR_DEFAULT_LOCALIZATION);
            }
        }
        this.createSourceElement(sb, record);
        this.createMessageElement(sb, record);
        this.createSituationElement(sb);
        this.createEventCTag(sb);
        return sb.toString();
    }

    private void createEventCTag(StringBuilder sb) {
        sb.append(this.lineSeparator).append("</CommonBaseEvent>");
    }

    private void createEventOTag(StringBuilder sb, RepositoryLogRecord record, Locale locale) {
        sb.append("<CommonBaseEvent creationTime=\"");
        sb.append(CBE_DATE_FORMAT.format(record.getMillis()));
        sb.append("\"");
        sb.append(" globalInstanceId=\"").append(GUID_PREFIX).append(Guid.generate()).append("\"");
        sb.append(" msg=\"").append(this.formatMessage(record, locale)).append("\"");
        int severity = 0;
        severity = record.getLevel().intValue() >= Level.SEVERE.intValue() ? 50 : (record.getLevel().intValue() >= Level.WARNING.intValue() ? 30 : 10);
        sb.append(" severity=\"").append(severity).append("\"");
        sb.append(" version=\"1.0.1\">");
    }

    private void createSituationElement(StringBuilder sb) {
        sb.append(this.lineSeparator).append(INDENT[0]).append("<situation categoryName=\"ReportSituation\">");
        sb.append(this.lineSeparator).append(INDENT[1]).append("<situationType xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ReportSituation\" reasoningScope=\"INTERNAL\" reportCategory=\"LOG\"/>");
        sb.append(this.lineSeparator).append(INDENT[0]).append("</situation>");
    }

    private void createSourceElement(StringBuilder sb, RepositoryLogRecord record) {
        String hostAddr = this.headerProps.getProperty("HostAddress") == null ? "" : this.headerProps.getProperty("HostAddress");
        String hostType = this.headerProps.getProperty("HostType") == null ? "" : this.headerProps.getProperty("HostType");
        sb.append(this.lineSeparator).append(INDENT[0]).append("<sourceComponentId component=\"Logging\" componentIdType=\"Application\"");
        sb.append(" executionEnvironment=\"Java\" instanceId=\"").append(this.headerProps.getProperty("ServerName")).append("\"");
        sb.append(" location=\"").append(hostAddr).append("\" locationType=\"").append(hostType).append("\"");
        sb.append(" processId=\"").append(this.headerProps.getProperty("ProcessId")).append("\"").append(" subComponent=\"Logger\"");
        sb.append(" threadId=\"").append(record.getExtension("thread")).append("\"");
        sb.append(" componentType=\"Logging_Application\"/>");
    }

    private void createMessageElement(StringBuilder sb, RepositoryLogRecord record) {
        sb.append(this.lineSeparator).append(INDENT[0]).append("<msgDataElement msgLocale=\"").append(record.getMessageLocale()).append("\">");
        if (record.getParameters() != null) {
            for (int c = 0; c < record.getParameters().length; ++c) {
                sb.append(this.lineSeparator).append(INDENT[1]).append("<msgCatalogTokens value=\"").append(MessageFormat.format("{" + c + "}", record.getParameters())).append("\"/>");
            }
        }
        if (record.getMessageID() != null) {
            sb.append(this.lineSeparator).append(INDENT[1]).append("<msgId>").append(record.getMessageID()).append("</msgId>");
            sb.append(this.lineSeparator).append(INDENT[1]).append("<msgIdType>");
            if (record.getMessageID().length() == 10) {
                sb.append("IBM5.4.1");
            } else {
                sb.append("IBM4.4.1");
            }
            sb.append("</msgIdType>");
        }
        if (record.getRawMessage() != null && record.getResourceBundleName() != null) {
            sb.append(this.lineSeparator).append(INDENT[1]).append("<msgCatalogId>").append(record.getRawMessage()).append("</msgCatalogId>");
            sb.append(this.lineSeparator).append(INDENT[1]).append("<msgCatalogType>Java</msgCatalogType>");
            sb.append(this.lineSeparator).append(INDENT[1]).append("<msgCatalog>").append(record.getResourceBundleName()).append("</msgCatalog>");
        }
        sb.append(this.lineSeparator).append(INDENT[0]).append("</msgDataElement>");
    }

    private void createExtendedElement(StringBuilder sb, RepositoryLogRecord record) {
        sb.append(this.lineSeparator).append(INDENT[0]).append("<extendedDataElements name=\"CommonBaseEventLogRecord:level\" type=\"noValue\">");
        sb.append(this.lineSeparator).append(INDENT[1]).append("<children name=\"CommonBaseEventLogRecord:name\" type=\"string\">");
        sb.append(this.lineSeparator).append(INDENT[2]).append("<values>").append(record.getLevel().getName()).append("</values>");
        sb.append(this.lineSeparator).append(INDENT[1]).append("</children>");
        sb.append(this.lineSeparator).append(INDENT[1]).append("<children name=\"CommonBaseEventLogRecord:value\" type=\"int\">");
        sb.append(this.lineSeparator).append(INDENT[2]).append("<values>").append(record.getLevel().intValue()).append("</values>");
        sb.append(this.lineSeparator).append(INDENT[1]).append("</children>");
        sb.append(this.lineSeparator).append(INDENT[0]).append("</extendedDataElements>");
    }

    private void createExtendedElement(StringBuilder sb, RepositoryLogRecord record, String extensionID) {
        String edeValue = record.getExtension(extensionID);
        if (edeValue != null && !edeValue.isEmpty()) {
            this.createExtendedElement(sb, extensionID, "string", edeValue);
        }
    }

    private void createExtendedElement(StringBuilder sb, String edeName, String edeType, String edeValues) {
        sb.append(this.lineSeparator).append(INDENT[0]).append("<extendedDataElements name=\"").append(edeName).append("\" type=\"").append(edeType).append("\">");
        sb.append(this.lineSeparator).append(INDENT[1]).append("<values>").append(edeValues).append("</values>");
        sb.append(this.lineSeparator).append(INDENT[0]).append("</extendedDataElements>");
    }

    @Override
    protected String appendUnusedParms(String message, Object[] args) {
        String returnValue = message;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                buffer.append("; ");
            } else {
                buffer.append(", ");
            }
            if (args[i] == null) {
                buffer.append("null");
                continue;
            }
            buffer.append(args[i].toString());
        }
        returnValue = returnValue.concat(buffer.toString());
        return returnValue;
    }
}

