/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.validator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigKeySelector
extends KeySelector {
    private static final TraceComponent tc = Tr.register(ConfigKeySelector.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    static final long serialVersionUID = -674369884970226043L;

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        ConfigKeySelectorResult result = null;
        if (!purpose.equals(KeySelector.Purpose.VERIFY)) {
            throw new KeySelectorException("Key purpose not set to \"verify\"");
        }
        X509Data x509Data = null;
        X509Certificate cert = null;
        List<XMLStructure> content = keyInfo.getContent();
        Iterator<XMLStructure> keyInfoIterator = content.iterator();
        while (keyInfoIterator.hasNext() && x509Data == null) {
            XMLStructure xmlStruct = keyInfoIterator.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("select():  xmlStruct = " + xmlStruct), (Object[])new Object[0]);
            }
            if (!(xmlStruct instanceof X509Data)) continue;
            x509Data = (X509Data)xmlStruct;
            List<?> x509content = x509Data.getContent();
            Iterator<?> x509DataIterator = x509content.iterator();
            while (x509DataIterator.hasNext() && result == null) {
                Object obj = x509DataIterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("select():  obj = " + obj), (Object[])new Object[0]);
                }
                if (!(obj instanceof X509Certificate)) continue;
                cert = (X509Certificate)obj;
                PublicKey publicKey = cert.getPublicKey();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("select():  publicKey = " + publicKey), (Object[])new Object[0]);
                }
                String algURI = method.getAlgorithm();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("select():  algURI = " + algURI), (Object[])new Object[0]);
                }
                String algName = publicKey.getAlgorithm();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("select():  algName = " + algName), (Object[])new Object[0]);
                }
                if ((!algName.equalsIgnoreCase("DSA") || !algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) && (!algName.equalsIgnoreCase("RSA") || !algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1"))) continue;
                result = new ConfigKeySelectorResult(publicKey);
            }
        }
        if (result == null) {
            result = new ConfigKeySelectorResult(null);
        }
        return result;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ConfigKeySelectorResult
    implements KeySelectorResult {
        private Key key = null;
        static final long serialVersionUID = 5216282915080634409L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConfigKeySelectorResult(Key key) {
            this.key = key;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        public String toString() {
            return this.getClass().getName() + ": key = " + this.key;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.validator.ConfigKeySelector$ConfigKeySelectorResult", ConfigKeySelectorResult.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }
}

