/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.xml.internal.ConfigElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Trivial
class ConfigurationList<T extends ConfigElement> {
    private final List<T> configElements = new ArrayList<T>();
    private Boolean hasId = null;

    public void add(T configElement) {
        this.configElements.add(configElement);
        this.hasId = null;
    }

    public void add(ConfigurationList<T> value) {
        this.configElements.addAll(value.configElements);
        this.hasId = null;
    }

    public void remove(ConfigurationList<T> value) {
        this.configElements.removeAll(value.configElements);
        this.hasId = null;
    }

    public boolean remove(String id) {
        boolean removed = false;
        if (id == null) {
            removed = this.configElements.size() > 0;
            this.configElements.clear();
        } else {
            Iterator<T> iter = this.configElements.iterator();
            while (iter.hasNext()) {
                ConfigElement element = (ConfigElement)iter.next();
                if (!id.equals(element.getId())) continue;
                iter.remove();
                removed = true;
            }
        }
        this.hasId = null;
        return removed;
    }

    public boolean isEmpty() {
        return this.configElements.isEmpty();
    }

    public boolean hasId() {
        if (this.hasId == null) {
            this.hasId = this.hasElementWithId();
        }
        return this.hasId;
    }

    private boolean hasElementWithId() {
        for (ConfigElement configElement : this.configElements) {
            if (configElement.getId() == null) continue;
            return true;
        }
        return false;
    }

    private static String generateId(int index) {
        return "default-" + index;
    }

    public Map<ConfigID, List<T>> collectElementsById(Map<ConfigID, List<T>> map, String defaultId, String pid) {
        if (map == null) {
            map = new HashMap<ConfigID, List<T>>();
        }
        int index = 0;
        for (ConfigElement configElement : this.configElements) {
            String id = configElement.getId();
            if (id == null) {
                id = defaultId != null ? defaultId : ConfigurationList.generateId(index++);
            }
            ConfigID configID = configElement.getConfigID();
            List<T> elements = map.get(configID = new ConfigID(configID.getParent(), pid, id, configID.getChildAttribute()));
            if (elements == null) {
                elements = new ArrayList<T>();
                map.put(configID, elements);
            }
            elements.add(configElement);
        }
        return map;
    }

    public List<T> collectElementsWithId(String id, List<T> elements) {
        if (elements == null) {
            elements = new ArrayList<T>();
        }
        int index = 0;
        for (ConfigElement configElement : this.configElements) {
            String elementId = configElement.getId();
            if (elementId == null) {
                elementId = ConfigurationList.generateId(index++);
            }
            if (!elementId.equals(id)) continue;
            elements.add(configElement);
        }
        return elements;
    }

    public List<T> collectElements(List<T> elements) {
        if (elements == null) {
            elements = new ArrayList<T>();
        }
        elements.addAll(this.configElements);
        return elements;
    }
}

