/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigRetrieverException;
import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.config.ConfigValidationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ChangeHandler;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigNotFoundException;
import com.ibm.ws.config.xml.internal.ConfigRetriever;
import com.ibm.ws.config.xml.internal.ConfigUpdater;
import com.ibm.ws.config.xml.internal.ConfigValidator;
import com.ibm.ws.config.xml.internal.ConfigurationInfo;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.FactoryElement;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.SingletonElement;
import com.ibm.ws.config.xml.internal.SystemConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.MetaTypeInformation;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class BundleProcessor
implements SynchronousBundleListener,
EventHandler,
RuntimeUpdateListener {
    private static final TraceComponent tc = Tr.register(BundleProcessor.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private static final String EXTENDED_BUNDLE_CACHE = "extended.bundle.cache";
    private static final int EXTENDED_BUNDLE_CACHE_VERSION = 0;
    private final BundleContext bundleContext;
    private final SystemConfiguration systemConfiguration;
    private final WsLocationAdmin locationService;
    private final MetaTypeRegistry metatypeRegistry;
    private final ConfigUpdater configUpdater;
    private final ChangeHandler changeHandler;
    private final ConfigValidator validator;
    private final ConfigRetriever configRetriever;
    private boolean reprocessConfig;
    private final Object bundleChangedLock = new Object(){
        static final long serialVersionUID = -8305994960912421558L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.BundleProcessor$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    };
    private final Object metatypeChangedLock = new Object(){
        static final long serialVersionUID = 8819327219526957005L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.BundleProcessor$2", 2.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    };
    private final ServiceRegistration<EventHandler> eventHandlerService;
    private final ServiceRegistration<RuntimeUpdateListener> updateListenerService;
    private final Map<Bundle, ExtendedBundle> extendedBundles = new WeakHashMap<Bundle, ExtendedBundle>();
    private final Collection<Bundle> existingBundles = new ArrayList<Bundle>();
    static final long serialVersionUID = -8303122453672725482L;

    public BundleProcessor(BundleContext bc, SystemConfiguration systemConfiguration, WsLocationAdmin locationService, ConfigUpdater configUpdater, ChangeHandler changeHandler, ConfigValidator validator, ConfigRetriever configRetriever) {
        this.bundleContext = bc;
        this.systemConfiguration = systemConfiguration;
        this.locationService = locationService;
        this.configUpdater = configUpdater;
        this.changeHandler = changeHandler;
        this.validator = validator;
        this.configRetriever = configRetriever;
        this.loadExtendedBundles();
        ServiceReference ref = this.bundleContext.getServiceReference(MetaTypeRegistry.class);
        this.metatypeRegistry = (MetaTypeRegistry)this.bundleContext.getService(ref);
        Hashtable<String, String[]> eventHandlerServiceProps = new Hashtable<String, String[]>();
        ((Dictionary)eventHandlerServiceProps).put("event.topics", new String[]{"internal_mtp_added", "internal_mtp_removed"});
        this.eventHandlerService = this.bundleContext.registerService(EventHandler.class, (Object)this, eventHandlerServiceProps);
        Hashtable updateListenerProps = new Hashtable();
        this.updateListenerService = this.bundleContext.registerService(RuntimeUpdateListener.class, (Object)this, updateListenerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtendedBundles() {
        BundleContext systemContext = this.bundleContext.getBundle("System Bundle").getBundleContext();
        File extendedBundlesCache = this.bundleContext.getDataFile(EXTENDED_BUNDLE_CACHE);
        if (extendedBundlesCache.isFile()) {
            Map<Bundle, ExtendedBundle> map = this.extendedBundles;
            synchronized (map) {
                try {
                    DataInputStream in;
                    block12: {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(extendedBundlesCache)));
                        if (in.readInt() == 0) break block12;
                        in.close();
                        return;
                    }
                    try {
                        int numBundles = in.readInt();
                        for (int i = 0; i < numBundles; ++i) {
                            long id = in.readLong();
                            long lastProcessed = in.readLong();
                            String nameAndVersion = in.readUTF();
                            boolean hasDefaultConfig = in.readBoolean();
                            Bundle b = systemContext.getBundle(id);
                            if (b == null) continue;
                            this.extendedBundles.put(b, new ExtendedBundle(b, lastProcessed, nameAndVersion, hasDefaultConfig));
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"153", (Object)this, (Object[])new Object[0]);
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"153", (Object)this, (Object[])new Object[0]);
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    in.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"169", (Object)this, (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveExtendedBundles() {
        ArrayList<ExtendedBundle> saveExtendedBundles;
        Map<Bundle, ExtendedBundle> map = this.extendedBundles;
        synchronized (map) {
            saveExtendedBundles = new ArrayList<ExtendedBundle>(this.extendedBundles.values());
        }
        File extendedBundlesCache = this.bundleContext.getDataFile(EXTENDED_BUNDLE_CACHE);
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(extendedBundlesCache)));
            try {
                out.writeInt(0);
                out.writeInt(saveExtendedBundles.size());
                for (ExtendedBundle extendedBundle : saveExtendedBundles) {
                    out.writeLong(extendedBundle.getBundle().getBundleId());
                    out.writeLong(extendedBundle.getLastProcessed());
                    out.writeUTF(extendedBundle.getNameAndVersion());
                    out.writeBoolean(extendedBundle.hasDefaultConfig());
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"182", (Object)this, (Object[])new Object[0]);
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"182", (Object)this, (Object[])new Object[0]);
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"191", (Object)this, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtendedBundle getExtendedBundle(Bundle b) {
        Map<Bundle, ExtendedBundle> map = this.extendedBundles;
        synchronized (map) {
            ExtendedBundle result = this.extendedBundles.get(b);
            if (result != null) {
                return result;
            }
            result = new ExtendedBundle(b);
            this.extendedBundles.put(b, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startProcessor(boolean reprocessConfig) {
        Object object = this;
        synchronized (object) {
            this.reprocessConfig = reprocessConfig;
        }
        object = this.bundleChangedLock;
        synchronized (object) {
            this.bundleContext.addBundleListener((BundleListener)this);
            ArrayList<Bundle> bundlesToProcess = new ArrayList<Bundle>();
            for (Bundle b : this.bundleContext.getBundles()) {
                if (b.getState() < 4) continue;
                if (b.getLocation().startsWith("kernel@")) {
                    bundlesToProcess.add(b);
                    continue;
                }
                this.existingBundles.add(b);
            }
            this.addBundles(bundlesToProcess);
        }
    }

    void stopProcessor() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.eventHandlerService.unregister();
        this.updateListenerService.unregister();
        this.saveExtendedBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (FrameworkState.isStopping()) {
            return;
        }
        Object object = this.bundleChangedLock;
        synchronized (object) {
            int type = event.getType();
            Bundle b = event.getBundle();
            boolean isFeatureBundle = b.getLocation().startsWith("feature@");
            if (type == 32) {
                if (isFeatureBundle) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Bundle resolved event for feature bundle {0}", (Object[])new Object[]{b});
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Adding bundle {0}", (Object[])new Object[]{b});
                    }
                    this.addBundles(Arrays.asList(b));
                }
            } else if (type == 64 && !isFeatureBundle) {
                this.removeBundles(Arrays.asList(b));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void metaTypeAdded(Bundle bundle, Set<MetaTypeRegistry.RegistryEntry> registryEntries) {
        HashSet<String> updatedPids = new HashSet<String>();
        for (MetaTypeRegistry.RegistryEntry entry : registryEntries) {
            if (entry == null) continue;
            updatedPids.add(entry.getPid());
        }
        Object object = this.metatypeChangedLock;
        synchronized (object) {
            try {
                PIDProcessor processor = new PIDProcessor(new ExtendedBundle(bundle).getNameAndVersion());
                processor.processRegistryEntries(registryEntries);
                this.configUpdater.updateAndFireEvents(processor.getConfigurationsToUpdate(), ErrorHandler.INSTANCE.getOnError());
                this.configUpdater.fireMetatypeAddedEvents(updatedPids);
            }
            catch (ConfigUpdateException processor) {
                void e;
                FFDCFilter.processException((Throwable)processor, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"290", (Object)this, (Object[])new Object[]{bundle, registryEntries});
                Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaTypeRemoved(MetaTypeInformation info, Set<MetaTypeRegistry.RegistryEntry> updatedPids) {
        if (FrameworkState.isStopping()) {
            return;
        }
        Object object = this.metatypeChangedLock;
        synchronized (object) {
            ServerConfiguration sc = this.systemConfiguration.getServerConfiguration();
            Set<String> updates = this.changeHandler.removeMetatypeConvertedConfig(sc, updatedPids);
            this.configUpdater.fireMetatypeDeletedEvents(updates);
            if (tc.isDebugEnabled()) {
                for (String update : updates) {
                    Tr.debug((TraceComponent)tc, (String)("Removed metatype for PID " + update), (Object[])new Object[0]);
                }
            }
        }
    }

    public void notificationCreated(final RuntimeUpdateManager updateManager, final RuntimeUpdateNotification notification) {
        if (FrameworkState.isStopping()) {
            return;
        }
        if ("FeatureBundlesResolved".equals(notification.getName())) {
            notification.onCompletion((CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = -8362004332317902661L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    if (FrameworkState.isStopping()) {
                        return;
                    }
                    RuntimeUpdateNotification processed = updateManager.createNotification("FeatureBundlesProcessed");
                    Map props = notification.getProperties();
                    if (props != null) {
                        Set addedBundles = (Set)props.get("InstalledBundles");
                        Set removedBundles = (Set)props.get("RemovedBundles");
                        BundleProcessor bundleProcessor = BundleProcessor.this;
                        synchronized (bundleProcessor) {
                            if (!BundleProcessor.this.existingBundles.isEmpty()) {
                                if (tc.isDebugEnabled()) {
                                    for (Bundle bundle : BundleProcessor.this.existingBundles) {
                                        Tr.debug((TraceComponent)tc, (String)("Processing cached bundle: " + bundle), (Object[])new Object[0]);
                                    }
                                }
                                BundleProcessor.this.addBundles(BundleProcessor.this.existingBundles);
                                BundleProcessor.this.existingBundles.clear();
                            }
                            if (removedBundles != null) {
                                if (tc.isDebugEnabled()) {
                                    for (Bundle bundle : removedBundles) {
                                        Tr.debug((TraceComponent)tc, (String)("Processing removed bundle: " + bundle), (Object[])new Object[0]);
                                    }
                                }
                                BundleProcessor.this.removeBundles(removedBundles);
                            }
                            if (addedBundles != null) {
                                if (tc.isDebugEnabled()) {
                                    for (Bundle bundle : addedBundles) {
                                        Tr.debug((TraceComponent)tc, (String)("Processing added bundle: " + bundle), (Object[])new Object[0]);
                                    }
                                }
                                BundleProcessor.this.addBundles(addedBundles);
                            }
                        }
                    }
                    if (processed != null) {
                        processed.setResult(true);
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.BundleProcessor$3", 3.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
                }
            });
        }
    }

    public void handleEvent(Event event) {
        if (FrameworkState.isStopping()) {
            return;
        }
        String topic = event.getTopic();
        if ("internal_mtp_added".equals(topic)) {
            Bundle bundle = (Bundle)event.getProperty("internal_mtp_bundle");
            Set updatedPids = (Set)event.getProperty("internal_mtp_updated_pids");
            this.metaTypeAdded(bundle, updatedPids);
        } else if ("internal_mtp_removed".equals(topic)) {
            MetaTypeInformation info = (MetaTypeInformation)event.getProperty("internal_mtp_info");
            Set updatedPids = (Set)event.getProperty("internal_mtp_updated_pids");
            this.metaTypeRemoved(info, updatedPids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConfigUpdateException.class})
    private void addBundles(Collection<Bundle> bundles) {
        BundleProcessor bundleProcessor = this;
        synchronized (bundleProcessor) {
            try {
                if (FrameworkState.isStopping()) {
                    return;
                }
                HashSet<MetaTypeRegistry.RegistryEntry> newEntries = new HashSet<MetaTypeRegistry.RegistryEntry>();
                for (Bundle b : bundles) {
                    if (b.getState() < 4) continue;
                    Set<MetaTypeRegistry.RegistryEntry> entries = this.metatypeRegistry.addMetaType(b);
                    if (!this.reprocessConfig && !this.getExtendedBundle(b).needsReprocessing()) continue;
                    newEntries.addAll(entries);
                }
                for (Bundle b : bundles) {
                    if (b.getState() < 4) continue;
                    newEntries.addAll(this.processBundleConfig(b));
                }
                PIDProcessor pidProcessor = new PIDProcessor("Feature Update");
                pidProcessor.processRegistryEntries(newEntries);
                this.configUpdater.updateAndFireEvents(pidProcessor.getConfigurationsToUpdate(), ErrorHandler.INSTANCE.getOnError());
                this.configUpdater.processUnresolvedReferences(ErrorHandler.INSTANCE.getOnError());
            }
            catch (ConfigUpdateException e) {
                this.handleConfigUpdateException(e);
            }
            catch (ConfigValidationException e) {
                void cve;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"452", (Object)this, (Object[])new Object[]{bundles});
                this.handleConfigValidationException((ConfigValidationException)cve);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={ConfigUpdateException.class})
    private void removeBundles(Collection<Bundle> bundles) {
        BundleProcessor bundleProcessor = this;
        synchronized (bundleProcessor) {
            for (Bundle bundle : bundles) {
                if (FrameworkState.isStopping()) {
                    return;
                }
                ServerConfiguration oldConfig = this.systemConfiguration.copyServerConfiguration();
                this.systemConfiguration.bundleRemoved(bundle);
                try {
                    this.systemConfiguration.removeDefaultConfiguration(oldConfig);
                }
                catch (ConfigUpdateException e) {
                    this.handleConfigUpdateException(e);
                }
                this.metatypeRegistry.removeMetaType(bundle);
            }
            try {
                this.configUpdater.processUnresolvedReferences(ErrorHandler.INSTANCE.getOnError());
            }
            catch (ConfigUpdateException e) {
                this.handleConfigUpdateException(e);
            }
        }
    }

    private synchronized Set<MetaTypeRegistry.RegistryEntry> processBundleConfig(Bundle bundle) throws ConfigUpdateException, ConfigValidationException {
        boolean reprocessBundle;
        MetaTypeInformation metaTypeInformation = this.metatypeRegistry.getMetaTypeInformation(bundle);
        if (metaTypeInformation != null) {
            for (String factoryPid : metaTypeInformation.getFactoryPids()) {
                if (this.metatypeRegistry.getRegistryEntry(factoryPid) != null) continue;
                this.metatypeRegistry.missingPid(factoryPid);
            }
        }
        ExtendedBundle eb = this.getExtendedBundle(bundle);
        HashSet<MetaTypeRegistry.RegistryEntry> entriesToProcess = new HashSet<MetaTypeRegistry.RegistryEntry>();
        if (eb.hasDefaultConfig()) {
            BaseConfiguration newDefaultConfig = this.systemConfiguration.loadDefaultConfiguration(bundle);
            if (newDefaultConfig != null) {
                Set<String> defaultConfigNames = newDefaultConfig.getConfigurationNames();
                for (String defaultConfigName : defaultConfigNames) {
                    MetaTypeRegistry.RegistryEntry entry = this.metatypeRegistry.getRegistryEntryByPidOrAlias(defaultConfigName);
                    if (entry == null) continue;
                    entriesToProcess.add(entry);
                }
            } else {
                eb.setHasDefaultConfig(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processBundle():  Processing bundle name/version=" + eb.getNameAndVersion()), (Object[])new Object[0]);
        }
        boolean bl = reprocessBundle = this.reprocessConfig || eb.needsReprocessing();
        if (!reprocessBundle) {
            this.validator.validate(entriesToProcess);
            return Collections.emptySet();
        }
        eb.updateLastProcessed();
        return entriesToProcess;
    }

    public void addDefaultConfiguration(String pid, Dictionary<String, String> properties) throws ConfigUpdateException {
        this.updateWithNewDefaults(this.systemConfiguration.addDefaultConfiguration(pid, properties));
    }

    /*
     * WARNING - void declaration
     */
    public void addDefaultConfiguration(InputStream defaultConfig) throws ConfigUpdateException {
        try {
            this.updateWithNewDefaults(this.systemConfiguration.addDefaultConfiguration(defaultConfig));
        }
        catch (ConfigValidationException configValidationException) {
            void ex;
            FFDCFilter.processException((Throwable)configValidationException, (String)"com.ibm.ws.config.xml.internal.BundleProcessor", (String)"564", (Object)this, (Object[])new Object[]{defaultConfig});
            throw new ConfigUpdateException((Exception)ex);
        }
    }

    private void updateWithNewDefaults(BaseConfiguration newDefaultConfig) throws ConfigUpdateException {
        if (newDefaultConfig != null) {
            Set<String> defaultConfigNames = newDefaultConfig.getConfigurationNames();
            HashSet<MetaTypeRegistry.RegistryEntry> registryEntries = new HashSet<MetaTypeRegistry.RegistryEntry>(defaultConfigNames.size());
            for (String configName : defaultConfigNames) {
                MetaTypeRegistry.RegistryEntry registryEntry = this.metatypeRegistry.getRegistryEntryByPidOrAlias(configName);
                if (registryEntry == null) continue;
                registryEntries.add(registryEntry);
            }
            PIDProcessor processor = new PIDProcessor("default configuration");
            processor.processRegistryEntries(registryEntries);
            this.configUpdater.updateAndFireEvents(processor.getConfigurationsToUpdate(), ErrorHandler.INSTANCE.getOnError());
        }
    }

    public boolean removeDefaultConfiguration(String pid) throws ConfigUpdateException {
        return this.systemConfiguration.removeDefaultConfiguration(pid, null);
    }

    public boolean removeDefaultConfiguration(String pid, String id) throws ConfigUpdateException {
        if (FrameworkState.isStopping()) {
            return false;
        }
        return this.systemConfiguration.removeDefaultConfiguration(pid, id);
    }

    @FFDCIgnore(value={Exception.class})
    private void quit(Exception cause) {
        Tr.audit((TraceComponent)tc, (String)"frameworkShutdown", (Object[])new Object[]{this.locationService.getServerName()});
        try {
            Bundle bundle = this.bundleContext.getBundle("System Bundle");
            if (bundle != null) {
                bundle.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleConfigUpdateException(ConfigUpdateException e) {
        Tr.error((TraceComponent)tc, (String)"error.config.update.init", (Object[])new Object[]{e.getMessage()});
        if (ErrorHandler.INSTANCE.getOnError().equals((Object)OnErrorUtil.OnError.FAIL)) {
            this.quit(e);
        }
    }

    private void handleConfigValidationException(ConfigValidationException cve) {
        if (!cve.docLocation.isEmpty()) {
            Tr.fatal((TraceComponent)tc, (String)"fatal.configValidator.documentNotValid", (Object[])new Object[]{cve.docLocation});
        }
        this.quit(cve);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ExtendedBundle {
        private final Bundle bundle;
        private final AtomicLong lastProcessed = new AtomicLong(Long.MIN_VALUE);
        private final String nameAndVersion;
        private final AtomicBoolean hasDefaultConfig = new AtomicBoolean(true);
        static final long serialVersionUID = -5503242778127279693L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExtendedBundle(Bundle b) {
            this.bundle = b;
            Version ver = b.getVersion();
            if (ver == null) {
                ver = Version.emptyVersion;
            }
            this.nameAndVersion = b.getSymbolicName() + "_" + ver.toString();
        }

        public ExtendedBundle(Bundle b, long lastProcessed, String nameAndVersion, boolean hasDefaultConfig) {
            this.bundle = b;
            this.lastProcessed.set(lastProcessed);
            this.nameAndVersion = nameAndVersion;
            this.hasDefaultConfig.set(hasDefaultConfig);
        }

        public String getNameAndVersion() {
            return this.nameAndVersion;
        }

        public long getLastProcessed() {
            return this.lastProcessed.get();
        }

        public boolean hasDefaultConfig() {
            return this.hasDefaultConfig.get();
        }

        public boolean needsReprocessing() {
            return this.lastProcessed.get() != this.bundle.getLastModified();
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public void setHasDefaultConfig(boolean hasDefaultConfig) {
            this.hasDefaultConfig.set(hasDefaultConfig);
        }

        public void updateLastProcessed() {
            this.lastProcessed.set(this.bundle.getLastModified());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.BundleProcessor$ExtendedBundle", ExtendedBundle.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class PIDProcessor {
        private final String updateName;
        private final ServerConfiguration serverConfig;
        private final List<ConfigurationInfo> infos = new ArrayList<ConfigurationInfo>();
        static final long serialVersionUID = -4365600379783787900L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PIDProcessor(String updateName) {
            this.updateName = updateName;
            this.serverConfig = BundleProcessor.this.systemConfiguration.getServerConfiguration();
        }

        public List<ConfigurationInfo> getConfigurationsToUpdate() {
            return this.infos;
        }

        void processRegistryEntries(Set<MetaTypeRegistry.RegistryEntry> entries) throws ConfigUpdateException {
            HashSet<MetaTypeRegistry.RegistryEntry> allEntriesToProcess = new HashSet<MetaTypeRegistry.RegistryEntry>();
            for (MetaTypeRegistry.RegistryEntry entry : entries) {
                allEntriesToProcess.add(entry);
                List<MetaTypeRegistry.PidReference> pids = entry.getReferencingEntries();
                for (MetaTypeRegistry.PidReference pid : pids) {
                    allEntriesToProcess.add(pid.getReferencingEntry());
                }
            }
            for (MetaTypeRegistry.RegistryEntry entry : allEntriesToProcess) {
                if (entry.isSingleton()) {
                    this.processSingletonPid(entry);
                    continue;
                }
                this.processFactoryPid(entry);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processFactoryPid(MetaTypeRegistry.RegistryEntry registry) throws ConfigUpdateException {
            block15: {
                String defaultId = registry.getDefaultId();
                Map instances = this.serverConfig.getFactoryInstancesUsingDefaultId(registry.getPid(), registry.getAlias(), defaultId);
                this.processFactoryInstances(registry, instances);
                this.findReferringConfigs(BundleProcessor.this.metatypeRegistry.getEntriesUsingService(registry));
                List<ConfigElement> nestedElements = this.serverConfig.getNestedInstances(registry);
                for (ConfigElement nested : nestedElements) {
                    MetaTypeRegistry.RegistryEntry parentEntry;
                    ConfigElement parentCE;
                    block14: {
                        parentCE = nested.getParent();
                        parentEntry = BundleProcessor.this.metatypeRegistry.getRegistryEntry(parentCE);
                        while (parentCE.getParent() != null) {
                            parentCE = parentCE.getParent();
                        }
                        parentEntry = BundleProcessor.this.metatypeRegistry.getRegistryEntry(parentCE);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Creating configuration info for new element {0} using registry entry {1}", (Object[])new Object[]{parentEntry});
                        }
                        try {
                            ExtendedConfiguration[] configs = BundleProcessor.this.configRetriever.findAllNestedConfigurations(nested.getConfigID());
                            if (configs != null) {
                                for (ExtendedConfiguration config : configs) {
                                    if (config.isDeleted()) continue;
                                    config.delete(false);
                                }
                            }
                        }
                        catch (ConfigRetrieverException configs) {
                            void e;
                            FFDCFilter.processException((Throwable)configs, (String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", (String)"695", (Object)this, (Object[])new Object[]{registry});
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug((TraceComponent)tc, (String)("Exception when retrieving pre-metatype configurations to delete: " + e), (Object[])new Object[0]);
                        }
                    }
                    try {
                        ConfigurationInfo info = BundleProcessor.this.changeHandler.createConfigurationInfo(parentCE, parentEntry);
                        this.addIfUnique(this.infos, info);
                    }
                    catch (ConfigNotFoundException info) {
                        void ex;
                        FFDCFilter.processException((Throwable)info, (String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", (String)"705", (Object)this, (Object[])new Object[]{registry});
                        throw new ConfigUpdateException((Exception)ex);
                    }
                }
                if (registry.getAlias() != null && !registry.getPid().equals(registry.getAlias())) {
                    try {
                        ExtendedConfiguration[] aliasedConfigs = BundleProcessor.this.configRetriever.findAllConfigurationsByPid(registry.getAlias());
                        if (aliasedConfigs != null) {
                            for (ExtendedConfiguration aliased : aliasedConfigs) {
                                if (aliased.isDeleted()) continue;
                                aliased.delete(false);
                            }
                        }
                    }
                    catch (ConfigRetrieverException aliasedConfigs) {
                        void e;
                        FFDCFilter.processException((Throwable)aliasedConfigs, (String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", (String)"723", (Object)this, (Object[])new Object[]{registry});
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug((TraceComponent)tc, (String)("Exception when retrieving pre-metatype configurations to delete: " + e), (Object[])new Object[0]);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processSingletonPid(MetaTypeRegistry.RegistryEntry registry) throws ConfigUpdateException {
            SingletonElement configElement = this.serverConfig.getSingleton(registry.getPid(), registry.getAlias());
            ConfigurationInfo singleton = this.processSingletonInstances(configElement, registry);
            this.findReferringConfigs(BundleProcessor.this.metatypeRegistry.getEntriesUsingService(registry));
            String parentPID = registry.getObjectClassDefinition().getParentPID();
            if (parentPID != null) {
                List<ConfigElement> nestedElements = this.serverConfig.getNestedInstances(registry);
                for (ConfigElement nested : nestedElements) {
                    ConfigElement parentCE = nested.getParent();
                    while (parentCE.getParent() != null) {
                        parentCE = parentCE.getParent();
                    }
                    try {
                        MetaTypeRegistry.RegistryEntry parentEntry = BundleProcessor.this.metatypeRegistry.getRegistryEntry(parentCE);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Creating configuration info for new element {0} using registry entry {1}", (Object[])new Object[]{parentEntry});
                        }
                        ConfigurationInfo info = BundleProcessor.this.changeHandler.createConfigurationInfo(parentCE, parentEntry);
                        this.infos.add(info);
                    }
                    catch (ConfigNotFoundException parentEntry) {
                        void ex;
                        FFDCFilter.processException((Throwable)parentEntry, (String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", (String)"762", (Object)this, (Object[])new Object[]{registry});
                        throw new ConfigUpdateException((Exception)ex);
                    }
                    if (!this.serverConfig.getSingletonElements(registry.getPid(), registry.getAlias()).isEmpty()) continue;
                    singleton = null;
                }
            }
            if (singleton != null) {
                this.infos.add(singleton);
            }
        }

        /*
         * WARNING - void declaration
         */
        void findReferringConfigs(List<MetaTypeRegistry.RegistryEntry> entries) throws ConfigMergeException, ConfigUpdateException {
            for (MetaTypeRegistry.RegistryEntry parentEntry : entries) {
                try {
                    if (parentEntry.isSingleton()) {
                        SingletonElement parentCE = this.serverConfig.getSingleton(parentEntry.getPid(), parentEntry.getAlias());
                        if (parentCE == null) continue;
                        ConfigurationInfo info = BundleProcessor.this.changeHandler.createConfigurationInfo(parentCE, parentEntry);
                        this.addIfUnique(this.infos, info);
                        continue;
                    }
                    Map parentFactoryInstances = this.serverConfig.getFactoryInstancesUsingDefaultId(parentEntry.getPid(), parentEntry.getAlias(), parentEntry.getDefaultId());
                    for (Map.Entry entry : parentFactoryInstances.entrySet()) {
                        ConfigurationInfo info = BundleProcessor.this.changeHandler.createConfigurationInfo((ConfigElement)entry.getValue(), parentEntry);
                        this.addIfUnique(this.infos, info);
                    }
                }
                catch (ConfigNotFoundException parentFactoryInstances) {
                    void ex;
                    FFDCFilter.processException((Throwable)parentFactoryInstances, (String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", (String)"796", (Object)this, (Object[])new Object[]{entries});
                    throw new ConfigUpdateException((Exception)ex);
                }
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ConfigurationInfo processSingletonInstances(SingletonElement configElement, MetaTypeRegistry.RegistryEntry registry) throws ConfigUpdateException {
            String pid = registry.getPid();
            try {
                ExtendedConfiguration aliased;
                if (configElement == null) {
                    if (!registry.getObjectClassDefinition().hasAllRequiredDefaults()) return null;
                    String nodeName = registry.getAlias() == null ? pid : registry.getAlias();
                    configElement = new SingletonElement(nodeName, pid);
                } else if (!configElement.isEnabled()) {
                    return null;
                }
                BundleProcessor.this.validator.validateSingleton(pid, registry.getAlias());
                if (pid.equals(registry.getAlias()) || (aliased = BundleProcessor.this.configRetriever.findConfiguration(registry.getAlias())) == null || aliased.isDeleted()) return BundleProcessor.this.changeHandler.createConfigurationInfo(configElement, registry);
                aliased.delete(false);
                return BundleProcessor.this.changeHandler.createConfigurationInfo(configElement, registry);
            }
            catch (ConfigNotFoundException aliased) {
                void e;
                FFDCFilter.processException((Throwable)aliased, (String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", (String)"834", (Object)this, (Object[])new Object[]{configElement, registry});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processInstances(): Exception while processing bundle/version/pid=" + this.updateName + "/" + pid + ".  Message=" + e.getMessage()), (Object[])new Object[0]);
                }
                if (!ErrorHandler.INSTANCE.fail()) return null;
                Tr.error((TraceComponent)tc, (String)"error.parse.bundle", (Object[])new Object[]{this.updateName, pid, e.getMessage()});
                throw new ConfigUpdateException((Exception)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processFactoryInstances(MetaTypeRegistry.RegistryEntry registry, Map<ConfigID, FactoryElement> instances) throws ConfigUpdateException {
            String pid = registry.getPid();
            for (Map.Entry<ConfigID, FactoryElement> entry : instances.entrySet()) {
                try {
                    FactoryElement configElement = entry.getValue();
                    if (!configElement.isEnabled()) continue;
                    BundleProcessor.this.validator.validateFactoryInstance(pid, registry.getAlias(), entry.getKey());
                    ConfigurationInfo info = BundleProcessor.this.changeHandler.createConfigurationInfo(configElement, registry);
                    this.addIfUnique(this.infos, info);
                }
                catch (ConfigNotFoundException configElement) {
                    void e;
                    FFDCFilter.processException((Throwable)configElement, (String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", (String)"865", (Object)this, (Object[])new Object[]{registry, instances});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processFactoryInstances(): Exception while processing bundle/version/pid=" + this.updateName + "/" + pid + ".  Message=" + e.getMessage()), (Object[])new Object[0]);
                    }
                    if (!ErrorHandler.INSTANCE.fail()) continue;
                    Tr.error((TraceComponent)tc, (String)"error.parse.bundle", (Object[])new Object[]{this.updateName, pid, e.getMessage()});
                    throw new ConfigUpdateException((Exception)e);
                }
            }
        }

        private void addIfUnique(List<ConfigurationInfo> list, ConfigurationInfo info) {
            boolean insert = true;
            for (ConfigurationInfo infoAlreadyInList : list) {
                if (!info.matches(infoAlreadyInList)) continue;
                insert = false;
                break;
            }
            if (insert) {
                list.add(info);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.BundleProcessor$PIDProcessor", PIDProcessor.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }
}

