/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.config.admin.internal.SystemConfigSupportImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSConfigAdminActivator
implements BundleActivator {
    private static final TraceComponent tc = Tr.register(WSConfigAdminActivator.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private ConfigAdminServiceFactory configAdminServiceFactory = null;
    private SystemConfigSupportImpl systemConfigSupport = null;
    private ServiceTracker<WsLocationAdmin, WsLocationAdmin> locationTracker = null;
    private ServiceTracker<VariableRegistry, VariableRegistry> variableRegistryTracker = null;
    static final long serialVersionUID = -5468778861946176064L;

    /*
     * WARNING - void declaration
     */
    public void start(BundleContext bc) {
        try {
            this.locationTracker = new ServiceTracker(bc, WsLocationAdmin.class.getName(), null);
            this.locationTracker.open();
            this.variableRegistryTracker = new ServiceTracker(bc, VariableRegistry.class.getName(), null);
            this.variableRegistryTracker.open();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSConfigActivator.start():  On config error = " + this.getOnError()), (Object[])new Object[0]);
            }
            this.configAdminServiceFactory = new ConfigAdminServiceFactory(bc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSConfigActivator.start():  ConfigurationAdmin registered as a service.", (Object[])new Object[0]);
            }
            this.systemConfigSupport = new SystemConfigSupportImpl(bc, this.configAdminServiceFactory);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.config.admin.internal.WSConfigAdminActivator", (String)"85", (Object)this, (Object[])new Object[]{bc});
            this.quit(bc, (Exception)e);
        }
    }

    public void stop(BundleContext context) {
        if (this.systemConfigSupport != null) {
            this.systemConfigSupport.stop();
            this.systemConfigSupport = null;
        }
        if (this.configAdminServiceFactory != null) {
            this.configAdminServiceFactory.closeServices();
            this.configAdminServiceFactory = null;
        }
        if (null != this.locationTracker) {
            this.locationTracker.close();
            this.locationTracker = null;
        }
        if (null != this.variableRegistryTracker) {
            this.variableRegistryTracker.close();
            this.variableRegistryTracker = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSConfigActivator.stop():  ConfigurationAdmin bundle stopped.", (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void quit(BundleContext bundleContext, Exception cause) {
        Tr.audit((TraceComponent)tc, (String)"frameworkShutdown", (Object[])new Object[]{((WsLocationAdmin)this.locationTracker.getService()).getServerName()});
        try {
            Bundle bundle = bundleContext.getBundle("System Bundle");
            if (bundle != null) {
                bundle.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private OnErrorUtil.OnError getOnError() {
        OnErrorUtil.OnError onError;
        String onErrorVar;
        VariableRegistry variableRegistry = (VariableRegistry)this.variableRegistryTracker.getService();
        String onErrorVal = variableRegistry.resolveString(onErrorVar = "${onError}");
        if (onErrorVal.equals(onErrorVar)) {
            onError = OnErrorUtil.OnError.WARN;
        } else {
            String onErrorFormatted = onErrorVal.trim().toUpperCase();
            try {
                onError = Enum.valueOf(OnErrorUtil.OnError.class, onErrorFormatted);
                if (!onErrorVal.equals(onErrorFormatted)) {
                    variableRegistry.replaceVariable("onError", onErrorFormatted);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.config.admin.internal.WSConfigAdminActivator", (String)"161", (Object)this, (Object[])new Object[0]);
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"warn.config.invalid.value", (Object[])new Object[]{"onError", onErrorVal, "[IGNORE][WARN][FAIL]"});
                }
                onError = OnErrorUtil.OnError.WARN;
                variableRegistry.replaceVariable("onError", OnErrorUtil.OnError.WARN.toString());
            }
        }
        return onError;
    }
}

