/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.osgi.ProviderRegistry;
import org.apache.yoko.osgi.locator.BundleProviderLoader;
import org.apache.yoko.osgi.locator.PackageProvider;
import org.apache.yoko.osgi.locator.Register;
import org.apache.yoko.osgi.locator.ServiceProvider;

public class ProviderRegistryImpl
implements ProviderRegistry,
Register {
    private static final Logger log = Logger.getLogger(ProviderRegistryImpl.class.getName());
    private final SPIRegistry providers = new SPIRegistry();
    private final SPIRegistry serviceProviders = new SPIRegistry();
    private final ConcurrentHashMap<String, PackageProvider> packageProviders = new ConcurrentHashMap();

    public void start() {
        ProviderLocator.setRegistry(this);
    }

    public void stop() {
        ProviderLocator.setRegistry(null);
    }

    @Override
    public void registerProvider(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "registering provider " + provider);
        }
        this.providers.register(provider);
    }

    @Override
    public void unregisterProvider(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unregistering provider " + provider);
        }
        this.providers.unregister(provider);
    }

    @Override
    public void registerService(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "registering service " + provider);
        }
        this.serviceProviders.register(provider);
    }

    @Override
    public void unregisterService(ServiceProvider provider) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unregistering service " + provider);
        }
        this.serviceProviders.unregister(provider);
    }

    @Override
    public void registerPackages(PackageProvider provider) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("registering package provider: " + provider);
        }
        for (String name : provider.getRegisteredPackageNames()) {
            PackageProvider oldProvider = this.packageProviders.put(name, provider);
            if (oldProvider == null) continue;
            log.warning(String.format("Replaced provider for package %s: was %s, but now %s", name, oldProvider, provider));
        }
    }

    @Override
    public void unregisterPackages(PackageProvider provider) {
        for (String name : provider.getRegisteredPackageNames()) {
            this.packageProviders.remove(name, provider);
        }
    }

    @Override
    public Class<?> locate(String providerId) {
        ServiceProvider loader = this.providers.getProvider(providerId);
        if (loader != null) {
            try {
                return loader.getServiceClass();
            }
            catch (ClassNotFoundException cnfe) {
                throw (Error)new NoClassDefFoundError().initCause(cnfe);
            }
        }
        String packageName = PackageProvider.packageName(providerId);
        PackageProvider provider = this.packageProviders.get(packageName);
        if (provider == null) {
            return null;
        }
        return provider.loadClass(providerId);
    }

    @Override
    public Object getService(String providerId) throws Exception {
        ServiceProvider loader = this.serviceProviders.getProvider(providerId);
        if (loader != null) {
            return loader.getServiceInstance();
        }
        return null;
    }

    @Override
    public List<Object> getServices(String providerId) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (ServiceProvider sp : this.serviceProviders.getProviders(providerId)) {
            try {
                instances.add(sp.getServiceInstance());
            }
            catch (Exception exception) {}
        }
        return instances;
    }

    @Override
    public List<Class<?>> getServiceClasses(String providerId) {
        ArrayList classes = new ArrayList();
        for (ServiceProvider sp : this.serviceProviders.getProviders(providerId)) {
            try {
                classes.add(sp.getServiceClass());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to create instance of service from " + sp, e);
            }
        }
        return classes;
    }

    @Override
    public Class<?> getServiceClass(String providerId) throws ClassNotFoundException {
        ServiceProvider sp = this.serviceProviders.getProvider(providerId);
        if (sp != null) {
            return sp.getServiceClass();
        }
        return null;
    }

    @Override
    @Deprecated
    public void registerProvider(BundleProviderLoader bundleProviderLoader) {
        this.registerProvider(bundleProviderLoader.wrapAsServiceProvider());
    }

    @Override
    @Deprecated
    public void unregisterProvider(BundleProviderLoader bundleProviderLoader) {
        this.unregisterProvider(bundleProviderLoader.wrapAsServiceProvider());
    }

    @Override
    @Deprecated
    public void registerService(BundleProviderLoader bundleProviderLoader) {
        this.registerService(bundleProviderLoader.wrapAsServiceProvider());
    }

    @Override
    @Deprecated
    public void unregisterService(BundleProviderLoader bundleProviderLoader) {
        this.unregisterService(bundleProviderLoader.wrapAsServiceProvider());
    }

    private static class SPIRegistry {
        private final Map<String, Queue<ServiceProvider>> registry = new HashMap<String, Queue<ServiceProvider>>();

        private SPIRegistry() {
        }

        synchronized void register(ServiceProvider provider) {
            String providerId = provider.getId();
            Queue<ServiceProvider> q = this.registry.get(providerId);
            if (q == null) {
                q = new PriorityQueue<ServiceProvider>(2);
                this.registry.put(providerId, q);
            }
            q.add(provider);
        }

        synchronized void unregister(ServiceProvider provider) {
            Queue<ServiceProvider> q = this.registry.get(provider.getId());
            if (q != null) {
                q.remove(provider);
            }
        }

        private synchronized ServiceProvider getProvider(String id) {
            Queue<ServiceProvider> q;
            if (log.isLoggable(Level.FINE)) {
                log.fine("registry: " + this.registry);
            }
            if ((q = this.registry.get(id)) == null || q.isEmpty()) {
                return null;
            }
            return q.peek();
        }

        private synchronized Collection<ServiceProvider> getProviders(String id) {
            Queue<ServiceProvider> q = this.registry.get(id);
            if (q == null || q.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(q);
        }
    }
}

