/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.yoko.osgi.ProviderRegistry;

public enum ProviderLocator {

    private static ProviderRegistry registry;

    public static void setRegistry(ProviderRegistry registry) {
        ProviderLocator.registry = registry;
    }

    public static Class<?> locate(String providerId) {
        ProviderRegistry registry = ProviderLocator.getRegistry();
        if (registry == null) {
            return null;
        }
        return registry.locate(providerId);
    }

    public static Class<?> loadClass(String className, Class<?> contextClass) throws ClassNotFoundException {
        return ProviderLocator.loadClass(className, contextClass, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> loadClass(String className, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        block4: {
            Class<?> cls = ProviderLocator.locate(className);
            if (cls != null) {
                return cls;
            }
            if (loader != null) {
                try {
                    return Class.forName(className, false, loader);
                }
                catch (ClassNotFoundException e) {
                    if (contextClass != null) break block4;
                    throw e;
                }
            }
        }
        loader = contextClass == null ? null : contextClass.getClassLoader();
        return Class.forName(className, false, loader);
    }

    public static Object getService(String iface, Class<?> contextClass, ClassLoader loader) throws Exception {
        Object service;
        ProviderRegistry registry = ProviderLocator.getRegistry();
        if (registry != null && (service = registry.getService(iface)) != null) {
            return service;
        }
        Class<?> cls = ProviderLocator.locateServiceClass(iface, contextClass, loader);
        if (cls != null) {
            return cls.newInstance();
        }
        return null;
    }

    public static Class<?> getServiceClass(String iface, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        Class<?> cls;
        ProviderRegistry registry = ProviderLocator.getRegistry();
        if (registry != null && (cls = registry.getServiceClass(iface)) != null) {
            return cls;
        }
        return ProviderLocator.locateServiceClass(iface, contextClass, loader);
    }

    private static String locateServiceClassName(String iface, ClassLoader loader) {
        if (loader != null) {
            try {
                String service = "META-INF/services/" + iface;
                Enumeration<URL> providers = loader.getResources(service);
                while (providers.hasMoreElements()) {
                    List<String> providerNames = ProviderLocator.parseServiceDefinition(providers.nextElement());
                    if (providerNames.isEmpty()) continue;
                    return providerNames.get(0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Class<?> locateServiceClass(String iface, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        String name = ProviderLocator.locateServiceClassName(iface, loader);
        if (name == null && contextClass != null) {
            loader = contextClass.getClassLoader();
            name = ProviderLocator.locateServiceClassName(iface, loader);
        }
        return name == null ? null : ProviderLocator.loadClass(name, contextClass, loader);
    }

    private static List<String> parseServiceDefinition(URL u) {
        String url = u.toString();
        ArrayList<String> classes = new ArrayList<String>();
        if (url.endsWith("/")) {
            return classes;
        }
        String providerId = url.substring(url.lastIndexOf("/") + 1);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                int comment = line.indexOf(35);
                if (comment != -1) {
                    line = line.substring(0, comment);
                }
                if ((line = line.trim()).length() > 0) {
                    classes.add(line);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }

    private static ProviderRegistry getRegistry() {
        return registry;
    }
}

