/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Path;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ResourceUtils {
    private static final TraceComponent tc = Tr.register(ResourceUtils.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
    private static final Set<String> SERVER_PROVIDER_CLASS_NAMES = new HashSet<String>();
    static final long serialVersionUID = -6350955700076443142L;

    private ResourceUtils() {
    }

    public static Method findPostConstructMethod(Class<?> c) {
        return ResourceUtils.findPostConstructMethod(c, null);
    }

    public static Method findPostConstructMethod(Class<?> c, String name) {
        if (Object.class == c || null == c) {
            return null;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!(name != null ? m.getName().equals(name) : m.getAnnotation(PostConstruct.class) != null)) continue;
            return m;
        }
        Method m = ResourceUtils.findPostConstructMethod(c.getSuperclass(), name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPostConstructMethod(i, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private static Class<? extends Annotation> loadCDIInjectClass() {
        return AccessController.doPrivileged(new PrivilegedAction<Class<? extends Annotation>>(){
            static final long serialVersionUID = -2948642378756006139L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={ClassNotFoundException.class})
            public Class<? extends Annotation> run() {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass("javax.inject.Inject");
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.server.ResourceUtils$1", 1.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
            }
        });
    }

    public static Constructor<?> findResourceConstructor(Class<?> resourceClass, boolean perRequest) {
        LinkedList cs = new LinkedList();
        for (Constructor<?> c : resourceClass.getConstructors()) {
            Class<? extends Annotation> injectAnnotation;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findResourceConstructor - checking ctor: " + c), (Object[])new Object[0]);
            }
            Class<?>[] params = c.getParameterTypes();
            Annotation[][] anns = c.getParameterAnnotations();
            boolean match = true;
            boolean processParams = true;
            if (c.getAnnotations().length != 0 && (injectAnnotation = ResourceUtils.loadCDIInjectClass()) != null && c.getAnnotation(injectAnnotation) != null) {
                processParams = false;
            }
            if (processParams) {
                for (int i = 0; i < params.length; ++i) {
                    if (!perRequest) {
                        if (AnnotationUtils.getAnnotation((Annotation[])anns[i], Context.class) != null) continue;
                        match = false;
                        break;
                    }
                    if (AnnotationUtils.isValidParamAnnotations((Annotation[])anns[i])) continue;
                    match = false;
                    break;
                }
            }
            if (!match) continue;
            cs.add(c);
        }
        int size = cs.size();
        if (size > 1) {
            Collections.sort(cs, new Comparator<Constructor<?>>(){
                static final long serialVersionUID = -6879167725481083142L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(Constructor<?> c1, Constructor<?> c2) {
                    int p2;
                    int p1 = c1.getParameterTypes().length;
                    return p1 > (p2 = c2.getParameterTypes().length) ? -1 : (p1 < p2 ? 1 : 0);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.server.ResourceUtils$2", 2.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
                }
            });
        }
        return size == 0 ? null : (Constructor)cs.get(0);
    }

    protected static boolean isValidProvider(Class<?> c) {
        if (c == null || c == Object.class) {
            return false;
        }
        ConstrainedTo providerConstraint = c.getAnnotation(ConstrainedTo.class);
        if (providerConstraint != null && !RuntimeType.SERVER.equals((Object)providerConstraint.value())) {
            return false;
        }
        if (c.getAnnotation(Provider.class) != null) {
            return true;
        }
        for (Class<?> itf : c.getInterfaces()) {
            if (!SERVER_PROVIDER_CLASS_NAMES.contains(itf.getName())) continue;
            return true;
        }
        return ResourceUtils.isValidProvider(c.getSuperclass());
    }

    protected static boolean isValidResource(Class<?> c) {
        if (c == null || c == Object.class) {
            return false;
        }
        if (c.getAnnotation(Path.class) != null) {
            return true;
        }
        if (c.getInterfaces() != null) {
            for (Class<?> ci : c.getInterfaces()) {
                if (!ResourceUtils.isValidResource(ci)) continue;
                return true;
            }
        }
        return ResourceUtils.isValidResource(c.getSuperclass());
    }

    public static boolean isNotAbstractClass(Class<?> c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyWriter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyReader");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ExceptionMapper");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ContextResolver");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ReaderInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.WriterInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ParamConverterProvider");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerRequestFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerResponseFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.DynamicFeature");
        SERVER_PROVIDER_CLASS_NAMES.add("org.apache.cxf.jaxrs.ext.ContextResolver");
    }
}

