/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal;

import com.ibm.websphere.monitor.MonitorManager;
import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.monitor.internal.MonitorObject;
import com.ibm.ws.monitor.internal.MonitoringUtility;
import com.ibm.ws.monitor.internal.ReflectionHelper;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.packageadmin.PackageAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MonitoringFrameworkExtender
implements SynchronousBundleListener {
    public static final String MONITORING_COMPONENT_BUNDLE_HEADER = "Liberty-Monitoring-Components";
    public static final ArrayList<String> groupList = new ArrayList();
    Map<Long, Set<MonitorObject>> processedBundles = new HashMap<Long, Set<MonitorObject>>();
    public static final ConcurrentMap<Object, Set<ObjectName>> mxmap = new ConcurrentHashMap<Object, Set<ObjectName>>();
    MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    public final ConcurrentMap<Object, MonitorObject> objectMap = new ConcurrentHashMap<Object, MonitorObject>();
    private static final String MONITORING_GROUP_FILTER = "filter";
    private static final String MONITORING_TRADITIONALPMI = "enableTraditionalPMI";
    private volatile boolean isDeactivated = false;
    MonitorManager monitorManager;
    PackageAdmin packageAdmin;
    BundleContext bundleContext;
    private static final TraceComponent tc = Tr.register(MonitoringFrameworkExtender.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    static final long serialVersionUID = 5588459694464544277L;

    protected synchronized void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.bundleContext = bundleContext;
        Boolean val = (Boolean)properties.get(MONITORING_TRADITIONALPMI);
        if (val != null && val.booleanValue()) {
            PmiRegistry.enable();
        } else {
            PmiRegistry.disable();
        }
        String filter = (String)properties.get(MONITORING_GROUP_FILTER);
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ",");
            while (st.hasMoreTokens()) {
                groupList.add(st.nextToken());
            }
        }
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundleContext.getBundles()) {
            this.activateMonitors(bundle);
        }
    }

    protected synchronized void deactivate() {
        this.isDeactivated = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isDeactivated in deactivate() is", (Object[])new Object[]{this.isDeactivated});
        }
        this.bundleContext.removeBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.deactivateMonitors(bundle);
        }
        this.bundleContext = null;
    }

    protected synchronized void setMonitorManager(MonitorManager monitorManager) {
        this.monitorManager = monitorManager;
    }

    protected synchronized void unsetMonitorManager(MonitorManager monitorManager) {
        if (monitorManager == this.monitorManager) {
            this.monitorManager = null;
        }
    }

    protected void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected void unsetPackageAdmin(PackageAdmin packageAdmin) {
        if (packageAdmin == this.packageAdmin) {
            this.packageAdmin = null;
        }
    }

    public synchronized void bundleChanged(BundleEvent event) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isDeactivated in bundleChanged is", (Object[])new Object[]{this.isDeactivated});
        }
        if (!this.isDeactivated) {
            switch (event.getType()) {
                case 2: 
                case 512: {
                    this.activateMonitors(event.getBundle());
                    break;
                }
                case 4: 
                case 256: {
                    this.deactivateMonitors(event.getBundle());
                    break;
                }
            }
        }
    }

    synchronized void activateMonitors(Bundle bundle) {
        Long bundleId = bundle.getBundleId();
        if (this.processedBundles.containsKey(bundleId)) {
            return;
        }
        if (bundle.getState() != 32 && bundle.getState() != 8) {
            return;
        }
        if (bundle.getHeaders("").get(MONITORING_COMPONENT_BUNDLE_HEADER) == null) {
            return;
        }
        if (bundle.getBundleContext() == null) {
            return;
        }
        if (FrameworkState.isStopping()) {
            return;
        }
        HashSet<MonitorObject> bundleMonitors = new HashSet<MonitorObject>();
        this.processedBundles.put(bundleId, bundleMonitors);
        for (Class<?> clazz : MonitoringUtility.loadMonitoringClasses(bundle)) {
            boolean filterGroup = true;
            Monitor groups = clazz.getAnnotation(Monitor.class);
            if (groupList.size() != 0) {
                for (String group : groups.group()) {
                    filterGroup = groupList.contains(group);
                }
            }
            for (int i = 0; i < clazz.getMethods().length; ++i) {
                ProbeSite anno = clazz.getMethods()[i].getAnnotation(ProbeSite.class);
                if (anno == null) continue;
                String temp = anno.clazz();
                if (this.monitorManager == null) continue;
                this.monitorManager.updateNonExcludedClassesSet(temp);
            }
            Object monitor = this.constructMonitor(clazz);
            if (monitor == null) continue;
            MonitorObject mObject = new MonitorObject(bundleId, groups, monitor, clazz);
            this.objectMap.put(monitor, mObject);
            bundleMonitors.add(mObject);
            if (!filterGroup) continue;
            this.processANDregister(((MonitorObject)this.objectMap.get(monitor)).getMonitor(), (MonitorObject)this.objectMap.get(monitor));
        }
    }

    private void processANDregister(Object monitor, MonitorObject mob) {
        block6: {
            try {
                HashSet mxbeanset = new HashSet();
                mxmap.put(monitor, mxbeanset);
                this.processMeters(monitor);
                if (this.monitorManager != null) {
                    this.monitorManager.registerMonitor(monitor);
                    mob.setMonitor(monitor);
                    mob.setRegistered(true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Registration Successfull for object", (Object[])new Object[]{monitor});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Monitor Manager is NULL", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"processANDregister exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"processANDregister:Exception");
            }
        }
    }

    protected Object constructMonitor(Class<?> clazz) {
        Object monitor = null;
        for (Constructor<?> ctor : ReflectionHelper.getConstructors(clazz)) {
            Class<?> argType;
            Class<?>[] parameterTypes = ctor.getParameterTypes();
            if (parameterTypes.length == 0) {
                monitor = ReflectionHelper.newInstance(ctor, new Object[0]);
                continue;
            }
            if (parameterTypes.length != 1 || !(argType = parameterTypes[0]).equals(MonitorManager.class)) continue;
            monitor = ReflectionHelper.newInstance(ctor, this.monitorManager);
        }
        return monitor;
    }

    private void processMeters(Object instance) {
        block6: {
            try {
                HashSet<Field> publishedFields = new HashSet<Field>();
                Class<?> clazz = instance.getClass();
                for (Field f : clazz.getDeclaredFields()) {
                    PublishedMetric publishedMetric = f.getAnnotation(PublishedMetric.class);
                    if (publishedMetric == null) continue;
                    f.setAccessible(true);
                    if (Meter.class.isAssignableFrom(f.getType())) {
                        Object o = f.get(instance);
                        if (o == null) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("need to create MBEAN for " + o), (Object[])new Object[0]);
                        }
                        publishedFields.add(f);
                        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                        StringBuilder sb = new StringBuilder("WebSphere:");
                        sb.append("type=").append(o.getClass().getSimpleName());
                        ObjectName objectName = new ObjectName(sb.toString());
                        mbeanServer.registerMBean(o, objectName);
                        Set temp = (Set)mxmap.get(instance);
                        if (temp != null) {
                            temp.add(objectName);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"ObjectName returned from mxMap is null", (Object[])new Object[0]);
                        continue;
                    }
                    if (!MeterCollection.class.isAssignableFrom(f.getType())) continue;
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    synchronized void deactivateMonitors(Bundle bundle) {
        block3: {
            if (bundle.getSymbolicName().equals("com.ibm.ws.monitor")) {
                try {
                    MBeanServer mServer = ManagementFactory.getPlatformMBeanServer();
                    mServer.unregisterMBean(new ObjectName("WebSphere:type=Perf"));
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"Unregisterung MBean Failed due to ", (Object[])new Object[]{e.getMessage()});
                }
            }
        }
        this.unregisterMonitor(bundle.getBundleId(), null);
    }

    public synchronized void unregisterMonitor(Long bundleId, MonitorObject monitor) {
        if (monitor != null) {
            if (this.mbeanServer == null) {
                this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            Set onameSet = (Set)mxmap.remove(monitor.getMonitor());
            this.unregisterMbeans(onameSet);
            this.monitorManager.unregisterMonitor(monitor.getMonitor());
            monitor.setRegistered(false);
        } else {
            Set<MonitorObject> bundleMonitors = this.processedBundles.remove(bundleId);
            if (bundleMonitors == null) {
                return;
            }
            for (MonitorObject o : bundleMonitors) {
                Set mbeanonameset = (Set)mxmap.remove(o.getMonitor());
                this.unregisterMbeans(mbeanonameset);
                this.monitorManager.unregisterMonitor(o.getMonitor());
                o.setRegistered(false);
            }
        }
    }

    protected void modified(ComponentContext context, Map<String, Object> newProperties) throws Exception {
        try {
            groupList.clear();
            String filter = (String)newProperties.get(MONITORING_GROUP_FILTER);
            if (filter.length() <= 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Enabling All:Started", (Object[])new Object[0]);
                }
                Set monitorkeys = this.objectMap.keySet();
                for (Object monobj : monitorkeys) {
                    MonitorObject mob = (MonitorObject)this.objectMap.get(monobj);
                    if (mob.getRegistered().booleanValue()) continue;
                    Object regMon = this.constructMonitor(mob.getClazz());
                    this.processANDregister(regMon, mob);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Enabling All:Completed", (Object[])new Object[0]);
                }
                return;
            }
            StringTokenizer st = new StringTokenizer(filter, ",");
            while (st.hasMoreTokens()) {
                groupList.add(st.nextToken());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Enabling those Monitors specified in groupMonitoring and disabling those which are not specified and are already being monitored", (Object[])new Object[0]);
            }
            Set monitorkeys = this.objectMap.keySet();
            Iterator monitorIterator = monitorkeys.iterator();
            if (groupList.size() > 0) {
                while (monitorIterator.hasNext()) {
                    Object monobj = monitorIterator.next();
                    MonitorObject mob = (MonitorObject)this.objectMap.get(monobj);
                    Monitor groups = mob.getGroups();
                    for (String group : groups.group()) {
                        if (!groupList.contains(group)) {
                            this.unregisterMonitor(mob.getBundleId(), mob);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Unregistered " + group), (Object[])new Object[0]);
                            continue;
                        }
                        if (mob.getRegistered().booleanValue()) continue;
                        Object regMon = this.constructMonitor(mob.getClazz());
                        this.processANDregister(regMon, mob);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Registered " + group), (Object[])new Object[0]);
                    }
                }
            } else {
                while (monitorIterator.hasNext()) {
                    Object monobj = monitorIterator.next();
                    MonitorObject mob = (MonitorObject)this.objectMap.get(monobj);
                    if (!mob.getRegistered().booleanValue()) continue;
                    this.unregisterMonitor(mob.getBundleId(), mob);
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    private void unregisterMbeans(Set<ObjectName> onameset) {
        if (this.mbeanServer != null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (onameset == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from here is onameset is null", (Object[])new Object[0]);
            }
            return;
        }
        for (ObjectName on : onameset) {
            try {
                this.mbeanServer.unregisterMBean(on);
            }
            catch (MBeanRegistrationException e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"deactivateMonitors:MBeanRegistrationException");
            }
            catch (InstanceNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"deactivateMonitors:InstanceNotFoundException");
            }
        }
    }
}

