/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.opentracing.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.opentracing.internal.OpentracingConfiguration;
import io.openliberty.opentracing.internal.filters.ExcludeFilter;
import io.openliberty.opentracing.internal.filters.ExcludePathFilter;
import io.openliberty.opentracing.internal.filters.SpanFilter;
import io.openliberty.opentracing.internal.filters.SpanFilterType;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.opentracing"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"service.vendor=IBM"})
public class OpentracingService {
    private static final TraceComponent tc = Tr.register(OpentracingService.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
    private static String excludeFilterString = null;
    private static final String MP_METRICS_ENDPOINT = "/metrics";
    private static final String MP_METRICS_BASE_ENDPOINT = "/metrics/base|/metrics/base/.*";
    private static final String MP_METRICS_VENDOR_ENDPOINT = "/metrics/vendor|/metrics/vendor/.*";
    private static final String MP_METRICS_APPLICATION_ENDPOINT = "/metrics/application|/metrics/application/.*";
    private static final String MP_HEALTH_ENDPOINT = "/health";
    private static final String MP_OPENAPI_ENDPOINT = "/openapi";
    private static volatile SpanFilter[] allFilters = new SpanFilter[0];
    static final long serialVersionUID = -8933459563384768891L;

    @Activate
    protected void activate(Map<String, Object> map) {
        this.modified(map);
    }

    @Modified
    protected void modified(Map<String, Object> map) {
        String filterString = OpentracingConfiguration.getServerSkipPattern();
        OpentracingService.updateFilters(filterString);
    }

    private static void updateFilters(String filterString) {
        excludeFilterString = filterString;
        ArrayList<SpanFilter> filters = new ArrayList<SpanFilter>();
        OpentracingService.processFilters(filters, MP_METRICS_ENDPOINT, "excludeSpans", ExcludeFilter.class);
        OpentracingService.processFilters(filters, MP_METRICS_BASE_ENDPOINT, "excludeSpans", ExcludeFilter.class);
        OpentracingService.processFilters(filters, MP_METRICS_VENDOR_ENDPOINT, "excludeSpans", ExcludeFilter.class);
        OpentracingService.processFilters(filters, MP_METRICS_APPLICATION_ENDPOINT, "excludeSpans", ExcludeFilter.class);
        OpentracingService.processFilters(filters, MP_HEALTH_ENDPOINT, "excludeSpans", ExcludeFilter.class);
        OpentracingService.processFilters(filters, MP_OPENAPI_ENDPOINT, "excludeSpans", ExcludeFilter.class);
        if (filterString != null) {
            OpentracingService.processFilters(filters, filterString, "excludeSpans", ExcludePathFilter.class);
        }
        SpanFilter[] finalFilters = new SpanFilter[filters.size()];
        filters.toArray(finalFilters);
        allFilters = finalFilters;
    }

    @Reference(service=ConfigProviderResolver.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setConfigProvider(ConfigProviderResolver configResolver) {
    }

    /*
     * WARNING - void declaration
     */
    private static void processFilters(List<SpanFilter> filters, String pattern, String childNames, Class<? extends SpanFilter> impl) {
        String methodName = "processFilters";
        try {
            SpanFilterType type = SpanFilterType.INCOMING;
            boolean ignoreCase = false;
            boolean regex = true;
            SpanFilter filter = (SpanFilter)Class.forName(impl.getName()).getConstructor(String.class, SpanFilterType.class, Boolean.TYPE, Boolean.TYPE).newInstance(new Object[]{pattern, type, ignoreCase, regex});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processFilters", (Object[])new Object[]{"filter " + filter});
            }
            filters.add(filter);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException type) {
            void e;
            FFDCFilter.processException((Throwable)type, (String)"io.openliberty.opentracing.internal.OpentracingService", (String)"145", null, (Object[])new Object[]{filters, pattern, childNames, impl});
            throw new IllegalStateException((Throwable)e);
        }
    }

    public static boolean process(URI uri, String path, SpanFilterType type) {
        String methodName = "process";
        String newExcludeFilterString = OpentracingConfiguration.getServerSkipPattern();
        if (!OpentracingService.compare(excludeFilterString, newExcludeFilterString)) {
            OpentracingService.updateFilters(newExcludeFilterString);
        }
        boolean result = true;
        SpanFilter[] filters = allFilters;
        for (int i = 0; i < filters.length; ++i) {
            result = filters[i].process(result, uri, path, type);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"process", (Object[])new Object[]{"filter " + filters[i] + " set result to " + result});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"process", (Object[])new Object[]{"Checking to see if this request should be excluded. request uri=" + uri + ", path=" + path + " result=" + (result ? "INCLUDE" : "EXCLUDE")});
        }
        return result;
    }

    public static void addSpanErrorInfo(Span span, Throwable exception) {
        String methodName = "addSpanErrorInfo";
        span.setTag(Tags.ERROR.getKey(), true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " error"), (Object[])new Object[]{Boolean.TRUE});
        }
        if (exception != null) {
            HashMap<String, Object> log = new HashMap<String, Object>();
            log.put("event", "error");
            log.put("error.object", exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " adding log entry"), (Object[])new Object[]{log});
            }
            span.log(log);
        }
    }

    private static boolean compare(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return str1 == str2;
        }
        return str1.equals(str2);
    }
}

