/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.krb5;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpnegoUtil {
    public static final TraceComponent tc = Tr.register(SpnegoUtil.class, null, null);
    public static final byte[] SPNEGO_OID = new byte[]{6, 6, 43, 6, 1, 5, 5, 2};
    public static final byte[] KRB5_OID = new byte[]{6, 9, 42, -122, 72, -122, -9, 18, 1, 2, 2};
    static final long serialVersionUID = -7992149343083703160L;

    public String extractAuthzTokenString(String authzHeader) {
        StringTokenizer st;
        String token = null;
        if (authzHeader != null && (st = new StringTokenizer(authzHeader)) != null) {
            st.nextToken();
            if (st.hasMoreTokens()) {
                token = st.nextToken();
            }
        }
        return token;
    }

    public boolean isSpnegoOrKrb5Token(String authzHeader) {
        if (authzHeader == null || !authzHeader.startsWith("Negotiate ")) {
            return false;
        }
        return this.isSpnegoOrKrb5Token(Base64Coder.base64Decode((byte[])Base64Coder.getBytes((String)this.extractAuthzTokenString(authzHeader))));
    }

    public boolean isSpnegoOrKrb5Token(byte[] tokenByte) {
        if (tokenByte == null || tokenByte.length == 0) {
            return false;
        }
        if (this.isSpnegoOrKrb5Oid(tokenByte, SPNEGO_OID)) {
            return true;
        }
        return this.isSpnegoOrKrb5Oid(tokenByte, KRB5_OID);
    }

    private boolean isSpnegoOrKrb5Oid(byte[] tokenByte, byte[] tokenType) {
        byte[] OIDfromToken = this.getMechOidFromToken(tokenByte, tokenType.length);
        if (OIDfromToken == null || OIDfromToken.length == 0) {
            return false;
        }
        return Arrays.equals(OIDfromToken, tokenType);
    }

    private byte[] getMechOidFromToken(@Sensitive byte[] tokenByte, int length) {
        int mechOidStart = 4;
        if (tokenByte == null || tokenByte.length < length + mechOidStart) {
            return null;
        }
        byte[] OIDfromToken = new byte[length];
        for (int i = 0; i < length; ++i) {
            OIDfromToken[i] = tokenByte[i + mechOidStart];
        }
        return OIDfromToken;
    }
}

