/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class ModifyNode
extends QueryNode {
    private String abstractSchemaIdentifier;
    private String abstractSchemaName;

    @Override
    public void applyToQuery(DatabaseQuery theQuery, GenerationContext context) {
    }

    @Override
    public void validate(ParseTreeContext context) {
        String baseVariable = this.getCanonicalAbstractSchemaIdentifier();
        context.setBaseVariable(baseVariable);
        super.validate(context);
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        return null;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public String getAbstractSchemaIdentifier() {
        return this.abstractSchemaIdentifier;
    }

    public void setAbstractSchemaIdentifier(String identifierName) {
        this.abstractSchemaIdentifier = identifierName;
    }

    public String getCanonicalAbstractSchemaIdentifier() {
        String variable = this.abstractSchemaIdentifier != null ? this.abstractSchemaIdentifier : this.abstractSchemaName;
        return IdentificationVariableDeclNode.calculateCanonicalName(variable);
    }

    @Override
    public Class resolveClass(GenerationContext context) {
        String alias = this.abstractSchemaName;
        ClassDescriptor descriptor = context.getSession().getDescriptorForAlias(alias);
        if (descriptor == null) {
            throw JPQLException.entityTypeNotFound2(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), alias);
        }
        Class theClass = descriptor.getJavaClass();
        if (theClass == null) {
            throw JPQLException.resolutionClassNotFoundException2(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), alias);
        }
        return theClass;
    }
}

