/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.JavaVersion;

public enum JavaSEPlatform implements Comparable<JavaSEPlatform>
{
    v1_1(1, 1, new Version[0]),
    v1_2(1, 2, new Version[0]),
    v1_3(1, 3, new Version[0]),
    v1_4(1, 4, new Version[0]),
    v1_5(1, 5, new Version[0]),
    v1_6(1, 6, new Version[0]),
    v1_7(1, 7, new Version[0]),
    v1_8(1, 8, new Version[0]),
    v9_0(9, 0, new Version(1, 9)),
    v10_0(10, 0, new Version[0]),
    v18_3(18, 3, new Version[0]),
    v18_9(18, 9, new Version[0]);

    public static final JavaSEPlatform MIN_SUPPORTED;
    static final JavaSEPlatform LATEST;
    private static final Map<String, JavaSEPlatform> stringValuesMap;
    public static final int LENGTH;
    public static final JavaSEPlatform CURRENT;
    private final Version version;
    private final Version[] addVersions;

    static {
        MIN_SUPPORTED = v1_7;
        LATEST = v18_9;
        stringValuesMap = new HashMap<String, JavaSEPlatform>(JavaSEPlatform.values().length);
        JavaSEPlatform[] javaSEPlatformArray = JavaSEPlatform.values();
        int n = javaSEPlatformArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaSEPlatform platform = javaSEPlatformArray[n2];
            stringValuesMap.put(platform.versionString(), platform);
            Version[] additional = platform.getAdditionalVersions();
            if (additional != null) {
                Version[] versionArray = additional;
                int n3 = additional.length;
                int n4 = 0;
                while (n4 < n3) {
                    Version version = versionArray[n4];
                    stringValuesMap.put(version.versionString(), platform);
                    ++n4;
                }
            }
            ++n2;
        }
        LENGTH = JavaSEPlatform.values().length;
        CURRENT = JavaVersion.vmVersion().toPlatform();
    }

    public static boolean is(JavaSEPlatform platform) {
        return CURRENT.equals(platform);
    }

    public static boolean atLeast(JavaSEPlatform platform) {
        return CURRENT.gte(platform);
    }

    public static JavaSEPlatform toValue(String platformName) {
        if (platformName != null) {
            return stringValuesMap.get(platformName);
        }
        return null;
    }

    public static JavaSEPlatform toValue(int major, int minor) {
        switch (major) {
            case 1: {
                switch (minor) {
                    case 1: {
                        return v1_1;
                    }
                    case 2: {
                        return v1_2;
                    }
                    case 3: {
                        return v1_3;
                    }
                    case 4: {
                        return v1_4;
                    }
                    case 5: {
                        return v1_5;
                    }
                    case 6: {
                        return v1_6;
                    }
                    case 7: {
                        return v1_7;
                    }
                    case 8: {
                        return v1_8;
                    }
                    case 9: {
                        return v9_0;
                    }
                }
                return LATEST;
            }
            case 9: {
                return v9_0;
            }
            case 10: {
                return v10_0;
            }
            case 18: {
                switch (minor) {
                    case 3: {
                        return v18_3;
                    }
                    case 9: {
                        return v18_9;
                    }
                }
                return LATEST;
            }
        }
        return LATEST;
    }

    public static final String versionString(int major, int minor) {
        StringBuilder sb = new StringBuilder(4);
        sb.append(Integer.toString(major));
        sb.append('.');
        sb.append(Integer.toString(minor));
        return sb.toString();
    }

    private JavaSEPlatform(int major, int minor, Version ... addVersions) {
        this.version = new Version(major, minor);
        this.addVersions = addVersions;
    }

    public final int getMajor() {
        return this.version.major;
    }

    public final int getMinor() {
        return this.version.minor;
    }

    public final Version[] getAdditionalVersions() {
        return this.addVersions;
    }

    public boolean gte(JavaSEPlatform platform) {
        return this.compareTo(platform) >= 0;
    }

    public boolean isSupported() {
        return this.compareTo(MIN_SUPPORTED) >= 0;
    }

    public String versionString() {
        return JavaSEPlatform.versionString(this.version.major, this.version.minor);
    }

    public String toString() {
        return JavaSEPlatform.versionString(this.version.major, this.version.minor);
    }

    public static final class Version {
        private final int major;
        private final int minor;

        private Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public String versionString() {
            return JavaSEPlatform.versionString(this.major, this.minor);
        }

        public String toString() {
            return JavaSEPlatform.versionString(this.major, this.minor);
        }
    }
}

