/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ListExpressionOperator;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JavaPlatform;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class ExpressionOperator
implements Serializable {
    static final long serialVersionUID = -7066100204792043980L;
    protected int selector;
    protected String name;
    protected String[] databaseStrings;
    protected boolean isPrefix = false;
    protected boolean isRepeating = false;
    protected Class nodeClass;
    protected int type = 5;
    protected int[] argumentIndices = null;
    protected static Map<Integer, ExpressionOperator> allOperators = ExpressionOperator.initializeOperators();
    protected static Map<String, Integer> platformOperatorSelectors = ExpressionOperator.initializePlatformOperatorSelectors();
    protected static Map<Integer, String> platformOperatorNames = ExpressionOperator.initializePlatformOperatorNames();
    protected String[] javaStrings;
    protected boolean isBindingSupported = true;
    public static final int LogicalOperator = 1;
    public static final int ComparisonOperator = 2;
    public static final int AggregateOperator = 3;
    public static final int OrderOperator = 4;
    public static final int FunctionOperator = 5;
    public static final int And = 1;
    public static final int Or = 2;
    public static final int Not = 3;
    public static final int Equal = 4;
    public static final int NotEqual = 5;
    public static final int EqualOuterJoin = 6;
    public static final int LessThan = 7;
    public static final int LessThanEqual = 8;
    public static final int GreaterThan = 9;
    public static final int GreaterThanEqual = 10;
    public static final int Like = 11;
    public static final int NotLike = 12;
    public static final int In = 13;
    public static final int InSubQuery = 129;
    public static final int NotIn = 14;
    public static final int NotInSubQuery = 130;
    public static final int Between = 15;
    public static final int NotBetween = 16;
    public static final int IsNull = 17;
    public static final int NotNull = 18;
    public static final int Exists = 86;
    public static final int NotExists = 88;
    public static final int LikeEscape = 89;
    public static final int NotLikeEscape = 134;
    public static final int Decode = 105;
    public static final int Case = 117;
    public static final int NullIf = 131;
    public static final int Coalesce = 132;
    public static final int CaseCondition = 136;
    public static final int Regexp = 141;
    public static final int Count = 19;
    public static final int Sum = 20;
    public static final int Average = 21;
    public static final int Maximum = 22;
    public static final int Minimum = 23;
    public static final int StandardDeviation = 24;
    public static final int Variance = 25;
    public static final int Distinct = 87;
    public static final int As = 148;
    public static final int Union = 142;
    public static final int UnionAll = 143;
    public static final int Intersect = 144;
    public static final int IntersectAll = 145;
    public static final int Except = 146;
    public static final int ExceptAll = 147;
    public static final int Ascending = 26;
    public static final int Descending = 27;
    public static final int NullsFirst = 139;
    public static final int NullsLast = 140;
    public static final int ToUpperCase = 28;
    public static final int ToLowerCase = 29;
    public static final int Chr = 30;
    public static final int Concat = 31;
    public static final int HexToRaw = 32;
    public static final int Initcap = 33;
    public static final int Instring = 34;
    public static final int Soundex = 35;
    public static final int LeftPad = 36;
    public static final int LeftTrim = 37;
    public static final int Replace = 38;
    public static final int RightPad = 39;
    public static final int RightTrim = 40;
    public static final int Substring = 41;
    public static final int ToNumber = 42;
    public static final int Translate = 43;
    public static final int Trim = 44;
    public static final int Ascii = 45;
    public static final int Length = 46;
    public static final int CharIndex = 96;
    public static final int CharLength = 97;
    public static final int Difference = 98;
    public static final int Reverse = 99;
    public static final int Replicate = 100;
    public static final int Right = 101;
    public static final int Locate = 112;
    public static final int Locate2 = 113;
    public static final int ToChar = 114;
    public static final int ToCharWithFormat = 115;
    public static final int RightTrim2 = 116;
    public static final int Any = 118;
    public static final int Some = 119;
    public static final int All = 120;
    public static final int Trim2 = 121;
    public static final int LeftTrim2 = 122;
    public static final int SubstringSingleArg = 133;
    public static final int Cast = 137;
    public static final int Extract = 138;
    public static final int AddMonths = 47;
    public static final int DateToString = 48;
    public static final int LastDay = 49;
    public static final int MonthsBetween = 50;
    public static final int NextDay = 51;
    public static final int RoundDate = 52;
    public static final int ToDate = 53;
    public static final int Today = 54;
    public static final int AddDate = 90;
    public static final int DateName = 92;
    public static final int DatePart = 93;
    public static final int DateDifference = 94;
    public static final int TruncateDate = 102;
    public static final int NewTime = 103;
    public static final int Nvl = 104;
    public static final int CurrentDate = 123;
    public static final int CurrentTime = 128;
    public static final int Ceil = 55;
    public static final int Cos = 56;
    public static final int Cosh = 57;
    public static final int Abs = 58;
    public static final int Acos = 59;
    public static final int Asin = 60;
    public static final int Atan = 61;
    public static final int Exp = 62;
    public static final int Sqrt = 63;
    public static final int Floor = 64;
    public static final int Ln = 65;
    public static final int Log = 66;
    public static final int Mod = 67;
    public static final int Power = 68;
    public static final int Round = 69;
    public static final int Sign = 70;
    public static final int Sin = 71;
    public static final int Sinh = 72;
    public static final int Tan = 73;
    public static final int Tanh = 74;
    public static final int Trunc = 75;
    public static final int Greatest = 76;
    public static final int Least = 77;
    public static final int Add = 78;
    public static final int Subtract = 79;
    public static final int Divide = 80;
    public static final int Multiply = 81;
    public static final int Atan2 = 91;
    public static final int Cot = 95;
    public static final int Negate = 135;
    public static final int Deref = 82;
    public static final int Ref = 83;
    public static final int RefToHex = 84;
    public static final int Value = 85;
    public static final int ExtractXml = 106;
    public static final int ExtractValue = 107;
    public static final int ExistsNode = 108;
    public static final int GetStringVal = 109;
    public static final int GetNumberVal = 110;
    public static final int IsFragment = 111;
    public static final int SDO_WITHIN_DISTANCE = 124;
    public static final int SDO_RELATE = 125;
    public static final int SDO_FILTER = 126;
    public static final int SDO_NN = 127;

    public ExpressionOperator() {
        this.setNodeClass(ClassConstants.FunctionExpression_Class);
    }

    public ExpressionOperator(int selector, Vector newDatabaseStrings) {
        this.setNodeClass(ClassConstants.FunctionExpression_Class);
        this.selector = selector;
        this.printsAs(newDatabaseStrings);
    }

    public boolean isBindingSupported() {
        return this.isBindingSupported;
    }

    public void setIsBindingSupported(boolean isBindingSupported) {
        this.isBindingSupported = isBindingSupported;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionOperator operator = (ExpressionOperator)object;
        if (this.getSelector() == 0) {
            return Arrays.equals(this.getDatabaseStrings(), operator.getDatabaseStrings());
        }
        return this.getSelector() == operator.getSelector();
    }

    public int hashCode() {
        return this.getSelector();
    }

    public static ExpressionOperator abs() {
        return ExpressionOperator.simpleFunction(58, "ABS");
    }

    public static ExpressionOperator acos() {
        return ExpressionOperator.simpleFunction(59, "ACOS");
    }

    public static ExpressionOperator addDate() {
        ExpressionOperator exOperator = ExpressionOperator.simpleThreeArgumentFunction(90, "DATEADD");
        int[] indices = new int[]{1, 2, 0};
        exOperator.setArgumentIndices(indices);
        return exOperator;
    }

    public static ExpressionOperator addMonths() {
        return ExpressionOperator.simpleTwoArgumentFunction(47, "ADD_MONTHS");
    }

    public static void addOperator(ExpressionOperator exOperator) {
        allOperators.put(exOperator.getSelector(), exOperator);
    }

    public static void registerOperator(int selector, String name) {
        platformOperatorNames.put(selector, name);
        platformOperatorSelectors.put(name, selector);
    }

    public static ExpressionOperator and() {
        return ExpressionOperator.simpleLogical(1, "AND", "and");
    }

    public Object applyFunction(Object source, Vector arguments) {
        if (source instanceof String) {
            if (this.selector == 28) {
                return ((String)source).toUpperCase();
            }
            if (this.selector == 29) {
                return ((String)source).toLowerCase();
            }
            if (this.selector == 31 && arguments.size() == 1 && arguments.elementAt(0) instanceof String) {
                return ((String)source).concat((String)arguments.elementAt(0));
            }
            if (this.selector == 41 && arguments.size() == 2 && arguments.elementAt(0) instanceof Number && arguments.elementAt(1) instanceof Number) {
                int beginIndexInclusive = ((Number)arguments.elementAt(0)).intValue() - 1;
                int endIndexExclusive = beginIndexInclusive + ((Number)arguments.elementAt(1)).intValue();
                return ((String)source).substring(beginIndexInclusive, endIndexExclusive);
            }
            if (this.selector == 133 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                int beginIndexInclusive = ((Number)arguments.elementAt(0)).intValue() - 1;
                int endIndexExclusive = ((String)source).length();
                return ((String)source).substring(beginIndexInclusive, endIndexExclusive);
            }
            if (this.selector == 42) {
                return new BigDecimal((String)source);
            }
            if (this.selector == 44) {
                return ((String)source).trim();
            }
            if (this.selector == 46) {
                return ((String)source).length();
            }
        } else if (source instanceof Number) {
            if (this.selector == 55) {
                return Math.ceil(((Number)source).doubleValue());
            }
            if (this.selector == 56) {
                return Math.cos(((Number)source).doubleValue());
            }
            if (this.selector == 58) {
                return Math.abs(((Number)source).doubleValue());
            }
            if (this.selector == 59) {
                return Math.acos(((Number)source).doubleValue());
            }
            if (this.selector == 60) {
                return Math.asin(((Number)source).doubleValue());
            }
            if (this.selector == 61) {
                return Math.atan(((Number)source).doubleValue());
            }
            if (this.selector == 62) {
                return Math.exp(((Number)source).doubleValue());
            }
            if (this.selector == 63) {
                return Math.sqrt(((Number)source).doubleValue());
            }
            if (this.selector == 64) {
                return Math.floor(((Number)source).doubleValue());
            }
            if (this.selector == 66) {
                return Math.log(((Number)source).doubleValue());
            }
            if (this.selector == 68 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return Math.pow(((Number)source).doubleValue(), ((Number)arguments.elementAt(0)).doubleValue());
            }
            if (this.selector == 69) {
                return (double)Math.round(((Number)source).doubleValue());
            }
            if (this.selector == 71) {
                return Math.sin(((Number)source).doubleValue());
            }
            if (this.selector == 73) {
                return Math.tan(((Number)source).doubleValue());
            }
            if (this.selector == 76 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return Math.max(((Number)source).doubleValue(), ((Number)arguments.elementAt(0)).doubleValue());
            }
            if (this.selector == 77 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return Math.min(((Number)source).doubleValue(), ((Number)arguments.elementAt(0)).doubleValue());
            }
            if (this.selector == 78 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return ((Number)source).doubleValue() + ((Number)arguments.elementAt(0)).doubleValue();
            }
            if (this.selector == 79 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return ((Number)source).doubleValue() - ((Number)arguments.elementAt(0)).doubleValue();
            }
            if (this.selector == 80 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return ((Number)source).doubleValue() / ((Number)arguments.elementAt(0)).doubleValue();
            }
            if (this.selector == 81 && arguments.size() == 1 && arguments.elementAt(0) instanceof Number) {
                return ((Number)source).doubleValue() * ((Number)arguments.elementAt(0)).doubleValue();
            }
        }
        throw QueryException.cannotConformExpression();
    }

    public static ExpressionOperator ascending() {
        return ExpressionOperator.simpleOrdering(26, "ASC", "ascending");
    }

    public static ExpressionOperator as() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(148);
        exOperator.printsAs(" AS ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator nullsFirst() {
        return ExpressionOperator.simpleOrdering(139, "NULLS FIRST", "nullsFirst");
    }

    public static ExpressionOperator nullsLast() {
        return ExpressionOperator.simpleOrdering(140, "NULLS LAST", "nullsLast");
    }

    public static ExpressionOperator ascii() {
        return ExpressionOperator.simpleFunction(45, "ASCII");
    }

    public static ExpressionOperator asin() {
        return ExpressionOperator.simpleFunction(60, "ASIN");
    }

    public static ExpressionOperator atan() {
        return ExpressionOperator.simpleFunction(61, "ATAN");
    }

    public static ExpressionOperator average() {
        return ExpressionOperator.simpleAggregate(21, "AVG", "average");
    }

    public void bePostfix() {
        this.isPrefix = false;
    }

    public void bePrefix() {
        this.isPrefix = true;
    }

    public void beRepeating() {
        this.isRepeating = true;
    }

    public static ExpressionOperator between() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(15);
        result.setType(2);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("(");
        ((Vector)v).add(" BETWEEN ");
        ((Vector)v).add(" AND ");
        ((Vector)v).add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator caseStatement() {
        ListExpressionOperator exOperator = new ListExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(117);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.ArgumentListFunctionExpression_Class);
        exOperator.setIsBindingSupported(false);
        exOperator.setStartString("CASE ");
        exOperator.setSeparators(new String[]{" WHEN ", " THEN "});
        exOperator.setTerminationStrings(new String[]{" ELSE ", " END"});
        return exOperator;
    }

    public static ExpressionOperator caseConditionStatement() {
        ListExpressionOperator exOperator = new ListExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(136);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.ArgumentListFunctionExpression_Class);
        exOperator.setIsBindingSupported(false);
        exOperator.setStartStrings(new String[]{"CASE WHEN ", " THEN "});
        exOperator.setSeparators(new String[]{" WHEN ", " THEN "});
        exOperator.setTerminationStrings(new String[]{" ELSE ", " END "});
        return exOperator;
    }

    public static ExpressionOperator ceil() {
        return ExpressionOperator.simpleFunction(55, "CEIL");
    }

    public static ExpressionOperator charIndex() {
        return ExpressionOperator.simpleTwoArgumentFunction(96, "CHARINDEX");
    }

    public static ExpressionOperator charLength() {
        return ExpressionOperator.simpleFunction(97, "CHAR_LENGTH");
    }

    public static ExpressionOperator chr() {
        return ExpressionOperator.simpleFunction(30, "CHR");
    }

    public static ExpressionOperator coalesce() {
        ListExpressionOperator exOperator = new ListExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(132);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.ArgumentListFunctionExpression_Class);
        exOperator.setStartString("COALESCE(");
        exOperator.setSeparator(", ");
        exOperator.setTerminationString(")");
        return exOperator;
    }

    public static ExpressionOperator concat() {
        ExpressionOperator operator = ExpressionOperator.simpleMath(31, "+");
        operator.setIsBindingSupported(false);
        return operator;
    }

    public boolean conformBetween(Object left, Object right) {
        Object start = ((Vector)right).elementAt(0);
        Object end = ((Vector)right).elementAt(1);
        if (left == null || start == null || end == null) {
            return false;
        }
        if (left instanceof Number && start instanceof Number && end instanceof Number) {
            return ((Number)left).doubleValue() >= ((Number)start).doubleValue() && ((Number)left).doubleValue() <= ((Number)end).doubleValue();
        }
        if (left instanceof String && start instanceof String && end instanceof String) {
            return !(((String)left).compareTo((String)start) <= 0 && ((String)left).compareTo((String)start) != 0 || ((String)left).compareTo((String)end) >= 0 && ((String)left).compareTo((String)end) != 0);
        }
        if (left instanceof Date && start instanceof Date && end instanceof Date) {
            return !(!((Date)left).after((Date)start) && !((Date)left).equals(start) || !((Date)left).before((Date)end) && !((Date)left).equals(end));
        }
        if (left instanceof Calendar && start instanceof Calendar && end instanceof Calendar) {
            return !(!((Calendar)left).after(start) && !((Calendar)left).equals(start) || !((Calendar)left).before(end) && !((Calendar)left).equals(end));
        }
        throw QueryException.cannotConformExpression();
    }

    /*
     * Unable to fully structure code
     */
    public boolean conformLike(Object left, Object right) {
        if (right == null && left == null) {
            return true;
        }
        if (!(right instanceof String) || !(left instanceof String)) {
            throw QueryException.cannotConformExpression();
        }
        likeString = (String)right;
        if (likeString.indexOf("_") != -1) {
            throw QueryException.cannotConformExpression();
        }
        value = (String)left;
        if (likeString.indexOf("%") == -1) {
            return left.equals(right);
        }
        strictStart = likeString.startsWith("%") == false;
        strictEnd = likeString.endsWith("%") == false;
        tokens = new StringTokenizer(likeString, "%");
        lastPosition = 0;
        lastToken = null;
        if (!strictStart || value.startsWith(lastToken = tokens.nextToken())) ** GOTO lbl22
        return false;
lbl-1000:
        // 1 sources

        {
            lastToken = tokens.nextToken();
            lastPosition = value.indexOf(lastToken, lastPosition);
            if (lastPosition >= 0) continue;
            return false;
lbl22:
            // 2 sources

            ** while (tokens.hasMoreTokens())
        }
lbl23:
        // 1 sources

        if (strictEnd) {
            return value.endsWith(lastToken);
        }
        return true;
    }

    public void copyTo(ExpressionOperator operator) {
        operator.selector = this.selector;
        operator.isPrefix = this.isPrefix;
        operator.isRepeating = this.isRepeating;
        operator.nodeClass = this.nodeClass;
        operator.type = this.type;
        operator.databaseStrings = this.databaseStrings == null ? null : Helper.copyStringArray(this.databaseStrings);
        operator.argumentIndices = this.argumentIndices == null ? null : Helper.copyIntArray(this.argumentIndices);
        operator.javaStrings = this.javaStrings == null ? null : Helper.copyStringArray(this.javaStrings);
        operator.isBindingSupported = this.isBindingSupported;
    }

    public static ExpressionOperator cos() {
        return ExpressionOperator.simpleFunction(56, "COS");
    }

    public static ExpressionOperator cosh() {
        return ExpressionOperator.simpleFunction(57, "COSH");
    }

    public static ExpressionOperator cot() {
        return ExpressionOperator.simpleFunction(95, "COT");
    }

    public static ExpressionOperator count() {
        return ExpressionOperator.simpleAggregate(19, "COUNT", "count");
    }

    public static ExpressionOperator dateDifference() {
        return ExpressionOperator.simpleThreeArgumentFunction(94, "DATEDIFF");
    }

    public static ExpressionOperator dateName() {
        return ExpressionOperator.simpleTwoArgumentFunction(92, "DATENAME");
    }

    public static ExpressionOperator oracleDateName() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(92);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("TO_CHAR(");
        ((Vector)v).add(", '");
        ((Vector)v).add("')");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator datePart() {
        return ExpressionOperator.simpleTwoArgumentFunction(93, "DATEPART");
    }

    public static ExpressionOperator dateToString() {
        return ExpressionOperator.simpleFunction(48, "TO_CHAR");
    }

    public static ExpressionOperator toChar() {
        return ExpressionOperator.simpleFunction(114, "TO_CHAR");
    }

    public static ExpressionOperator toCharWithFormat() {
        return ExpressionOperator.simpleTwoArgumentFunction(115, "TO_CHAR");
    }

    public static ExpressionOperator decode() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setSelector(105);
        exOperator.setNodeClass(FunctionExpression.class);
        exOperator.setType(5);
        exOperator.bePrefix();
        return exOperator;
    }

    public static ExpressionOperator deref() {
        return ExpressionOperator.simpleFunction(82, "DEREF");
    }

    public static ExpressionOperator descending() {
        return ExpressionOperator.simpleOrdering(27, "DESC", "descending");
    }

    public static ExpressionOperator difference() {
        return ExpressionOperator.simpleTwoArgumentFunction(98, "DIFFERENCE");
    }

    public static ExpressionOperator distinct() {
        return ExpressionOperator.simpleFunction(87, "DISTINCT", "distinct");
    }

    public boolean doesRelationConform(Object left, Object right) {
        if (this.selector == 4 || this.selector == 5) {
            if (left == null && right == null) {
                return this.selector == 4;
            }
            if (left == null || right == null) {
                return this.selector == 5;
            }
            if (left instanceof Number && left instanceof Comparable && right instanceof Comparable && left.getClass().equals(right.getClass())) {
                return ((Comparable)left).compareTo((Comparable)right) == 0 == (this.selector == 4);
            }
            if (left instanceof Number && right instanceof Number && left.getClass() != right.getClass()) {
                double leftDouble = ((Number)left).doubleValue();
                double rightDouble = ((Number)right).doubleValue();
                if (Double.isNaN(leftDouble) && Double.isNaN(rightDouble)) {
                    return this.selector == 4;
                }
                return leftDouble == rightDouble == (this.selector == 4);
            }
            return left.equals(right) == (this.selector == 4);
        }
        if (this.selector == 17) {
            return left == null;
        }
        if (this.selector == 18) {
            return left != null;
        }
        if (this.selector == 7) {
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() < ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                return ((String)left).compareTo((String)right) < 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).before((Date)right);
            }
            if (left instanceof Calendar && right instanceof Calendar) {
                return ((Calendar)left).before(right);
            }
        } else if (this.selector == 8) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                int compareValue = ((String)left).compareTo((String)right);
                return compareValue < 0 || compareValue == 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).equals(right) || ((Date)left).before((Date)right);
            }
            if (left instanceof Calendar && right instanceof Calendar) {
                return ((Calendar)left).equals(right) || ((Calendar)left).before(right);
            }
        } else if (this.selector == 9) {
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() > ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                int compareValue = ((String)left).compareTo((String)right);
                return compareValue > 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).after((Date)right);
            }
            if (left instanceof Calendar && right instanceof Calendar) {
                return ((Calendar)left).after(right);
            }
        } else if (this.selector == 10) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof Number && right instanceof Number) {
                return ((Number)left).doubleValue() >= ((Number)right).doubleValue();
            }
            if (left instanceof String && right instanceof String) {
                int compareValue = ((String)left).compareTo((String)right);
                return compareValue > 0 || compareValue == 0;
            }
            if (left instanceof Date && right instanceof Date) {
                return ((Date)left).equals(right) || ((Date)left).after((Date)right);
            }
            if (left instanceof Calendar && right instanceof Calendar) {
                return ((Calendar)left).equals(right) || ((Calendar)left).after(right);
            }
        } else {
            Boolean doesConform;
            if (this.selector == 15 && right instanceof Vector && ((Vector)right).size() == 2) {
                return this.conformBetween(left, right);
            }
            if (this.selector == 16 && right instanceof Vector && ((Vector)right).size() == 2) {
                return !this.conformBetween(left, right);
            }
            if (this.selector == 13 && right instanceof Collection) {
                return ((Collection)right).contains(left);
            }
            if (this.selector == 14 && right instanceof Collection) {
                return !((Collection)right).contains(left);
            }
            if ((this.selector == 11 || this.selector == 12) && right instanceof Vector && ((Vector)right).size() == 1) {
                Boolean doesLikeConform = JavaPlatform.conformLike(left, ((Vector)right).get(0));
                if (doesLikeConform != null) {
                    if (doesLikeConform.booleanValue()) {
                        return this.selector == 11;
                    }
                    return this.selector != 11;
                }
            } else if (this.selector == 141 && right instanceof Vector && ((Vector)right).size() == 1 && (doesConform = JavaPlatform.conformRegexp(left, ((Vector)right).get(0))) != null) {
                return doesConform;
            }
        }
        throw QueryException.cannotConformExpression();
    }

    public static ExpressionOperator equalOuterJoin() {
        return ExpressionOperator.simpleRelation(6, "=*");
    }

    public static ExpressionOperator exists() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(86);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("EXISTS ");
        ((Vector)v).add(" ");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator exp() {
        return ExpressionOperator.simpleFunction(62, "EXP");
    }

    public Expression expressionFor(Expression base) {
        return this.expressionForArguments(base, NonSynchronizedVector.newInstance(0));
    }

    public Expression expressionFor(Expression base, Object value) {
        return this.newExpressionForArgument(base, value);
    }

    public Expression expressionForWithBaseLast(Expression base, Object value) {
        return this.newExpressionForArgumentWithBaseLast(base, value);
    }

    @Deprecated
    public Expression expressionForArguments(Expression base, Vector arguments) {
        return this.newExpressionForArguments(base, arguments);
    }

    public Expression expressionForArguments(Expression base, List arguments) {
        return this.newExpressionForArguments(base, arguments);
    }

    public static ExpressionOperator extractXml() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("extract(");
        ((Vector)v).add(",");
        ((Vector)v).add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setSelector(106);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator extractValue() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("extractValue(");
        ((Vector)v).add(",");
        ((Vector)v).add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setSelector(107);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator existsNode() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("existsNode(");
        ((Vector)v).add(",");
        ((Vector)v).add(")");
        result.printsAs(v);
        result.bePrefix();
        result.setSelector(108);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator getStringVal() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add(".getStringVal()");
        result.printsAs(v);
        result.bePostfix();
        result.setSelector(109);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator getNumberVal() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add(".getNumberVal()");
        result.printsAs(v);
        result.bePostfix();
        result.setSelector(110);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator isFragment() {
        ExpressionOperator result = new ExpressionOperator();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add(".isFragment()");
        result.printsAs(v);
        result.bePostfix();
        result.setSelector(111);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator floor() {
        return ExpressionOperator.simpleFunction(64, "FLOOR");
    }

    public static Map<Integer, ExpressionOperator> getAllOperators() {
        return allOperators;
    }

    public static Map<String, Integer> getPlatformOperatorSelectors() {
        return platformOperatorSelectors;
    }

    public String[] getDatabaseStrings() {
        return this.databaseStrings;
    }

    public String[] getJavaStrings() {
        return this.javaStrings;
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    public static ExpressionOperator getOperator(Integer selector) {
        return ExpressionOperator.getAllOperators().get(selector);
    }

    public int getSelector() {
        return this.selector;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public static ExpressionOperator greatest() {
        return ExpressionOperator.simpleTwoArgumentFunction(76, "GREATEST");
    }

    public static ExpressionOperator hexToRaw() {
        return ExpressionOperator.simpleFunction(32, "HEXTORAW");
    }

    public static ExpressionOperator ifNull() {
        return ExpressionOperator.simpleTwoArgumentFunction(104, "NVL");
    }

    public static ExpressionOperator in() {
        return ExpressionOperator.simpleRelation(13, "IN");
    }

    public static ExpressionOperator inSubQuery() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(5);
        result.setSelector(129);
        Vector<String> v = new Vector<String>(1);
        v.add(" IN ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator initcap() {
        return ExpressionOperator.simpleFunction(33, "INITCAP");
    }

    protected static void initializeAggregateFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.count());
        ExpressionOperator.addOperator(ExpressionOperator.sum());
        ExpressionOperator.addOperator(ExpressionOperator.average());
        ExpressionOperator.addOperator(ExpressionOperator.minimum());
        ExpressionOperator.addOperator(ExpressionOperator.maximum());
        ExpressionOperator.addOperator(ExpressionOperator.distinct());
    }

    protected static void initializeFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.notOperator());
        ExpressionOperator.addOperator(ExpressionOperator.ascending());
        ExpressionOperator.addOperator(ExpressionOperator.descending());
        ExpressionOperator.addOperator(ExpressionOperator.as());
        ExpressionOperator.addOperator(ExpressionOperator.nullsFirst());
        ExpressionOperator.addOperator(ExpressionOperator.nullsLast());
        ExpressionOperator.addOperator(ExpressionOperator.any());
        ExpressionOperator.addOperator(ExpressionOperator.some());
        ExpressionOperator.addOperator(ExpressionOperator.all());
        ExpressionOperator.addOperator(ExpressionOperator.in());
        ExpressionOperator.addOperator(ExpressionOperator.inSubQuery());
        ExpressionOperator.addOperator(ExpressionOperator.notIn());
        ExpressionOperator.addOperator(ExpressionOperator.notInSubQuery());
        ExpressionOperator.addOperator(ExpressionOperator.coalesce());
        ExpressionOperator.addOperator(ExpressionOperator.caseStatement());
        ExpressionOperator.addOperator(ExpressionOperator.caseConditionStatement());
    }

    protected static void initializeLogicalOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.and());
        ExpressionOperator.addOperator(ExpressionOperator.or());
        ExpressionOperator.addOperator(ExpressionOperator.isNull());
        ExpressionOperator.addOperator(ExpressionOperator.notNull());
    }

    public static Map initializeOperators() {
        ExpressionOperator.resetOperators();
        ExpressionOperator.initializeFunctionOperators();
        ExpressionOperator.initializeRelationOperators();
        ExpressionOperator.initializeLogicalOperators();
        ExpressionOperator.initializeAggregateFunctionOperators();
        return allOperators;
    }

    public static String getPlatformOperatorName(int operator) {
        String name = (String)ExpressionOperator.getPlatformOperatorNames().get(operator);
        if (name == null) {
            name = String.valueOf(operator);
        }
        return name;
    }

    public static Map getPlatformOperatorNames() {
        return platformOperatorNames;
    }

    public static Map<Integer, String> initializePlatformOperatorNames() {
        HashMap<Integer, String> platformOperatorNames = new HashMap<Integer, String>();
        platformOperatorNames.put(28, "ToUpperCase");
        platformOperatorNames.put(29, "ToLowerCase");
        platformOperatorNames.put(30, "Chr");
        platformOperatorNames.put(31, "Concat");
        platformOperatorNames.put(132, "Coalesce");
        platformOperatorNames.put(117, "Case");
        platformOperatorNames.put(136, "Case(codition)");
        platformOperatorNames.put(32, "HexToRaw");
        platformOperatorNames.put(33, "Initcap");
        platformOperatorNames.put(34, "Instring");
        platformOperatorNames.put(35, "Soundex");
        platformOperatorNames.put(36, "LeftPad");
        platformOperatorNames.put(37, "LeftTrim");
        platformOperatorNames.put(39, "RightPad");
        platformOperatorNames.put(40, "RightTrim");
        platformOperatorNames.put(41, "Substring");
        platformOperatorNames.put(133, "Substring");
        platformOperatorNames.put(43, "Translate");
        platformOperatorNames.put(45, "Ascii");
        platformOperatorNames.put(46, "Length");
        platformOperatorNames.put(96, "CharIndex");
        platformOperatorNames.put(97, "CharLength");
        platformOperatorNames.put(98, "Difference");
        platformOperatorNames.put(99, "Reverse");
        platformOperatorNames.put(100, "Replicate");
        platformOperatorNames.put(101, "Right");
        platformOperatorNames.put(112, "Locate");
        platformOperatorNames.put(113, "Locate");
        platformOperatorNames.put(42, "ToNumber");
        platformOperatorNames.put(114, "ToChar");
        platformOperatorNames.put(115, "ToChar");
        platformOperatorNames.put(47, "AddMonths");
        platformOperatorNames.put(48, "DateToString");
        platformOperatorNames.put(50, "MonthsBetween");
        platformOperatorNames.put(51, "NextDay");
        platformOperatorNames.put(52, "RoundDate");
        platformOperatorNames.put(90, "AddDate");
        platformOperatorNames.put(92, "DateName");
        platformOperatorNames.put(93, "DatePart");
        platformOperatorNames.put(94, "DateDifference");
        platformOperatorNames.put(102, "TruncateDate");
        platformOperatorNames.put(138, "Extract");
        platformOperatorNames.put(137, "Cast");
        platformOperatorNames.put(103, "NewTime");
        platformOperatorNames.put(104, "Nvl");
        platformOperatorNames.put(103, "NewTime");
        platformOperatorNames.put(55, "Ceil");
        platformOperatorNames.put(56, "Cos");
        platformOperatorNames.put(57, "Cosh");
        platformOperatorNames.put(58, "Abs");
        platformOperatorNames.put(59, "Acos");
        platformOperatorNames.put(60, "Asin");
        platformOperatorNames.put(61, "Atan");
        platformOperatorNames.put(62, "Exp");
        platformOperatorNames.put(63, "Sqrt");
        platformOperatorNames.put(64, "Floor");
        platformOperatorNames.put(65, "Ln");
        platformOperatorNames.put(66, "Log");
        platformOperatorNames.put(67, "Mod");
        platformOperatorNames.put(68, "Power");
        platformOperatorNames.put(69, "Round");
        platformOperatorNames.put(70, "Sign");
        platformOperatorNames.put(71, "Sin");
        platformOperatorNames.put(72, "Sinh");
        platformOperatorNames.put(73, "Tan");
        platformOperatorNames.put(74, "Tanh");
        platformOperatorNames.put(75, "Trunc");
        platformOperatorNames.put(76, "Greatest");
        platformOperatorNames.put(77, "Least");
        platformOperatorNames.put(78, "Add");
        platformOperatorNames.put(79, "Subtract");
        platformOperatorNames.put(80, "Divide");
        platformOperatorNames.put(81, "Multiply");
        platformOperatorNames.put(91, "Atan2");
        platformOperatorNames.put(95, "Cot");
        platformOperatorNames.put(82, "Deref");
        platformOperatorNames.put(83, "Ref");
        platformOperatorNames.put(84, "RefToHex");
        platformOperatorNames.put(85, "Value");
        platformOperatorNames.put(106, "ExtractXml");
        platformOperatorNames.put(107, "ExtractValue");
        platformOperatorNames.put(108, "ExistsNode");
        platformOperatorNames.put(109, "GetStringVal");
        platformOperatorNames.put(110, "GetNumberVal");
        platformOperatorNames.put(111, "IsFragment");
        platformOperatorNames.put(124, "MDSYS.SDO_WITHIN_DISTANCE");
        platformOperatorNames.put(125, "MDSYS.SDO_RELATE");
        platformOperatorNames.put(126, "MDSYS.SDO_FILTER");
        platformOperatorNames.put(127, "MDSYS.SDO_NN");
        platformOperatorNames.put(131, "NullIf");
        platformOperatorNames.put(141, "REGEXP");
        platformOperatorNames.put(142, "UNION");
        platformOperatorNames.put(143, "UNION ALL");
        platformOperatorNames.put(144, "INTERSECT");
        platformOperatorNames.put(145, "INTERSECT ALL");
        platformOperatorNames.put(146, "EXCEPT");
        platformOperatorNames.put(147, "EXCEPT ALL");
        return platformOperatorNames;
    }

    public static Map<String, Integer> initializePlatformOperatorSelectors() {
        HashMap<String, Integer> platformOperatorNames = new HashMap<String, Integer>();
        platformOperatorNames.put("ToUpperCase", 28);
        platformOperatorNames.put("ToLowerCase", 29);
        platformOperatorNames.put("Chr", 30);
        platformOperatorNames.put("Concat", 31);
        platformOperatorNames.put("Coalesce", 132);
        platformOperatorNames.put("Case", 117);
        platformOperatorNames.put("HexToRaw", 32);
        platformOperatorNames.put("Initcap", 33);
        platformOperatorNames.put("Instring", 34);
        platformOperatorNames.put("Soundex", 35);
        platformOperatorNames.put("LeftPad", 36);
        platformOperatorNames.put("LeftTrim", 37);
        platformOperatorNames.put("RightPad", 39);
        platformOperatorNames.put("RightTrim", 40);
        platformOperatorNames.put("Substring", 41);
        platformOperatorNames.put("Translate", 43);
        platformOperatorNames.put("Ascii", 45);
        platformOperatorNames.put("Length", 46);
        platformOperatorNames.put("CharIndex", 96);
        platformOperatorNames.put("CharLength", 97);
        platformOperatorNames.put("Difference", 98);
        platformOperatorNames.put("Reverse", 99);
        platformOperatorNames.put("Replicate", 100);
        platformOperatorNames.put("Right", 101);
        platformOperatorNames.put("Locate", 112);
        platformOperatorNames.put("ToNumber", 42);
        platformOperatorNames.put("ToChar", 114);
        platformOperatorNames.put("AddMonths", 47);
        platformOperatorNames.put("DateToString", 48);
        platformOperatorNames.put("MonthsBetween", 50);
        platformOperatorNames.put("NextDay", 51);
        platformOperatorNames.put("RoundDate", 52);
        platformOperatorNames.put("AddDate", 90);
        platformOperatorNames.put("DateName", 92);
        platformOperatorNames.put("DatePart", 93);
        platformOperatorNames.put("DateDifference", 94);
        platformOperatorNames.put("TruncateDate", 102);
        platformOperatorNames.put("NewTime", 103);
        platformOperatorNames.put("Nvl", 104);
        platformOperatorNames.put("NewTime", 103);
        platformOperatorNames.put("Ceil", 55);
        platformOperatorNames.put("Cos", 56);
        platformOperatorNames.put("Cosh", 57);
        platformOperatorNames.put("Abs", 58);
        platformOperatorNames.put("Acos", 59);
        platformOperatorNames.put("Asin", 60);
        platformOperatorNames.put("Atan", 61);
        platformOperatorNames.put("Exp", 62);
        platformOperatorNames.put("Sqrt", 63);
        platformOperatorNames.put("Floor", 64);
        platformOperatorNames.put("Ln", 65);
        platformOperatorNames.put("Log", 66);
        platformOperatorNames.put("Mod", 67);
        platformOperatorNames.put("Power", 68);
        platformOperatorNames.put("Round", 69);
        platformOperatorNames.put("Sign", 70);
        platformOperatorNames.put("Sin", 71);
        platformOperatorNames.put("Sinh", 72);
        platformOperatorNames.put("Tan", 73);
        platformOperatorNames.put("Tanh", 74);
        platformOperatorNames.put("Trunc", 75);
        platformOperatorNames.put("Greatest", 76);
        platformOperatorNames.put("Least", 77);
        platformOperatorNames.put("Add", 78);
        platformOperatorNames.put("Subtract", 79);
        platformOperatorNames.put("Divide", 80);
        platformOperatorNames.put("Multiply", 81);
        platformOperatorNames.put("Atan2", 91);
        platformOperatorNames.put("Cot", 95);
        platformOperatorNames.put("Deref", 82);
        platformOperatorNames.put("Ref", 83);
        platformOperatorNames.put("RefToHex", 84);
        platformOperatorNames.put("Value", 85);
        platformOperatorNames.put("Cast", 137);
        platformOperatorNames.put("Extract", 138);
        platformOperatorNames.put("ExtractXml", 106);
        platformOperatorNames.put("ExtractValue", 107);
        platformOperatorNames.put("ExistsNode", 108);
        platformOperatorNames.put("GetStringVal", 109);
        platformOperatorNames.put("GetNumberVal", 110);
        platformOperatorNames.put("IsFragment", 111);
        platformOperatorNames.put("SDO_WITHIN_DISTANCE", 124);
        platformOperatorNames.put("SDO_RELATE", 125);
        platformOperatorNames.put("SDO_FILTER", 126);
        platformOperatorNames.put("SDO_NN", 127);
        platformOperatorNames.put("NullIf", 131);
        return platformOperatorNames;
    }

    protected static void initializeRelationOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(4, "=", "equal"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(5, "<>", "notEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(7, "<", "lessThan"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(8, "<=", "lessThanEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(9, ">", "greaterThan"));
        ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(10, ">=", "greaterThanEqual"));
        ExpressionOperator.addOperator(ExpressionOperator.like());
        ExpressionOperator.addOperator(ExpressionOperator.likeEscape());
        ExpressionOperator.addOperator(ExpressionOperator.notLike());
        ExpressionOperator.addOperator(ExpressionOperator.notLikeEscape());
        ExpressionOperator.addOperator(ExpressionOperator.between());
        ExpressionOperator.addOperator(ExpressionOperator.exists());
        ExpressionOperator.addOperator(ExpressionOperator.notExists());
    }

    public static ExpressionOperator instring() {
        return ExpressionOperator.simpleTwoArgumentFunction(34, "INSTR");
    }

    public boolean isAggregateOperator() {
        return this.getType() == 3;
    }

    public boolean isComparisonOperator() {
        return this.getType() == 2;
    }

    public boolean isComplete() {
        return this.databaseStrings != null && this.databaseStrings.length != 0;
    }

    public boolean isFunctionOperator() {
        return this.getType() == 5;
    }

    public boolean isLogicalOperator() {
        return this.getType() == 1;
    }

    public static ExpressionOperator isNull() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(2);
        result.setSelector(17);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("(");
        ((Vector)v).add(" IS NULL)");
        result.printsAs(v);
        result.bePrefix();
        result.printsJavaAs(".isNull()");
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public boolean isOrderOperator() {
        return this.getType() == 4;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public static ExpressionOperator lastDay() {
        return ExpressionOperator.simpleFunction(49, "LAST_DAY");
    }

    public static ExpressionOperator least() {
        return ExpressionOperator.simpleTwoArgumentFunction(77, "LEAST");
    }

    public static ExpressionOperator leftPad() {
        return ExpressionOperator.simpleThreeArgumentFunction(36, "LPAD");
    }

    public static ExpressionOperator leftTrim() {
        return ExpressionOperator.simpleFunction(37, "LTRIM");
    }

    public static ExpressionOperator leftTrim2() {
        return ExpressionOperator.simpleTwoArgumentFunction(122, "LTRIM");
    }

    public static ExpressionOperator length() {
        return ExpressionOperator.simpleFunction(46, "LENGTH");
    }

    public static ExpressionOperator like() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(11);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("");
        ((Vector)v).add(" LIKE ");
        ((Vector)v).add("");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add(".like(");
        ((Vector)v).add(")");
        result.printsJavaAs(v);
        return result;
    }

    public static ExpressionOperator regexp() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(141);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("");
        ((Vector)v).add(" REGEXP ");
        ((Vector)v).add("");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add(".regexp(");
        ((Vector)v).add(")");
        result.printsJavaAs(v);
        return result;
    }

    public static ExpressionOperator likeEscape() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(89);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("");
        ((Vector)v).add(" LIKE ");
        ((Vector)v).add(" ESCAPE ");
        ((Vector)v).add("");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        result.setIsBindingSupported(false);
        return result;
    }

    public static ExpressionOperator notLikeEscape() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(134);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("");
        ((Vector)v).add(" NOT LIKE ");
        ((Vector)v).add(" ESCAPE ");
        ((Vector)v).add("");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        result.setIsBindingSupported(false);
        return result;
    }

    public static ExpressionOperator ln() {
        return ExpressionOperator.simpleFunction(65, "LN");
    }

    public static ExpressionOperator locate() {
        ExpressionOperator expOperator = ExpressionOperator.simpleTwoArgumentFunction(112, "LOCATE");
        int[] argumentIndices = new int[]{1, 0};
        expOperator.setArgumentIndices(argumentIndices);
        expOperator.setIsBindingSupported(false);
        return expOperator;
    }

    public static ExpressionOperator locate2() {
        ExpressionOperator expOperator = ExpressionOperator.simpleThreeArgumentFunction(113, "LOCATE");
        int[] argumentIndices = new int[]{1, 0, 2};
        expOperator.setArgumentIndices(argumentIndices);
        expOperator.setIsBindingSupported(false);
        return expOperator;
    }

    public static ExpressionOperator log() {
        return ExpressionOperator.simpleFunction(66, "LOG");
    }

    public static ExpressionOperator maximum() {
        return ExpressionOperator.simpleAggregate(22, "MAX", "maximum");
    }

    public static ExpressionOperator minimum() {
        return ExpressionOperator.simpleAggregate(23, "MIN", "minimum");
    }

    public static ExpressionOperator mod() {
        ExpressionOperator operator = ExpressionOperator.simpleTwoArgumentFunction(67, "MOD");
        operator.setIsBindingSupported(false);
        return operator;
    }

    public static ExpressionOperator monthsBetween() {
        return ExpressionOperator.simpleTwoArgumentFunction(50, "MONTHS_BETWEEN");
    }

    public Expression newExpressionForArgument(Expression base, Object singleArgument) {
        if (singleArgument == null) {
            if (this.selector == 4) {
                return base.isNull();
            }
            if (this.selector == 5) {
                return base.notNull();
            }
        }
        Expression node = this.createNode();
        node.create(base, singleArgument, this);
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Expression createNode() {
        block10: {
            if (this.nodeClass == ClassConstants.ArgumentListFunctionExpression_Class) {
                return new ArgumentListFunctionExpression();
            }
            if (this.nodeClass == ClassConstants.FunctionExpression_Class) {
                return new FunctionExpression();
            }
            if (this.nodeClass == ClassConstants.RelationExpression_Class) {
                return new RelationExpression();
            }
            if (this.nodeClass == ClassConstants.LogicalExpression_Class) {
                return new LogicalExpression();
            }
            Expression node = null;
            if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block10;
            try {
                return (Expression)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getNodeClass()));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        try {
            return (Expression)PrivilegedAccessHelper.newInstanceFromClass(this.getNodeClass());
        }
        catch (InstantiationException exception) {
            throw new InternalError(exception.toString());
        }
        catch (IllegalAccessException exception) {
            throw new InternalError(exception.toString());
        }
    }

    public Expression newExpressionForArgumentWithBaseLast(Expression base, Object singleArgument) {
        if (singleArgument == null) {
            if (this.selector == 4) {
                return base.isNull();
            }
            if (this.selector == 5) {
                return base.notNull();
            }
        }
        Expression node = this.createNode();
        node.createWithBaseLast(base, singleArgument, this);
        return node;
    }

    public Expression newExpressionForArguments(Expression base, List arguments) {
        if (arguments.size() == 1 && arguments.get(0) == null) {
            if (this.selector == 4) {
                return base.isNull();
            }
            if (this.selector == 5) {
                return base.notNull();
            }
        }
        Expression node = this.createNode();
        node.create(base, arguments, this);
        return node;
    }

    public static ExpressionOperator negate() {
        return ExpressionOperator.simpleFunction(135, "-");
    }

    public static ExpressionOperator newTime() {
        return ExpressionOperator.simpleThreeArgumentFunction(103, "NEW_TIME");
    }

    public static ExpressionOperator nextDay() {
        return ExpressionOperator.simpleTwoArgumentFunction(51, "NEXT_DAY");
    }

    public static ExpressionOperator notExists() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(88);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("NOT EXISTS ");
        ((Vector)v).add(" ");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator notIn() {
        return ExpressionOperator.simpleRelation(14, "NOT IN");
    }

    public static ExpressionOperator notInSubQuery() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(5);
        result.setSelector(130);
        Vector<String> v = new Vector<String>(1);
        v.add(" NOT IN ");
        result.printsAs(v);
        result.bePostfix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator notLike() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(12);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("");
        ((Vector)v).add(" NOT LIKE ");
        ((Vector)v).add("");
        result.printsAs(v);
        result.bePrefix();
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add(".notLike(");
        ((Vector)v).add(")");
        result.printsJavaAs(v);
        return result;
    }

    public static ExpressionOperator notNull() {
        ExpressionOperator result = new ExpressionOperator();
        result.setType(2);
        result.setSelector(18);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("(");
        ((Vector)v).add(" IS NOT NULL)");
        result.printsAs(v);
        result.bePrefix();
        result.printsJavaAs(".notNull()");
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator notOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(3);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("NOT (");
        ((Vector)v).add(")");
        result.printsAs(v);
        result.bePrefix();
        result.printsJavaAs(".not()");
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public static ExpressionOperator nullIf() {
        return ExpressionOperator.simpleTwoArgumentFunction(131, "NULLIF");
    }

    public static ExpressionOperator or() {
        return ExpressionOperator.simpleLogical(2, "OR", "or");
    }

    public static ExpressionOperator power() {
        return ExpressionOperator.simpleTwoArgumentFunction(68, "POWER");
    }

    public void printCollection(Vector items, ExpressionSQLPrinter printer) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions() && !this.isBindingSupported()) {
            printer.getCall().setUsesBinding(false);
        }
        int dbStringIndex = 0;
        try {
            if (this.isPrefix()) {
                printer.getWriter().write(this.getDatabaseStrings()[0]);
                dbStringIndex = 1;
            } else {
                dbStringIndex = 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.argumentIndices == null) {
            this.argumentIndices = new int[items.size()];
            int i = 0;
            while (i < this.argumentIndices.length) {
                this.argumentIndices[i] = i;
                ++i;
            }
        }
        int[] nArray = this.argumentIndices;
        int n = this.argumentIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            Expression item = (Expression)items.elementAt(index);
            if (this.selector == 83 || this.selector == 82 && item.isObjectExpression()) {
                DatabaseTable alias = ((ObjectExpression)item).aliasForTable(((ObjectExpression)item).getDescriptor().getTables().firstElement());
                printer.printString(alias.getNameDelimited(printer.getPlatform()));
            } else if (this.selector == 19 && item.isExpressionBuilder()) {
                printer.printString("*");
            } else {
                item.printSQL(printer);
            }
            if (dbStringIndex < this.getDatabaseStrings().length) {
                printer.printString(this.getDatabaseStrings()[dbStringIndex++]);
            }
            ++n2;
        }
    }

    public void printJavaCollection(Vector items, ExpressionJavaPrinter printer) {
        int javaStringIndex = 0;
        int i = 0;
        while (i < items.size()) {
            Expression item = (Expression)items.elementAt(i);
            item.printJava(printer);
            if (javaStringIndex < this.getJavaStrings().length) {
                printer.printString(this.getJavaStrings()[javaStringIndex++]);
            }
            ++i;
        }
    }

    public void printDuo(Expression first, Expression second, ExpressionSQLPrinter printer) {
        int dbStringIndex;
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions() && !this.isBindingSupported()) {
            printer.getCall().setUsesBinding(false);
        }
        if (this.isPrefix()) {
            printer.printString(this.getDatabaseStrings()[0]);
            dbStringIndex = 1;
        } else {
            dbStringIndex = 0;
        }
        first.printSQL(printer);
        if (dbStringIndex < this.getDatabaseStrings().length) {
            printer.printString(this.getDatabaseStrings()[dbStringIndex++]);
        }
        if (second != null) {
            second.printSQL(printer);
            if (dbStringIndex < this.getDatabaseStrings().length) {
                printer.printString(this.getDatabaseStrings()[dbStringIndex++]);
            }
        }
    }

    public void printJavaDuo(Expression first, Expression second, ExpressionJavaPrinter printer) {
        int javaStringIndex = 0;
        first.printJava(printer);
        if (javaStringIndex < this.getJavaStrings().length) {
            printer.printString(this.getJavaStrings()[javaStringIndex++]);
        }
        if (second != null) {
            second.printJava(printer);
            if (javaStringIndex < this.getJavaStrings().length) {
                printer.printString(this.getJavaStrings()[javaStringIndex]);
            }
        }
    }

    public void printsAs(String s) {
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).add(s);
        this.printsAs(v);
    }

    public void printsAs(Vector dbStrings) {
        this.databaseStrings = new String[dbStrings.size()];
        int i = 0;
        while (i < dbStrings.size()) {
            this.getDatabaseStrings()[i] = (String)dbStrings.elementAt(i);
            ++i;
        }
    }

    public void printsJavaAs(String s) {
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).add(s);
        this.printsJavaAs(v);
    }

    public void printsJavaAs(Vector dbStrings) {
        this.javaStrings = new String[dbStrings.size()];
        int i = 0;
        while (i < dbStrings.size()) {
            this.getJavaStrings()[i] = (String)dbStrings.elementAt(i);
            ++i;
        }
    }

    public static ExpressionOperator ref() {
        return ExpressionOperator.simpleFunction(83, "REF");
    }

    public static ExpressionOperator refToHex() {
        return ExpressionOperator.simpleFunction(84, "REFTOHEX");
    }

    public static ExpressionOperator replace() {
        ExpressionOperator operator = ExpressionOperator.simpleThreeArgumentFunction(38, "REPLACE");
        operator.setIsBindingSupported(false);
        return operator;
    }

    public static ExpressionOperator replicate() {
        return ExpressionOperator.simpleTwoArgumentFunction(100, "REPLICATE");
    }

    public static void resetOperators() {
        allOperators = new HashMap<Integer, ExpressionOperator>();
    }

    public static ExpressionOperator reverse() {
        return ExpressionOperator.simpleFunction(99, "REVERSE");
    }

    public static ExpressionOperator right() {
        return ExpressionOperator.simpleTwoArgumentFunction(101, "RIGHT");
    }

    public static ExpressionOperator rightPad() {
        return ExpressionOperator.simpleThreeArgumentFunction(39, "RPAD");
    }

    public static ExpressionOperator rightTrim() {
        return ExpressionOperator.simpleFunction(40, "RTRIM");
    }

    public static ExpressionOperator rightTrim2() {
        return ExpressionOperator.simpleTwoArgumentFunction(116, "RTRIM");
    }

    public static ExpressionOperator round() {
        return ExpressionOperator.simpleTwoArgumentFunction(69, "ROUND");
    }

    public static ExpressionOperator roundDate() {
        return ExpressionOperator.simpleTwoArgumentFunction(52, "ROUND");
    }

    public void setArgumentIndices(int[] indices) {
        this.argumentIndices = indices;
    }

    public void setNodeClass(Class nodeClass) {
        this.nodeClass = nodeClass;
    }

    public void setSelector(int selector) {
        this.selector = selector;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static ExpressionOperator sign() {
        return ExpressionOperator.simpleFunction(70, "SIGN");
    }

    public static ExpressionOperator simpleAggregate(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(3);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add(String.valueOf(databaseName) + "(");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.printsJavaAs("." + javaName + "()");
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleFunction(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        exOperator.setName(databaseName);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add(String.valueOf(databaseName) + "(");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleFunctionNoParentheses(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).add(databaseName);
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleFunction(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = ExpressionOperator.simpleFunction(selector, databaseName);
        exOperator.printsJavaAs("." + javaName + "()");
        return exOperator;
    }

    public static ExpressionOperator simpleLogical(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(1);
        exOperator.setSelector(selector);
        exOperator.printsAs(" " + databaseName + " ");
        exOperator.bePostfix();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("." + javaName + "(");
        ((Vector)v).add(")");
        exOperator.printsJavaAs(v);
        exOperator.setNodeClass(ClassConstants.LogicalExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleMath(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setIsBindingSupported(false);
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("(");
        ((Vector)v).add(" " + databaseName + " ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleOrdering(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(4);
        exOperator.setSelector(selector);
        exOperator.printsAs(" " + databaseName);
        exOperator.bePostfix();
        exOperator.printsJavaAs("." + javaName + "()");
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleRelation(int selector, String databaseName) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(2);
        exOperator.setSelector(selector);
        exOperator.printsAs(" " + databaseName + " ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.RelationExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleRelation(int selector, String databaseName, String javaName) {
        ExpressionOperator exOperator = ExpressionOperator.simpleRelation(selector, databaseName);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("." + javaName + "(");
        ((Vector)v).add(")");
        exOperator.printsJavaAs(v);
        return exOperator;
    }

    public static ExpressionOperator simpleThreeArgumentFunction(int selector, String dbString) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        exOperator.setName(dbString);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(4);
        ((Vector)v).add(String.valueOf(dbString) + "(");
        ((Vector)v).add(", ");
        ((Vector)v).add(", ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleTwoArgumentFunction(int selector, String dbString) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        exOperator.setName(dbString);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add(String.valueOf(dbString) + "(");
        ((Vector)v).add(", ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator simpleLogicalNoParens(int selector, String dbString) {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(selector);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("");
        ((Vector)v).add(" " + dbString + " ");
        ((Vector)v).add("");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sin() {
        return ExpressionOperator.simpleFunction(71, "SIN");
    }

    public static ExpressionOperator sinh() {
        return ExpressionOperator.simpleFunction(72, "SINH");
    }

    public static ExpressionOperator soundex() {
        return ExpressionOperator.simpleFunction(35, "SOUNDEX");
    }

    public static ExpressionOperator sqrt() {
        return ExpressionOperator.simpleFunction(63, "SQRT");
    }

    public static ExpressionOperator standardDeviation() {
        return ExpressionOperator.simpleAggregate(24, "STDDEV", "standardDeviation");
    }

    public static ExpressionOperator substring() {
        ExpressionOperator operator = ExpressionOperator.simpleThreeArgumentFunction(41, "SUBSTR");
        operator.setIsBindingSupported(false);
        return operator;
    }

    public static ExpressionOperator substringSingleArg() {
        return ExpressionOperator.simpleTwoArgumentFunction(133, "SUBSTR");
    }

    public static ExpressionOperator sum() {
        return ExpressionOperator.simpleAggregate(20, "SUM", "sum");
    }

    public static ExpressionOperator sybaseAddMonthsOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(47);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("DATEADD(month, ");
        ((Vector)v).add(", ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseAtan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATN2");
    }

    public static ExpressionOperator sybaseInStringOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(34);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("CHARINDEX(");
        ((Vector)v).add(", ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] indices = nArray;
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToNumberOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(42);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("CONVERT(NUMERIC, ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToDateToStringOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(48);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("CONVERT(CHAR, ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToDateOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(53);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("CONVERT(DATETIME, ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToCharOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(114);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).add("CONVERT(CHAR, ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseToCharWithFormatOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(115);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(3);
        ((Vector)v).add("CONVERT(CHAR, ");
        ((Vector)v).add(",");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator sybaseLocateOperator() {
        ExpressionOperator result = ExpressionOperator.simpleTwoArgumentFunction(112, "CHARINDEX");
        int[] argumentIndices = new int[]{1, 0};
        result.setArgumentIndices(argumentIndices);
        return result;
    }

    public static ExpressionOperator sybaseLocate2Operator() {
        ExpressionOperator result = new ExpressionOperator();
        result.setSelector(113);
        result.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance();
        ((Vector)v).add("CASE (CHARINDEX(");
        ((Vector)v).add(", SUBSTRING(");
        ((Vector)v).add(",");
        ((Vector)v).add(", CHAR_LENGTH(");
        ((Vector)v).add(")))) WHEN 0 THEN 0 ELSE (CHARINDEX(");
        ((Vector)v).add(", SUBSTRING(");
        ((Vector)v).add(",");
        ((Vector)v).add(", CHAR_LENGTH(");
        ((Vector)v).add("))) + ");
        ((Vector)v).add(" - 1) END");
        result.printsAs(v);
        int[] indices = new int[]{1, 0, 2, 0, 1, 0, 2, 0, 2};
        result.setArgumentIndices(indices);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        result.bePrefix();
        return result;
    }

    public static ExpressionOperator tan() {
        return ExpressionOperator.simpleFunction(73, "TAN");
    }

    public static ExpressionOperator tanh() {
        return ExpressionOperator.simpleFunction(74, "TANH");
    }

    public static ExpressionOperator toDate() {
        return ExpressionOperator.simpleFunction(53, "TO_DATE");
    }

    public static ExpressionOperator today() {
        return ExpressionOperator.currentTimeStamp();
    }

    public static ExpressionOperator currentTimeStamp() {
        return ExpressionOperator.simpleFunctionNoParentheses(54, "CURRENT_TIMESTAMP");
    }

    public static ExpressionOperator currentDate() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT_DATE");
    }

    public static ExpressionOperator currentTime() {
        return ExpressionOperator.simpleFunctionNoParentheses(128, "CURRENT_TIME");
    }

    public static ExpressionOperator toLowerCase() {
        return ExpressionOperator.simpleFunction(29, "LOWER", "toLowerCase");
    }

    public static ExpressionOperator toNumber() {
        return ExpressionOperator.simpleFunction(42, "TO_NUMBER");
    }

    public String toString() {
        if (this.getDatabaseStrings() == null || this.getDatabaseStrings().length == 0) {
            return "platform operator - " + ExpressionOperator.getPlatformOperatorName(this.selector);
        }
        return "operator " + Arrays.asList(this.getDatabaseStrings());
    }

    public static ExpressionOperator toUpperCase() {
        return ExpressionOperator.simpleFunction(28, "UPPER", "toUpperCase");
    }

    public static ExpressionOperator translate() {
        ExpressionOperator operator = ExpressionOperator.simpleThreeArgumentFunction(43, "TRANSLATE");
        operator.setIsBindingSupported(false);
        return operator;
    }

    public static ExpressionOperator trim() {
        return ExpressionOperator.simpleFunction(44, "TRIM");
    }

    public static ExpressionOperator trim2() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(121);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("TRIM(");
        ((Vector)v).add(" FROM ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        exOperator.setIsBindingSupported(false);
        return exOperator;
    }

    public static ExpressionOperator trunc() {
        return ExpressionOperator.simpleTwoArgumentFunction(75, "TRUNC");
    }

    public static ExpressionOperator truncateDate() {
        return ExpressionOperator.simpleTwoArgumentFunction(102, "TRUNC");
    }

    public static ExpressionOperator cast() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(137);
        exOperator.setName("CAST");
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("CAST(");
        ((Vector)v).add(" AS ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator extract() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(138);
        exOperator.setName("EXTRACT");
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).add("EXTRACT(");
        ((Vector)v).add(" FROM ");
        ((Vector)v).add(")");
        exOperator.printsAs(v);
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator value() {
        return ExpressionOperator.simpleFunction(85, "VALUE");
    }

    public static ExpressionOperator variance() {
        return ExpressionOperator.simpleAggregate(25, "VARIANCE", "variance");
    }

    public static ExpressionOperator any() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(118);
        exOperator.printsAs("ANY");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator some() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(119);
        exOperator.printsAs("SOME");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator all() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(120);
        exOperator.printsAs("ALL");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator union() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(142);
        exOperator.printsAs("UNION ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator unionAll() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(143);
        exOperator.printsAs("UNION ALL ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator intersect() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(144);
        exOperator.printsAs("INTERSECT ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator intersectAll() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(145);
        exOperator.printsAs("INTERSECT ALL ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator except() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(146);
        exOperator.printsAs("EXCEPT ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator exceptAll() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(147);
        exOperator.printsAs("EXCEPT ALL ");
        exOperator.bePostfix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public boolean isAny() {
        return this.selector == 118 || this.selector == 119;
    }

    public boolean isAll() {
        return this.selector == 120;
    }

    public boolean isAnyOrAll() {
        return this.isAny() || this.isAll();
    }
}

