/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager.utils;

import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.TraceFactory;
import java.io.PrintWriter;
import java.util.Date;

public abstract class AbstractTrace
implements Trace {
    private Class sourceClass;
    private String traceGroup;
    TraceFactory traceFactory;
    boolean debugEnabled = false;
    boolean eventEnabled = false;
    boolean entryEnabled = false;
    static final String ls = System.lineSeparator();
    static final String DEAD_CHAR = ".";

    public AbstractTrace(Class sourceClass, String traceGroup, TraceFactory traceFactory) {
        this.sourceClass = sourceClass;
        this.traceGroup = traceGroup;
        this.traceFactory = traceFactory;
    }

    protected final void setLevel(int traceLevel) {
        switch (traceLevel) {
            case 1: {
                this.debugEnabled = true;
                this.eventEnabled = true;
                this.entryEnabled = true;
                break;
            }
            case 2: {
                this.debugEnabled = false;
                this.eventEnabled = false;
                this.entryEnabled = true;
                break;
            }
            case 3: {
                this.debugEnabled = true;
                this.eventEnabled = false;
                this.entryEnabled = false;
                break;
            }
            case 4: {
                this.debugEnabled = false;
                this.eventEnabled = true;
                this.entryEnabled = false;
                break;
            }
            case 5: {
                this.debugEnabled = false;
                this.eventEnabled = false;
                this.entryEnabled = false;
                break;
            }
        }
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public String getTraceGroup() {
        return this.traceGroup;
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public final boolean isEntryEnabled() {
        return this.entryEnabled;
    }

    @Override
    public final boolean isEventEnabled() {
        return this.eventEnabled;
    }

    @Override
    public final void bytes(Class sourceClass, byte[] data) {
        if (data == null) {
            this.bytes(null, sourceClass, data, 0, 0);
        } else {
            this.bytes(null, sourceClass, data, 0, data.length);
        }
    }

    @Override
    public final void bytes(Class sourceClass, byte[] data, int start) {
        if (data == null) {
            this.bytes(null, sourceClass, data, start, 0);
        } else {
            this.bytes(null, sourceClass, data, start, data.length);
        }
    }

    @Override
    public final void bytes(Class sourceClass, byte[] data, int start, int count) {
        this.bytes(null, sourceClass, data, start, count);
    }

    @Override
    public final void bytes(Object source, Class sourceClass, byte[] data) {
        if (data == null) {
            this.bytes(source, sourceClass, data, 0, 0);
        } else {
            this.bytes(source, sourceClass, data, 0, data.length);
        }
    }

    @Override
    public final void bytes(Object source, Class sourceClass, byte[] data, int start) {
        if (data == null) {
            this.bytes(source, sourceClass, data, start, 0);
        } else {
            this.bytes(source, sourceClass, data, start, data.length);
        }
    }

    @Override
    public abstract void bytes(Object var1, Class var2, byte[] var3, int var4, int var5);

    @Override
    public final void debug(Class sourceClass, String methodName) {
        this.debug((Object)null, sourceClass, methodName, null);
    }

    @Override
    public final void debug(Class sourceClass, String methodName, Object object) {
        this.debug((Object)null, sourceClass, methodName, new Object[]{object});
    }

    @Override
    public final void debug(Class sourceClass, String methodName, Object[] objects) {
        this.debug((Object)null, sourceClass, methodName, objects);
    }

    @Override
    public final void debug(Object source, Class sourceClass, String methodName) {
        this.debug(source, sourceClass, methodName, null);
    }

    @Override
    public final void debug(Object source, Class sourceClass, String methodName, Object object) {
        this.debug(source, sourceClass, methodName, new Object[]{object});
    }

    @Override
    public abstract void debug(Object var1, Class var2, String var3, Object[] var4);

    @Override
    public final void entry(Class sourceClass, String methodName) {
        this.entry((Object)null, sourceClass, methodName, null);
    }

    @Override
    public final void entry(Class sourceClass, String methodName, Object object) {
        this.entry((Object)null, sourceClass, methodName, new Object[]{object});
    }

    @Override
    public final void entry(Class sourceClass, String methodName, Object[] objects) {
        this.entry((Object)null, sourceClass, methodName, objects);
    }

    @Override
    public final void entry(Object source, Class sourceClass, String methodName) {
        this.entry(source, sourceClass, methodName, null);
    }

    @Override
    public final void entry(Object source, Class sourceClass, String methodName, Object object) {
        this.entry(source, sourceClass, methodName, new Object[]{object});
    }

    @Override
    public abstract void entry(Object var1, Class var2, String var3, Object[] var4);

    @Override
    public final void exit(Class sourceClass, String methodName) {
        this.exit(null, sourceClass, methodName, null);
    }

    @Override
    public final void exit(Class sourceClass, String methodName, Object object) {
        this.exit((Object)null, sourceClass, methodName, new Object[]{object});
    }

    @Override
    public final void exit(Class sourceClass, String methodName, Object[] objects) {
        this.exit((Object)null, sourceClass, methodName, objects);
    }

    @Override
    public final void exit(Object source, Class sourceClass, String methodName) {
        this.exit(source, sourceClass, methodName, null);
    }

    @Override
    public final void exit(Object source, Class sourceClass, String methodName, Object object) {
        this.exit(source, sourceClass, methodName, new Object[]{object});
    }

    @Override
    public abstract void exit(Object var1, Class var2, String var3, Object[] var4);

    @Override
    public final void event(Class sourceClass, String methodName, Throwable throwable) {
        this.event(null, sourceClass, methodName, throwable);
    }

    @Override
    public abstract void event(Object var1, Class var2, String var3, Throwable var4);

    @Override
    public final void info(Class sourceClass, String methodName, String messageIdentifier, Object object) {
        this.info((Object)null, sourceClass, methodName, messageIdentifier, new Object[]{object});
    }

    @Override
    public final void info(Object source, Class sourceClass, String methodName, String messageIdentifier, Object object) {
        this.info(source, sourceClass, methodName, messageIdentifier, new Object[]{object});
    }

    @Override
    public final void info(Class sourceClass, String methodName, String messageIdentifier, Object[] objects) {
        this.info((Object)null, sourceClass, methodName, messageIdentifier, objects);
    }

    @Override
    public void info(Object source, Class sourceClass, String methodName, String messageIdentifier, Object[] objects) {
        PrintWriter printWriter = this.traceFactory.getPrintWriter();
        if (printWriter != null) {
            printWriter.println(new Date() + " " + sourceClass.getName() + ":" + methodName + "\n" + this.traceFactory.nls.format(messageIdentifier, objects));
        }
    }

    private static String pad(String s, int l) {
        return AbstractTrace.pad(s, l, null);
    }

    private static String pad(String s, int l, String p) {
        String rc;
        if (p == null) {
            p = "0";
        }
        if (s.length() < l) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < l - s.length(); ++i) {
                sb.append(p);
            }
            rc = new String(sb.toString() + s);
        } else {
            rc = s.substring(s.length() - l);
        }
        return rc;
    }

    private static String dup(int i) {
        return new String("                          " + i + " duplicate line(s) suppressed" + ls);
    }

    public static String formatBytes(byte[] data, int start, int count, boolean displayCharRepresentations) {
        StringBuffer sb = new StringBuffer();
        if (data != null) {
            int len = data.length;
            sb.append(ls + "Length = 0x" + Integer.toHexString(len) + " (" + len + ") bytes start=" + start + " count=" + count + ls + ls);
            if (displayCharRepresentations) {
                sb.append("        offset        : 0 1 2 3  4 5 6 7  8 9 A B  C D E F     0 2 4 6 8 A C E " + ls);
            } else {
                sb.append("        offset        : 0 1 2 3  4 5 6 7  8 9 A B  C D E F" + ls);
            }
            int suppress = 0;
            int end = start + count;
            String[] c = new String[16];
            String[] p = new String[16];
            String[] str = new String[16];
            for (int j = 0; j < 16; ++j) {
                c[j] = null;
                str[j] = null;
            }
            for (int i = 0; i < len; i += 16) {
                int j;
                boolean skip = true;
                for (j = 0; j < 16; ++j) {
                    int t = i + j;
                    if (t >= start && t < end && t < len) {
                        c[j] = AbstractTrace.pad(Integer.toHexString(data[t]), 2);
                        str[j] = c[j].equalsIgnoreCase("00") || c[j].equalsIgnoreCase("09") || c[j].equalsIgnoreCase("0a") || c[j].equalsIgnoreCase("0b") || c[j].equalsIgnoreCase("0c") || c[j].equalsIgnoreCase("0d") || c[j].equalsIgnoreCase("07") ? DEAD_CHAR : new String(data, t, 1);
                        skip = false;
                        continue;
                    }
                    c[j] = "  ";
                    str[j] = DEAD_CHAR;
                }
                if (skip) {
                    if (suppress > 0) {
                        sb.append(AbstractTrace.dup(suppress));
                    }
                    suppress = 0;
                    c[0] = null;
                    continue;
                }
                if (c[0].equals(p[0]) && c[1].equals(p[1]) && c[2].equals(p[2]) && c[3].equals(p[3]) && c[4].equals(p[4]) && c[5].equals(p[5]) && c[6].equals(p[6]) && c[7].equals(p[7]) && c[8].equals(p[8]) && c[9].equals(p[9]) && c[10].equals(p[10]) && c[11].equals(p[11]) && c[12].equals(p[12]) && c[13].equals(p[13]) && c[14].equals(p[14]) && c[15].equals(p[15])) {
                    ++suppress;
                    continue;
                }
                if (suppress > 0) {
                    sb.append(AbstractTrace.dup(suppress));
                }
                sb.append("0x" + AbstractTrace.pad(Integer.toHexString(i), 8) + " (" + AbstractTrace.pad(new Integer(i).toString(), 8, " ") + ") : ");
                sb.append(c[0] + c[1] + c[2] + c[3] + " " + c[4] + c[5] + c[6] + c[7] + " " + c[8] + c[9] + c[10] + c[11] + " " + c[12] + c[13] + c[14] + c[15]);
                if (displayCharRepresentations) {
                    sb.append("  | ");
                    sb.append(str[0] + str[1] + str[2] + str[3] + str[4] + str[5] + str[6] + str[7] + str[8] + str[9] + str[10] + str[11] + str[12] + str[13] + str[14] + str[15]);
                }
                sb.append(ls);
                for (j = 0; j < 16; ++j) {
                    p[j] = c[j];
                }
                suppress = 0;
            }
            if (suppress > 0) {
                sb.append(AbstractTrace.dup(suppress));
            }
        }
        return sb.toString();
    }
}

