/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;

public abstract class ObjectStore
implements Printable {
    private static final Class cclass = ObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    protected static final Long objectManagerStateIdentifier = new Long(0L);
    protected static final Long namedObjectTreeIdentifier = new Long(1L);
    protected static final long initialSequenceNumber = 100L;
    public static final int STRATEGY_KEEP_ALWAYS = 0;
    public static final int STRATEGY_KEEP_UNTIL_NEXT_OPEN = 1;
    public static final int STRATEGY_SAVE_ONLY_ON_SHUTDOWN = 2;
    public static final String[] strategyNames = new String[]{"KEEP_ALWAYS", "KEEP_UNTIL_NEXT_OPEN", "SAVE_ONLY_ON_SHUTDOWN"};
    protected static final int IDENTIFIER_NOT_SET = -1;
    public static final boolean gatherStatistics = true;
    private transient boolean _storeFullWaitForCheckPoint = false;

    protected abstract void open(ObjectManagerState var1) throws ObjectManagerException;

    protected abstract ManagedObject get(Token var1) throws ObjectManagerException;

    protected abstract Token like(Token var1);

    public abstract Token allocate(ManagedObject var1) throws ObjectManagerException;

    protected abstract void reserve(int var1, boolean var2) throws ObjectManagerException;

    protected abstract void add(ManagedObject var1, boolean var2) throws ObjectManagerException;

    protected abstract void remove(Token var1, boolean var2) throws ObjectManagerException;

    public abstract void deRegister() throws ObjectManagerException;

    protected abstract void clear() throws ObjectManagerException;

    protected abstract void close() throws ObjectManagerException;

    protected abstract void flush() throws ObjectManagerException;

    protected abstract int getIdentifier();

    protected abstract void setIdentifier(int var1) throws ObjectManagerException;

    public abstract String getName();

    public abstract void setName(String var1) throws ObjectManagerException;

    abstract void setLogicalName(String var1);

    protected abstract ObjectManagerState getObjectManagerState();

    public abstract int getStoreStrategy();

    public abstract boolean getPersistence();

    public abstract boolean getContainsRestartData();

    public abstract boolean getUsesSerializedForm();

    public abstract int getAddSpaceOverhead();

    public abstract Set tokens();

    public abstract Map captureStatistics() throws ObjectManagerException;

    public boolean validate(PrintStream printStream) throws ObjectManagerException {
        return true;
    }

    @Override
    public abstract void print(PrintWriter var1);

    public final boolean getStoreFullWaitForCheckPoint() {
        return this._storeFullWaitForCheckPoint;
    }

    public final void setStoreFullWaitForCheckPoint(boolean storeFullWaitForCheckPoint) {
        this._storeFullWaitForCheckPoint = storeFullWaitForCheckPoint;
    }
}

