/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

class ConcurrentHashMap
extends AbstractMap {
    private static final Class cclass;
    private static Trace trace;
    private static int numberOfProcessors;
    private Map[] subMaps;
    public static final boolean gatherStatistics = false;
    private int[] subMapAccessFrequency;

    protected ConcurrentHashMap() {
        this(numberOfProcessors);
    }

    public ConcurrentHashMap(int subMapCount) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{new Integer(subMapCount)});
        }
        this.subMaps = new Map[subMapCount];
        for (int i = 0; i < this.subMaps.length; ++i) {
            this.subMaps[i] = this.makeSubMap();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    Map makeSubMap() {
        return new HashMap();
    }

    private final Map getSubMap(Object key) {
        int index = key.hashCode();
        index += ~(index << 8);
        index ^= index >>> 9;
        index &= Integer.MAX_VALUE;
        return this.subMaps[index %= this.subMaps.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object get(Object key) {
        Object returnValue;
        Map subMap;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", "key=" + key + "Object");
        }
        Map map = subMap = this.getSubMap(key);
        synchronized (map) {
            returnValue = subMap.get(key);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "get", "returns retuenVaue=" + returnValue + "(Object)");
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object put(Object key, Object value) {
        Map subMap;
        Object foundObject = null;
        Map map = subMap = this.getSubMap(key);
        synchronized (map) {
            foundObject = subMap.put(key, value);
        }
        return foundObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object putIfAbsent(Object key, Object value) {
        Map subMap;
        Object foundObject = null;
        Map map = subMap = this.getSubMap(key);
        synchronized (map) {
            foundObject = subMap.get(key);
            if (foundObject == null) {
                subMap.put(key, value);
            }
        }
        return foundObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object remove(Object key) {
        Map subMap;
        Map map = subMap = this.getSubMap(key);
        synchronized (map) {
            return subMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object removeOne() {
        int index;
        int firstIndex = index = new Random(Thread.currentThread().hashCode()).nextInt(this.subMaps.length);
        Object removedObject = null;
        do {
            Map subMap;
            Map map = subMap = this.subMaps[index];
            synchronized (map) {
                if (!subMap.isEmpty()) {
                    Iterator iterator = subMap.values().iterator();
                    removedObject = iterator.next();
                    iterator.remove();
                    break;
                }
            }
            if (++index != this.subMaps.length) continue;
            index = 0;
        } while (index != firstIndex);
        return removedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        for (int i = 0; i < this.subMaps.length; ++i) {
            Map map = this.subMaps[i];
            synchronized (map) {
                this.subMaps[i].clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long clear(long numberToClear) {
        long numberRemainingToClear = numberToClear;
        int index = new Random(Thread.currentThread().hashCode()).nextInt(this.subMaps.length);
        int numberEmpty = 0;
        while (numberRemainingToClear > 0L && numberEmpty < this.subMaps.length) {
            Map subMap;
            Map map = subMap = this.subMaps[index];
            synchronized (map) {
                if (!subMap.isEmpty()) {
                    Iterator iterator = subMap.entrySet().iterator();
                    iterator.next();
                    iterator.remove();
                    --numberRemainingToClear;
                    numberEmpty = 0;
                } else {
                    ++numberEmpty;
                }
            }
            if (++index != this.subMaps.length) continue;
            index = 0;
        }
        return numberToClear - numberRemainingToClear;
    }

    @Override
    public int size() {
        int count = 0;
        if (this.subMaps != null) {
            for (int i = 0; i < this.subMaps.length; ++i) {
                count += this.subMaps[i].size();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set entrySet() {
        HashSet combinedSet = new HashSet();
        if (this.subMaps != null) {
            for (int i = 0; i < this.subMaps.length; ++i) {
                Map map = this.subMaps[i];
                synchronized (map) {
                    combinedSet.addAll(this.subMaps[i].entrySet());
                    continue;
                }
            }
        }
        return combinedSet;
    }

    protected Map captureStatistics() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        HashMap<String, String> statistics = new HashMap<String, String>();
        String histogram = " ";
        for (int n = 0; n < this.subMapAccessFrequency.length; ++n) {
            histogram = histogram + this.subMapAccessFrequency[n] + " ";
            this.subMapAccessFrequency[n] = 0;
        }
        statistics.put("subMapAccessFrequency", histogram);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", new Object[]{statistics});
        }
        return statistics;
    }

    @Override
    public String toString() {
        return new String(cclass.getName() + "/" + (this.subMaps == null ? 0 : this.subMaps.length) + "/" + Integer.toHexString(this.hashCode()));
    }

    static {
        block2: {
            cclass = ConcurrentHashMap.class;
            trace = ObjectManager.traceFactory.getTrace(ConcurrentHashMap.class, "ObjectManagerMaps");
            numberOfProcessors = 1;
            try {
                Method availableProcessorsMethod = Runtime.class.getMethod("availableProcessors", new Class[0]);
                Integer integer = (Integer)availableProcessorsMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
                numberOfProcessors = integer;
            }
            catch (Exception exception) {
                if (!Tracing.isAnyTracingEnabled() || !trace.isEventEnabled()) break block2;
                trace.event(cclass, "<init>", exception);
            }
        }
    }
}

