/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.credentials.CredentialProvider;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CredentialProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "type=SPNEGO"})
public class GSSCredentialProvider
implements CredentialProvider {
    private static final TraceComponent tc = Tr.register(GSSCredentialProvider.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    static final long serialVersionUID = 4345413796064227933L;

    @Activate
    protected void activate() {
    }

    @Deactivate
    protected void deactivate() {
    }

    public void setCredential(Subject subject) throws CredentialException {
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSubjectValid(Subject subject) {
        block3: {
            GSSCredential gssCredential = SubjectHelper.getGSSCredentialFromSubject((Subject)subject);
            try {
                if (gssCredential == null || gssCredential.getRemainingLifetime() > 0) {
                    return true;
                }
            }
            catch (GSSException gSSException) {
                void e;
                FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.ws.security.spnego.GSSCredentialProvider", (String)"51", (Object)this, (Object[])new Object[]{subject});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"There was a problem getting the gssCrendential remaining life time.", (Object[])new Object[]{e});
            }
        }
        return false;
    }
}

